/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import flaxbeard.immersivepetroleum.api.crafting.IPMultiblockRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;

public class DistillationTowerRecipe
extends IPMultiblockRecipe {
    public static Map<ResourceLocation, DistillationTowerRecipe> recipes = new HashMap<ResourceLocation, DistillationTowerRecipe>();
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final FluidTagInput input;
    private final ItemStack[] itemOutput;
    private final double[] chances;

    public static DistillationTowerRecipe findRecipe(FluidStack input) {
        if (!recipes.isEmpty()) {
            for (DistillationTowerRecipe recipe : recipes.values()) {
                if (recipe.input == null || !recipe.input.testIgnoringAmount(input)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Nullable
    public static DistillationTowerRecipe getRecipe(ResourceLocation id) {
        return recipes.get(id);
    }

    @Nullable
    public static DistillationTowerRecipe loadFromNBT(CompoundTag nbt) {
        FluidStack input = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("input"));
        return DistillationTowerRecipe.findRecipe(input);
    }

    public DistillationTowerRecipe(ResourceLocation id, FluidStack[] fluidOutput, ItemStack[] itemOutput, FluidTagInput input, int energy, int time, double[] chances) {
        super(IPRecipeTypes.DISTILLATION, id, time, energy);
        this.itemOutput = itemOutput;
        this.chances = chances;
        this.input = input;
        this.fluidInputList = Collections.singletonList(input);
        this.fluidOutputList = Arrays.asList(fluidOutput);
        this.outputList = Lazy.of(() -> {
            NonNullList output = NonNullList.m_122779_();
            for (ItemStack stack : this.itemOutput) {
                output.add((Object)stack.m_41777_());
            }
            return output;
        });
        this.modifyTimeAndEnergy(() -> IPServerConfig.REFINING.distillationTower_timeModifier.get(), () -> IPServerConfig.REFINING.distillationTower_energyModifier.get());
    }

    public FluidTagInput getInputFluid() {
        return this.input;
    }

    public double[] chances() {
        return this.chances;
    }

    protected IERecipeSerializer<DistillationTowerRecipe> getIESerializer() {
        return (IERecipeSerializer)Serializers.DISTILLATION_SERIALIZER.get();
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        NonNullList outputs = this.getItemOutputs();
        if (outputs != null && !outputs.isEmpty()) {
            return ((ItemStack)outputs.get(0)).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getActualItemOutputs() {
        if (this.itemOutput.length == 0 && this.chances.length == 0) {
            return NonNullList.m_122779_();
        }
        NonNullList output = NonNullList.m_122779_();
        for (int i = 0; i < this.itemOutput.length; ++i) {
            double chance = this.chances[i];
            if (chance != 1.0 && !((double)RANDOM.m_188501_() <= chance)) continue;
            output.add((Object)this.itemOutput[i].m_41777_());
        }
        return output;
    }
}

