/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.client.ClientProxy;
import flaxbeard.immersivepetroleum.common.CommonEventHandler;
import flaxbeard.immersivepetroleum.common.CommonProxy;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPRegisters;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import flaxbeard.immersivepetroleum.common.IPToolShaders;
import flaxbeard.immersivepetroleum.common.ReservoirRegionDataStorage;
import flaxbeard.immersivepetroleum.common.cfg.IPClientConfig;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.RecipeReloadListener;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.util.commands.IslandCommand;
import flaxbeard.immersivepetroleum.common.util.loot.IPLootFunctions;
import java.util.function.Supplier;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="immersivepetroleum")
public class ImmersivePetroleum {
    public static final String MODID = "immersivepetroleum";
    public static final Logger log = LogManager.getLogger((String)"immersivepetroleum");
    public static final CommonProxy proxy = (CommonProxy)DistExecutor.safeRunForDist(ImmersivePetroleum.bootstrapErrorToXCPInDev(() -> ClientProxy::new), ImmersivePetroleum.bootstrapErrorToXCPInDev(() -> CommonProxy::new));

    public static <T> Supplier<T> bootstrapErrorToXCPInDev(Supplier<T> in) {
        if (FMLLoader.isProduction()) {
            return in;
        }
        return () -> {
            try {
                return in.get();
            }
            catch (BootstrapMethodError e) {
                throw new RuntimeException(e);
            }
        };
    }

    public ImmersivePetroleum(FMLJavaModLoadingContext modContext) {
        modContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)IPServerConfig.ALL);
        modContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)IPClientConfig.ALL);
        IEventBus eBus = modContext.getModEventBus();
        eBus.addListener(this::setup);
        eBus.addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.addListener(this::worldLoad);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommand);
        MinecraftForge.EVENT_BUS.addListener(this::addReloadListeners);
        IPRegisters.addRegistersToEventBus(eBus);
        IPContent.modConstruction(eBus);
        IPLootFunctions.modConstruction(eBus);
        IPRecipeTypes.modConstruction(eBus);
    }

    public void setup(FMLCommonSetupEvent event) {
        proxy.setup();
        proxy.preInit();
        IPContent.preInit();
        IPPacketHandler.preInit();
        IPToolShaders.preInit();
        proxy.preInitEnd();
        IPContent.init((ParallelDispatchEvent)event);
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
        proxy.init();
        proxy.postInit();
        ReservoirHandler.recalculateChances();
        ExternalModContent.init();
        proxy.registerContainersAndScreens();
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        proxy.completed((ParallelDispatchEvent)event);
    }

    public void registerCommand(RegisterCommandsEvent event) {
        LiteralArgumentBuilder ip = Commands.m_82127_((String)"ip");
        ip.then(IslandCommand.create());
        event.getDispatcher().register(ip);
    }

    public void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new RecipeReloadListener(event.getServerResources()));
    }

    public void worldLoad(LevelEvent.Load event) {
        ServerLevel world;
        LevelAccessor levelAccessor;
        if (!event.getLevel().m_5776_() && (levelAccessor = event.getLevel()) instanceof ServerLevel && (world = (ServerLevel)levelAccessor).m_46472_() == Level.f_46428_) {
            ReservoirRegionDataStorage.init(world.m_8895_());
            world.m_8895_().m_164861_(IPSaveData::new, IPSaveData::new, "ImmersivePetroleum-SaveData");
        }
    }

    public void serverStarting(ServerStartingEvent event) {
        ReservoirHandler.recalculateChances();
    }
}

