/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.events;

import com.direwolf20.buildinggadgets2.util.DimBlockPos;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.TagPos;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ServerBuildList {
    public Level level;
    public ArrayList<StatePos> statePosList;
    public ArrayList<TagPos> teData;
    public byte renderType;
    public UUID playerUUID;
    public int originalSize;
    public ArrayList<StatePos> actuallyBuildList = new ArrayList();
    public boolean needItems;
    public boolean returnItems;
    public ItemStack gadget;
    public UUID buildUUID;
    public BuildType buildType;
    public boolean dropContents;
    public ArrayList<BlockPos> retryList = new ArrayList();
    public BlockPos cutStart = BlockPos.f_121853_;
    public BlockPos lookingAt = BlockPos.f_121853_;
    public DimBlockPos boundPos;
    public int direction;

    public ServerBuildList(Level level, ArrayList<StatePos> statePosList, byte renderType, UUID playerUUID, boolean needItems, boolean returnItems, UUID buildUUID, ItemStack gadget, BuildType buildType, boolean dropContents, BlockPos lookingAt, DimBlockPos boundPos, int direction) {
        this.level = level;
        this.statePosList = statePosList;
        this.renderType = renderType;
        this.playerUUID = playerUUID;
        this.originalSize = statePosList.size();
        this.needItems = needItems;
        this.buildUUID = buildUUID;
        this.returnItems = returnItems;
        this.gadget = gadget.m_41777_();
        this.buildType = buildType;
        this.dropContents = dropContents;
        this.lookingAt = lookingAt;
        this.boundPos = boundPos;
        this.direction = direction;
    }

    public void addToBuiltList(StatePos statePos) {
        this.actuallyBuildList.add(statePos);
    }

    public void updateActuallyBuiltList(StatePos statePos) {
        for (StatePos entry : this.actuallyBuildList) {
            if (!entry.pos.equals((Object)statePos.pos)) continue;
            entry.state = statePos.state;
            break;
        }
    }

    public CompoundTag getTagForPos(BlockPos pos) {
        CompoundTag compoundTag = new CompoundTag();
        if (this.teData == null || this.teData.isEmpty()) {
            return compoundTag;
        }
        BlockPos blockPos = pos.m_121996_((Vec3i)this.lookingAt);
        Iterator<TagPos> iterator = this.teData.iterator();
        while (iterator.hasNext()) {
            TagPos data = iterator.next();
            if (!data.pos.equals((Object)blockPos)) continue;
            compoundTag = data.tag;
            iterator.remove();
            break;
        }
        return compoundTag;
    }

    public Direction getDirection() {
        if (this.direction == -1) {
            return null;
        }
        return Direction.values()[this.direction];
    }

    public static enum BuildType {
        BUILD,
        EXCHANGE,
        DESTROY,
        UNDO_DESTROY,
        CUT;

    }
}

