/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.activation_range;

import java.util.function.Predicate;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.data.activation_range.ActivationRangeConfig;
import me.wesley1808.servercore.common.config.data.activation_range.ActivationType;
import me.wesley1808.servercore.common.config.data.activation_range.CustomActivationType;
import me.wesley1808.servercore.common.utils.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ActivationRange {
    private static final double MINIMUM_MOVEMENT = 0.001;
    private static final Predicate<Goal> BEE_GOAL_IMMUNITIES = goal -> goal instanceof Bee.BeeGoToKnownFlowerGoal || goal instanceof Bee.BeeGoToHiveGoal;
    private static final Activity[] VILLAGER_PANIC_IMMUNITIES = new Activity[]{Activity.f_37987_, Activity.f_37986_, Activity.f_37985_, Activity.f_37984_};

    public static ActivationType initializeEntityActivationType(Entity entity) {
        ActivationRangeConfig config = Config.get().activationRange();
        for (CustomActivationType type : config.activationTypes()) {
            for (EntityTypeTest<? super Entity, ?> entityTypeTest : type.matchers()) {
                if (entityTypeTest.m_141992_((Object)entity) == null) continue;
                return type;
            }
        }
        return config.defaultActivationType();
    }

    public static boolean isExcluded(Entity entity) {
        ActivationType type = entity.servercore$getActivationType();
        int tickInterval = type.tickInterval();
        return tickInterval == 0 || tickInterval == 1 || type.activationRange() <= 0 || entity instanceof Player || entity instanceof ThrowableItemProjectile || entity instanceof EnderDragon || entity instanceof EnderDragonPart || entity instanceof WitherBoss || entity instanceof Fireball || entity instanceof LightningBolt || entity instanceof PrimedTnt || entity instanceof EndCrystal || entity instanceof FireworkRocketEntity || entity instanceof EyeOfEnder || entity instanceof ThrownTrident || Config.get().activationRange().excludedEntityTypes().contains(entity.m_6095_());
    }

    public static void activateEntities(ServerLevel level, int currentTick) {
        ActivationRangeConfig config = Config.get().activationRange();
        if (!config.enabled()) {
            return;
        }
        int maxRange = Integer.MIN_VALUE;
        for (CustomActivationType type : config.activationTypes()) {
            maxRange = Math.max(type.activationRange(), maxRange);
        }
        maxRange = Math.min((level.m_7654_().m_6846_().m_11312_() << 4) - 8, maxRange);
        for (ServerPlayer player : level.m_6907_()) {
            if (player.m_5833_()) continue;
            AABB maxBB = player.m_20191_().m_82377_((double)maxRange, 256.0, (double)maxRange);
            for (Entity entity : level.m_45933_((Entity)player, maxBB)) {
                ActivationRange.activateEntity(player, entity, currentTick, config);
            }
        }
    }

    private static void activateEntity(ServerPlayer player, Entity entity, int currentTick, ActivationRangeConfig config) {
        if (currentTick > entity.servercore$getActivatedTick() && (entity.servercore$isExcluded() || ActivationRange.isWithinRange(player, entity, config))) {
            entity.servercore$setActivatedTick(currentTick + 19);
        }
    }

    private static boolean isWithinRange(ServerPlayer player, Entity entity, ActivationRangeConfig config) {
        ActivationType type = entity.servercore$getActivationType();
        int range = type.activationRange();
        int chessboardDistance = Math.max(Math.abs(player.m_146903_() - entity.m_146903_()), Math.abs(player.m_146907_() - entity.m_146907_()));
        if (chessboardDistance > range) {
            return false;
        }
        if (config.useVerticalRange()) {
            int deltaY = entity.m_146904_() - player.m_146904_();
            return deltaY <= range && deltaY >= -range || deltaY > 0 && type.extraHeightUp() || deltaY < 0 && type.extraHeightDown();
        }
        return true;
    }

    public static int checkEntityImmunities(Entity entity, int currentTick, ActivationRangeConfig config) {
        int inactiveWakeUpImmunity = ActivationRange.checkInactiveWakeup(entity, currentTick);
        if (inactiveWakeUpImmunity > -1) {
            return inactiveWakeUpImmunity;
        }
        if (entity.m_20094_() > 0) {
            return 2;
        }
        if (entity.servercore$getActivatedImmunityTick() >= currentTick) {
            return 1;
        }
        if (!entity.m_6084_()) {
            return 40;
        }
        if (entity.m_20069_() && entity.m_6063_() && !(entity instanceof AgeableMob) && !(entity instanceof Villager) && !(entity instanceof Boat)) {
            return 100;
        }
        if (entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
            Vec3 movement = entity.m_20184_();
            if (Math.abs(movement.f_82479_) > 0.001 || Math.abs(movement.f_82481_) > 0.001 || movement.f_82480_ > 0.001) {
                return 20;
            }
        }
        if (!(entity instanceof AbstractArrow)) {
            if (!(entity.m_20096_() || entity.m_20069_() || entity instanceof FlyingMob || entity instanceof Bat)) {
                return 10;
            }
        } else {
            AbstractArrow projectile = (AbstractArrow)entity;
            if (!projectile.f_36703_) {
                return 1;
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.f_20899_ || !living.m_21220_().isEmpty() || living.m_6147_()) {
                return 1;
            }
            if (living instanceof Mob) {
                Creeper creeper;
                Llama llama;
                Mob mob = (Mob)living;
                if (mob.m_5448_() != null || mob.m_6274_().m_21874_(MemoryModuleType.f_26372_)) {
                    return 20;
                }
                if (mob instanceof Bee) {
                    Bee bee = (Bee)mob;
                    if (bee.f_27699_.m_28086_() || bee.m_21660_() || Util.hasTasks(bee.f_21345_, BEE_GOAL_IMMUNITIES)) {
                        return 20;
                    }
                }
                if (mob instanceof Villager) {
                    int immunityAfter;
                    Villager villager = (Villager)mob;
                    Brain brain = villager.m_6274_();
                    if (config.villagerTickPanic()) {
                        for (Activity activity : VILLAGER_PANIC_IMMUNITIES) {
                            if (!brain.m_21954_(activity)) continue;
                            return 100;
                        }
                    }
                    if ((immunityAfter = config.villagerWorkImmunityAfter()) > 0 && currentTick - mob.servercore$getActivatedTick() >= immunityAfter && brain.m_21954_(Activity.f_37980_)) {
                        return config.villagerWorkImmunityFor();
                    }
                }
                if (mob instanceof Llama && (llama = (Llama)mob).m_30811_()) {
                    return 1;
                }
                if (mob instanceof Animal) {
                    Sheep sheep;
                    Animal animal = (Animal)mob;
                    if (animal.m_6162_() || animal.m_27593_()) {
                        return 5;
                    }
                    if (mob instanceof Sheep && (sheep = (Sheep)mob).m_29875_()) {
                        return 1;
                    }
                }
                if (mob instanceof Creeper && (creeper = (Creeper)mob).m_32311_()) {
                    return 20;
                }
                if (Util.hasTasks(mob.f_21346_)) {
                    return 0;
                }
            }
        }
        return -1;
    }

    public static boolean checkIfActive(Entity entity, int currentTick) {
        boolean active;
        ActivationRangeConfig config = Config.get().activationRange();
        if (ActivationRange.shouldTick(entity, config)) {
            return true;
        }
        boolean bl = active = entity.servercore$getActivatedTick() >= currentTick;
        if (!active) {
            int immunity;
            int inactiveTicks = currentTick - entity.servercore$getActivatedTick() - 1;
            if (inactiveTicks % 20 == 0 && (immunity = ActivationRange.checkEntityImmunities(entity, currentTick, config)) >= 0) {
                entity.servercore$setActivatedTick(currentTick + immunity);
                return true;
            }
            int tickInterval = entity.servercore$getActivationType().tickInterval();
            if (tickInterval > 0 && inactiveTicks % tickInterval == 0) {
                return true;
            }
        } else if (config.skipNonImmune() && entity.servercore$getFullTickCount() % 4 == 0 && ActivationRange.checkEntityImmunities(entity, currentTick, config) < 0) {
            return false;
        }
        return active;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldTick(Entity entity, ActivationRangeConfig config) {
        if (!config.enabled()) return true;
        if (entity.servercore$isExcluded()) return true;
        if (entity.f_19817_) return true;
        if (entity.m_20092_()) return true;
        if (entity.f_19797_ < 200) {
            if (entity.servercore$getActivationType() == config.defaultActivationType()) return true;
            if (config.tickNewEntities()) return true;
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob.f_21357_ instanceof Player) return true;
        }
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity living = (LivingEntity)entity;
        if (living.f_20916_ <= 0) return false;
        return true;
    }

    private static int checkInactiveWakeup(Entity entity, int currentTick) {
        int wakeupInterval = entity.servercore$getActivationType().wakeupInterval();
        if (wakeupInterval > 0 && (long)(currentTick - entity.servercore$getActivatedTick()) >= (long)wakeupInterval * 20L) {
            return 100;
        }
        return -1;
    }
}

