/*
 * Decompiled with CFR 0.152.
 */
package dev.tr3ymix.cfm_wap.forge;

import dev.tr3ymix.cfm_wap.block.CircuitBreakerBlock;
import dev.tr3ymix.cfm_wap.blockentity.CircuitBreakerBlockEntity;
import dev.tr3ymix.cfm_wap.util.Utils;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="cfm_wap", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeEvents {
    private ForgeEvents() {
    }

    static void onAttachCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        BlockEntity entity = (BlockEntity)event.getObject();
        if (entity instanceof CircuitBreakerBlockEntity) {
            CircuitBreakerBlockEntity breaker = (CircuitBreakerBlockEntity)entity;
            event.addCapability(Utils.resource("energy"), (ICapabilityProvider)new EnergyStorageProvider(breaker));
        }
    }

    private static class EnergyStorageProvider
    implements ICapabilityProvider {
        private final LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.of(() -> (IEnergyStorage)blockEntity.ENERGY_STORAGE.asPlatformHandler());
        private final BlockEntity blockEntity;

        public EnergyStorageProvider(CircuitBreakerBlockEntity blockEntity) {
            this.blockEntity = blockEntity;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
            BlockState state;
            if (capability == ForgeCapabilities.ENERGY && (state = this.blockEntity.m_58900_()).m_61138_((Property)CircuitBreakerBlock.DIRECTION) && state.m_61143_((Property)CircuitBreakerBlock.DIRECTION) == arg) {
                return this.lazyEnergyHandler.cast();
            }
            return LazyOptional.empty();
        }
    }
}

