/*
 * Decompiled with CFR 0.152.
 */
package dev.tr3ymix.cfm_wap.energy;

import dev.tr3ymix.cfm_wap.energy.EnergyHandlerFactory;

public class CommonEnergyStorage {
    private int energy;
    private final int capacity;
    private final int maxTransfer;

    public CommonEnergyStorage(int capacity, int maxTransfer) {
        this.capacity = capacity;
        this.energy = 0;
        this.maxTransfer = maxTransfer;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getMaxTransfer() {
        return this.maxTransfer;
    }

    public void setEnergy(int energy) {
        this.energy = Math.min(energy, this.capacity);
    }

    public int insertEnergy(int amount, boolean simulate) {
        int space = this.capacity - this.energy;
        int inserted = Math.min(amount, space);
        if (!simulate) {
            this.energy += inserted;
        }
        return inserted;
    }

    public int extractEnergy(int amount, boolean simulate) {
        int extracted = Math.min(amount, this.energy);
        if (!simulate) {
            this.energy -= extracted;
        }
        return extracted;
    }

    public Object asPlatformHandler() {
        return EnergyHandlerFactory.from(this);
    }
}

