/*
 * Decompiled with CFR 0.152.
 */
package dev.tr3ymix.cfm_wap.client.gui.screen;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.OnOffSlider;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import dev.tr3ymix.cfm_wap.Config;
import dev.tr3ymix.cfm_wap.inventory.CircuitBreakerMenu;
import dev.tr3ymix.cfm_wap.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class CircuitBreakerScreen
extends AbstractContainerScreen<CircuitBreakerMenu> {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/gui/container/circuit_breaker.png");
    protected OnOffSlider slider;

    public CircuitBreakerScreen(CircuitBreakerMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.slider = (OnOffSlider)this.m_142416_((GuiEventListener)new OnOffSlider(this.f_97735_ + this.f_97726_ - 22 - 6, this.f_97736_ + 5, (Component)Utils.translation("gui", "generator_toggle", new Object[0]), btn -> Network.getPlay().sendToServer((IMessage)new MessageTogglePower())));
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.slider.setEnabled(((CircuitBreakerMenu)this.f_97732_).isEnabled());
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((CircuitBreakerMenu)this.f_97732_).getEnergy() > 0) {
            int energyLevel = (int)(60.0f * ((float)((CircuitBreakerMenu)this.f_97732_).getEnergy() / (float)((CircuitBreakerMenu)this.f_97732_).getMaxEnergy()));
            graphics.m_280218_(TEXTURE, this.f_97735_ + 26, this.f_97736_ + 17 + 60 - energyLevel, 176, 60 - energyLevel, 6, energyLevel);
        }
        Status status = this.getStatus();
        graphics.m_280163_(IconButton.ICON_TEXTURES, this.f_97735_ + 66, this.f_97736_ + 29, (float)status.iconU, (float)status.iconV, 10, 10, 64, 64);
        graphics.m_280163_(IconButton.ICON_TEXTURES, this.f_97735_ + 66, this.f_97736_ + 46, 0.0f, 10.0f, 10, 10, 64, 64);
        if (ScreenHelper.isMouseWithinBounds((double)mouseX, (double)mouseY, (int)(this.f_97735_ + 26), (int)(this.f_97736_ + 17), (int)6, (int)60)) {
            this.m_257404_((Component)Utils.translation("gui", "progress", ((CircuitBreakerMenu)this.f_97732_).getEnergy(), ((CircuitBreakerMenu)this.f_97732_).getMaxEnergy()));
        }
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        Status status = this.getStatus();
        graphics.m_280614_(this.f_96547_, status.label, 80, 30, status.textColour, true);
        Pair<Component, Integer> pair = this.getNodeCount();
        graphics.m_280614_(this.f_96547_, (Component)pair.left(), 80, 47, ((Integer)pair.right()).intValue(), true);
    }

    private Pair<Component, Integer> getNodeCount() {
        int nodeCount = ((CircuitBreakerMenu)this.f_97732_).getNodeCount();
        int maxNodeCount = (Integer)Config.SERVER.electricity.maximumNodesInCircuitBreakerNetwork.get();
        MutableComponent label = Utils.translation("gui", "node_count", nodeCount, maxNodeCount);
        int textColour = nodeCount > maxNodeCount ? -3983818 : -1;
        return Pair.of((Object)label, (Object)textColour);
    }

    private Status getStatus() {
        if (((CircuitBreakerMenu)this.f_97732_).isOverloaded()) {
            return Status.OVERLOADED;
        }
        if (((CircuitBreakerMenu)this.f_97732_).isEnabled()) {
            if (((CircuitBreakerMenu)this.f_97732_).isPowered()) {
                return Status.ONLINE;
            }
            if (((CircuitBreakerMenu)this.f_97732_).getEnergy() == 0) {
                return Status.NO_ENERGY;
            }
        }
        return Status.OFFLINE;
    }

    private static enum Status {
        ONLINE(-8799453, 50, 0, (Component)Utils.translation("gui", "status.online", new Object[0])),
        OFFLINE(-3983818, 40, 0, (Component)Utils.translation("gui", "status.offline", new Object[0])),
        OVERLOADED(-2711764, 30, 0, (Component)Utils.translation("gui", "status.overloaded", new Object[0])),
        NO_ENERGY(-2711764, 20, 20, (Component)Utils.translation("gui", "status.energy", new Object[0]));

        private final int textColour;
        private final int iconU;
        private final int iconV;
        private final Component label;

        private Status(int textColour, int iconU, int iconV, Component label) {
            this.textColour = textColour;
            this.iconU = iconU;
            this.iconV = iconV;
            this.label = label;
        }
    }
}

