/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.ecostackmanager.entity;

import de.markusbordihn.ecostackmanager.Constants;
import de.markusbordihn.ecostackmanager.config.ItemEntityConfig;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemEntityManager {
    private static final Logger log = LogManager.getLogger((String)"Eco Stack Manager");
    private static final Map<String, Set<ItemEntity>> itemTypeEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
    private static final Map<String, Set<ItemEntity>> itemWorldEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
    private static int itemEntityVerificationCounter = 0;

    private ItemEntityManager() {
    }

    public static boolean handleItemJoinWorldEvent(ItemEntity itemEntity, ServerLevel serverLevel) {
        String itemName = ItemEntityManager.getNameFromRelevantItemEntity(itemEntity);
        if (itemName == null || itemName.isEmpty()) {
            return false;
        }
        if (!ItemEntityManager.isItemAllowedForOptimization(itemName)) {
            return false;
        }
        String levelName = serverLevel.m_46472_().m_135782_().toString();
        log.debug("[Item Entity joined {}] {} {}", (Object)levelName, (Object)itemName, (Object)itemEntity);
        if (ItemEntityManager.tryMergeWithExistingItems(itemEntity, serverLevel, levelName, itemName)) {
            return true;
        }
        ItemEntityManager.addItemToTrackingAndEnforceLimits(itemEntity, levelName, itemName);
        if (itemEntityVerificationCounter++ >= ItemEntityConfig.verificationCycle) {
            ItemEntityManager.verifyItemEntities();
            itemEntityVerificationCounter = 0;
        }
        return false;
    }

    private static boolean isItemAllowedForOptimization(String itemName) {
        if (!ItemEntityConfig.allowList.isEmpty() && !ItemEntityConfig.allowList.contains(itemName)) {
            log.debug("[Item Allow List] {} is not on the allow list: {}", (Object)itemName, ItemEntityConfig.allowList);
            return false;
        }
        if (!ItemEntityConfig.denyList.isEmpty() && ItemEntityConfig.denyList.contains(itemName)) {
            log.debug("[Item Deny List] {} will not be optimized: {}", (Object)itemName, ItemEntityConfig.denyList);
            return false;
        }
        return true;
    }

    private static boolean tryMergeWithExistingItems(ItemEntity itemEntity, ServerLevel serverLevel, String levelName, String itemName) {
        String itemTypeEntityMapKey = "[" + levelName + "]" + itemName;
        itemTypeEntityMap.computeIfAbsent(itemTypeEntityMapKey, k -> new LinkedHashSet());
        Set<ItemEntity> itemTypeEntities = itemTypeEntityMap.get(itemTypeEntityMapKey);
        ItemStack itemStack = itemEntity.m_32055_();
        if (!ItemEntityManager.isItemStackMergeable(itemStack)) {
            return false;
        }
        return ItemEntityManager.findAndMergeWithSuitableItem(itemEntity, itemStack, itemTypeEntities, serverLevel);
    }

    private static boolean isItemStackMergeable(ItemStack itemStack) {
        return itemStack.m_41753_() && itemStack.m_41613_() < itemStack.m_41741_() && itemStack.m_41741_() > 1;
    }

    private static boolean findAndMergeWithSuitableItem(ItemEntity itemEntity, ItemStack itemStack, Set<ItemEntity> itemTypeEntities, ServerLevel serverLevel) {
        ItemEntity[] entityArray;
        double x = itemEntity.m_20185_();
        double y = itemEntity.m_20186_();
        double z = itemEntity.m_20189_();
        MergeAreaBounds bounds = new MergeAreaBounds(x, y, z, ItemEntityConfig.collectRadius);
        boolean itemCanSeeSky = serverLevel.m_45527_(itemEntity.m_20183_());
        try {
            entityArray = itemTypeEntities.toArray(new ItemEntity[0]);
        }
        catch (Exception e) {
            log.debug("Failed to create entity array for merge operation: {}", (Object)e.getMessage());
            return false;
        }
        for (ItemEntity existingItemEntity : entityArray) {
            ItemStack existingItemStack;
            if (existingItemEntity == null || existingItemEntity.m_213877_() || !ItemEntityManager.shouldMergeItems(itemEntity, itemStack, itemCanSeeSky, existingItemEntity, existingItemStack = existingItemEntity.m_32055_(), bounds, serverLevel)) continue;
            ItemEntityManager.mergeItemStacks(itemEntity, itemStack, existingItemEntity, existingItemStack, x, y, z);
            return true;
        }
        return false;
    }

    private static void addItemToTrackingAndEnforceLimits(ItemEntity itemEntity, String levelName, String itemName) {
        itemWorldEntityMap.computeIfAbsent(levelName, k -> new LinkedHashSet());
        Set<ItemEntity> itemWorldEntities = itemWorldEntityMap.get(levelName);
        itemWorldEntities.add(itemEntity);
        ItemEntityManager.enforceWorldItemLimit(itemWorldEntities, levelName, itemName);
        String itemTypeEntityMapKey = "[" + levelName + "]" + itemName;
        Set<ItemEntity> itemTypeEntities = itemTypeEntityMap.get(itemTypeEntityMapKey);
        if (itemTypeEntities != null) {
            itemTypeEntities.add(itemEntity);
            ItemEntityManager.enforceTypeItemLimit(itemTypeEntities, itemWorldEntities);
        }
    }

    private static void enforceWorldItemLimit(Set<ItemEntity> itemWorldEntities, String levelName, String itemName) {
        int numberOfItemWorldEntities = itemWorldEntities.size();
        if (ItemEntityConfig.maxNumberOfItemsPerWorld > 0 && numberOfItemWorldEntities > ItemEntityConfig.maxNumberOfItemsPerWorld) {
            ItemEntity firstItemWorldEntity = itemWorldEntities.iterator().next();
            log.debug("[Item Entity World Limit {}] Removing first item {}", (Object)numberOfItemWorldEntities, (Object)firstItemWorldEntity);
            firstItemWorldEntity.m_146870_();
            itemWorldEntities.remove(firstItemWorldEntity);
            Set<ItemEntity> itemEntities = itemTypeEntityMap.get("[" + levelName + "]" + itemName);
            if (itemEntities != null) {
                itemEntities.remove(firstItemWorldEntity);
            }
        }
    }

    private static void enforceTypeItemLimit(Set<ItemEntity> itemTypeEntities, Set<ItemEntity> itemWorldEntities) {
        int numberOfItemTypeEntities = itemTypeEntities.size();
        if (ItemEntityConfig.maxNumberOfItemsPerType > 0 && numberOfItemTypeEntities > ItemEntityConfig.maxNumberOfItemsPerType) {
            ItemEntity firstItemEntity = itemTypeEntities.iterator().next();
            log.debug("[Item Entity Type Limit {}] Removing first item {}", (Object)numberOfItemTypeEntities, (Object)firstItemEntity);
            firstItemEntity.m_146870_();
            itemTypeEntities.remove(firstItemEntity);
            itemWorldEntities.remove(firstItemEntity);
        }
    }

    public static void handleItemLeaveWorldEvent(ItemEntity itemEntity, ServerLevel serverLevel) {
        Set<ItemEntity> itemTypeEntities;
        String itemName = ItemEntityManager.getNameFromRelevantItemEntity(itemEntity);
        if (itemName == null || itemName.isEmpty()) {
            return;
        }
        String levelName = serverLevel.m_46472_().m_135782_().toString();
        Set<ItemEntity> itemWorldEntities = itemWorldEntityMap.get(levelName);
        if (itemWorldEntities != null) {
            itemWorldEntities.remove(itemEntity);
        }
        if ((itemTypeEntities = itemTypeEntityMap.get("[" + levelName + "]" + itemName)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("[Item Entity leaved {}] {} {}.", (Object)levelName, (Object)itemName, (Object)itemEntity);
            }
            itemTypeEntities.remove(itemEntity);
        } else {
            log.warn("[Item Entity leaved {}] {} {} was not tracked!", (Object)levelName, (Object)itemName, (Object)itemEntity);
        }
    }

    private static String getNameFromRelevantItemEntity(ItemEntity itemEntity) {
        if (itemEntity == null || itemEntity.m_213877_() || itemEntity.m_8077_()) {
            return null;
        }
        String itemName = BuiltInRegistries.f_257033_.m_7981_((Object)itemEntity.m_32055_().m_41720_()).toString();
        if (itemName.isEmpty()) {
            return null;
        }
        if (itemName.equals("block.minecraft.air") || itemName.equals("minecraft:air")) {
            return null;
        }
        if (Constants.MOD_CREATE_LOADED && itemName.startsWith("create")) {
            return null;
        }
        return itemName;
    }

    private static void verifyItemEntities() {
        log.debug("[Verification] Start verification of tracked item entities ...");
        int removedItemsType = ItemEntityManager.getRemovedItemEntities(itemTypeEntityMap);
        int removedItemsWorld = ItemEntityManager.getRemovedItemEntities(itemWorldEntityMap);
        ItemEntityManager.cleanupEmptySets();
        if (removedItemsType > 0 || removedItemsWorld > 0) {
            log.debug("[Verification] Removed {} items ({} items per type / {} items per world)", (Object)(removedItemsType + removedItemsWorld), (Object)removedItemsType, (Object)removedItemsWorld);
        }
    }

    private static void cleanupEmptySets() {
        itemTypeEntityMap.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
        itemWorldEntityMap.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
    }

    private static int getRemovedItemEntities(Map<String, Set<ItemEntity>> itemTypeEntityMap) {
        int removedItemsType = 0;
        for (Set<ItemEntity> entities : itemTypeEntityMap.values()) {
            Iterator<ItemEntity> entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                Entity entity = (Entity)entityIterator.next();
                if (entity == null || !entity.m_213877_()) continue;
                entityIterator.remove();
                ++removedItemsType;
            }
        }
        return removedItemsType;
    }

    private static boolean shouldMergeItems(ItemEntity itemEntity, ItemStack itemStack, boolean itemCanSeeSky, ItemEntity existingItemEntity, ItemStack existingItemStack, MergeAreaBounds bounds, ServerLevel serverLevel) {
        if (existingItemEntity == null || existingItemStack == null || existingItemEntity.m_213877_()) {
            return false;
        }
        boolean existingItemCanSeeSky = serverLevel.m_45527_(existingItemEntity.m_20183_());
        int x = (int)existingItemEntity.m_20185_();
        int y = (int)existingItemEntity.m_20186_();
        int z = (int)existingItemEntity.m_20189_();
        return itemEntity.m_19879_() != existingItemEntity.m_19879_() && existingItemEntity.m_6084_() && !existingItemEntity.m_213877_() && ItemEntity.m_32026_((ItemStack)itemStack, (ItemStack)existingItemStack) && bounds.xStart < x && x < bounds.xEnd && (itemCanSeeSky && existingItemCanSeeSky || bounds.yStart < y && y < bounds.yEnd) && bounds.zStart < z && z < bounds.zEnd;
    }

    private static void mergeItemStacks(ItemEntity itemEntity, ItemStack itemStack, ItemEntity existingItemEntity, ItemStack existingItemStack, double x, double y, double z) {
        if (existingItemEntity == null || existingItemEntity.m_213877_() || itemEntity.m_213877_()) {
            log.warn("Attempted to merge removed or null item entities");
            return;
        }
        ItemStack combinedItemStack = ItemEntity.m_32029_((ItemStack)existingItemStack, (ItemStack)itemStack, (int)ItemEntityConfig.maxStackSize);
        log.debug("[Merging Item Entity] {} with {} and {} items", (Object)itemEntity, (Object)existingItemEntity, (Object)combinedItemStack);
        existingItemEntity.m_32045_(combinedItemStack);
        if (!itemEntity.m_213877_()) {
            itemEntity.m_146870_();
        }
        if (ItemEntityConfig.movePositionToLastDrop) {
            existingItemEntity.m_6034_(x, existingItemEntity.m_20186_() + (y - existingItemEntity.m_20186_()) / 4.0, z);
        }
    }

    private static class MergeAreaBounds {
        final int xStart;
        final int yStart;
        final int zStart;
        final int xEnd;
        final int yEnd;
        final int zEnd;

        MergeAreaBounds(double x, double y, double z, int radius) {
            this.xStart = (int)x - radius;
            this.yStart = (int)y - radius;
            this.zStart = (int)z - radius;
            this.xEnd = (int)x + radius;
            this.yEnd = (int)y + radius;
            this.zEnd = (int)z + radius;
        }
    }
}

