/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.ecostackmanager.entity;

import de.markusbordihn.ecostackmanager.config.ExperienceOrbConfig;
import de.markusbordihn.ecostackmanager.utils.ReflectionUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ExperienceOrb;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExperienceOrbManager {
    private static final Logger log = LogManager.getLogger((String)"Eco Stack Manager");
    private static final Map<String, Set<ExperienceOrb>> levelExperienceOrbMap = new ConcurrentHashMap<String, Set<ExperienceOrb>>();
    private static boolean raiseExpectationErrorOnce = true;

    private ExperienceOrbManager() {
    }

    public static boolean handleExperienceOrbJoinWorldEvent(ExperienceOrb experienceOrb, ServerLevel serverLevel) {
        if (experienceOrb.m_213877_()) {
            return false;
        }
        String levelName = serverLevel.m_46472_().m_135782_().toString();
        if (experienceOrb.m_20801_() <= 0) {
            log.debug("[Removed Ghost Experience Orb] {} with {} xp from {}.", (Object)experienceOrb, (Object)experienceOrb.m_20801_(), (Object)levelName);
            experienceOrb.m_146870_();
            return true;
        }
        log.debug("Experience Orb {} with {} xp joined {}.", (Object)experienceOrb, (Object)experienceOrb.m_20801_(), (Object)levelName);
        if (ExperienceOrbConfig.collectRadius > 0) {
            return ExperienceOrbManager.handleExperienceOrbMerge(experienceOrb, levelName);
        }
        return false;
    }

    public static void handleExperienceOrbLeaveWorldEvent(ExperienceOrb experienceOrb, ServerLevel serverLevel) {
        String levelName = serverLevel.m_46472_().m_135782_().toString();
        log.debug("Experience Orb {} with {} xp left {}.", (Object)experienceOrb, (Object)experienceOrb.m_20801_(), (Object)levelName);
        Set<ExperienceOrb> experienceOrbWorldEntities = levelExperienceOrbMap.get(levelName);
        if (experienceOrbWorldEntities != null) {
            experienceOrbWorldEntities.remove(experienceOrb);
        }
    }

    public static boolean handleExperienceOrbMerge(ExperienceOrb experienceOrb, String levelName) {
        levelExperienceOrbMap.computeIfAbsent(levelName, k -> new LinkedHashSet());
        Set<ExperienceOrb> experienceOrbWorldEntities = levelExperienceOrbMap.get(levelName);
        if (experienceOrbWorldEntities.isEmpty()) {
            experienceOrbWorldEntities.add(experienceOrb);
            return false;
        }
        double x = experienceOrb.m_20185_();
        double y = experienceOrb.m_20186_();
        double z = experienceOrb.m_20189_();
        int xStart = (int)x - ExperienceOrbConfig.collectRadius;
        int yStart = (int)y - ExperienceOrbConfig.collectRadius;
        int zStart = (int)z - ExperienceOrbConfig.collectRadius;
        int xEnd = (int)x + ExperienceOrbConfig.collectRadius;
        int yEnd = (int)y + ExperienceOrbConfig.collectRadius;
        int zEnd = (int)z + ExperienceOrbConfig.collectRadius;
        for (ExperienceOrb existingExperienceOrb : new HashSet<ExperienceOrb>(experienceOrbWorldEntities)) {
            if (existingExperienceOrb == null || existingExperienceOrb.m_213877_() || !ExperienceOrbManager.shouldMerge(experienceOrb, existingExperienceOrb, xStart, yStart, zStart, xEnd, yEnd, zEnd)) continue;
            ExperienceOrbManager.mergeExperienceOrbs(experienceOrb, existingExperienceOrb, x, y, z);
            return true;
        }
        experienceOrbWorldEntities.add(experienceOrb);
        if (experienceOrbWorldEntities.size() % 50 == 0) {
            ExperienceOrbManager.cleanupRemovedExperienceOrbs();
        }
        return false;
    }

    private static void cleanupRemovedExperienceOrbs() {
        for (Set<ExperienceOrb> experienceOrbs : levelExperienceOrbMap.values()) {
            experienceOrbs.removeIf(orb -> orb == null || orb.m_213877_());
        }
        levelExperienceOrbMap.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
    }

    private static boolean shouldMerge(ExperienceOrb experienceOrb, ExperienceOrb existingExperienceOrb, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        if (existingExperienceOrb == null || existingExperienceOrb.m_213877_()) {
            return false;
        }
        return experienceOrb.m_19879_() != existingExperienceOrb.m_19879_() && experienceOrb.m_6084_() && existingExperienceOrb.m_6084_() && (double)xStart < existingExperienceOrb.m_20185_() && existingExperienceOrb.m_20185_() < (double)xEnd && (double)yStart < existingExperienceOrb.m_20186_() && existingExperienceOrb.m_20186_() < (double)yEnd && (double)zStart < existingExperienceOrb.m_20189_() && existingExperienceOrb.m_20189_() < (double)zEnd;
    }

    private static void mergeExperienceOrbs(ExperienceOrb experienceOrb, ExperienceOrb existingExperienceOrb, double x, double y, double z) {
        if (experienceOrb == null || existingExperienceOrb == null || experienceOrb.m_213877_() || existingExperienceOrb.m_213877_()) {
            log.warn("Attempted to merge removed or null experience orbs");
            return;
        }
        int newExperienceValue = existingExperienceOrb.m_20801_() + experienceOrb.m_20801_();
        if (newExperienceValue <= 0 || newExperienceValue < existingExperienceOrb.m_20801_()) {
            log.warn("Invalid experience value after merge: {} (overflow detected)", (Object)newExperienceValue);
            return;
        }
        log.debug("[Merging Experience Orb] {} with {} and {} xp.", (Object)experienceOrb, (Object)existingExperienceOrb, (Object)newExperienceValue);
        if (ReflectionUtils.changeIntValueField((Object)existingExperienceOrb, new String[]{"value", "amount", "field_6159", "f_20770_"}, newExperienceValue)) {
            if (!experienceOrb.m_213877_()) {
                experienceOrb.m_146870_();
            }
            if (ExperienceOrbConfig.movePositionToLastDrop) {
                existingExperienceOrb.m_6027_(x, existingExperienceOrb.m_20186_() + (y - existingExperienceOrb.m_20186_()) / 4.0, z);
            }
        } else {
            if (raiseExpectationErrorOnce) {
                log.error("Reflection failed: Unable to merge experience orbs {} with {} and {} xp.", (Object)experienceOrb, (Object)existingExperienceOrb, (Object)newExperienceValue);
                raiseExpectationErrorOnce = false;
            }
            experienceOrb.m_6027_((double)existingExperienceOrb.m_146903_(), (double)existingExperienceOrb.m_146904_(), (double)existingExperienceOrb.m_146907_());
        }
    }
}

