/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.enums;

import blusunrize.immersiveengineering.common.register.IEBlocks;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.ExternalModContent;
import twistedgate.immersiveposts.common.IPOContent;

public enum EnumPostMaterial implements IPostMaterial
{
    WOOD("wood", PostBlockProperties.WOOD, () -> ExternalModContent.IE_TREATED_FENCE.get()),
    ALUMINIUM("aluminium", PostBlockProperties.METAL, () -> ExternalModContent.IE_ALUMINIUM_FENCE.get()),
    STEEL("steel", PostBlockProperties.METAL, () -> ExternalModContent.IE_STEEL_FENCE.get()),
    NETHERBRICK("nether", PostBlockProperties.STONE, Blocks.f_50198_),
    IRON("iron", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.IRON.get()),
    GOLD("gold", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.GOLD.get()),
    COPPER("copper", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.COPPER.get()),
    LEAD("lead", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.LEAD.get()),
    SILVER("silver", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.SILVER.get()),
    NICKEL("nickel", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.NICKEL.get()),
    CONSTANTAN("constantan", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.CONSTANTAN.get()),
    ELECTRUM("electrum", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.ELECTRUM.get()),
    URANIUM("uranium", PostBlockProperties.metal().m_60953_(s -> 8), () -> IPOContent.Blocks.Fences.URANIUM.get()),
    CONCRETE("concrete", PostBlockProperties.STONE, () -> ((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(IEBlocks.StoneDecoration.CONCRETE.getId())).get()),
    CONCRETE_LEADED("leadedconcrete", PostBlockProperties.STONE, () -> ((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(IEBlocks.StoneDecoration.CONCRETE_LEADED.getId())).get());

    private boolean isFence;
    private final String name;
    private Block sourceBlock;
    private Supplier<Block> sourceBlockSupplier;
    private final BlockBehaviour.Properties properties;
    private ResourceLocation texture;

    private EnumPostMaterial(String name, BlockBehaviour.Properties properties, Supplier<Block> sourceBlockSupplier) {
        this(name, properties, null, sourceBlockSupplier);
    }

    private EnumPostMaterial(String name, BlockBehaviour.Properties properties, Block sourceBlock) {
        this.name = name;
        this.properties = properties;
        this.sourceBlock = sourceBlock;
        this.isFence = sourceBlock instanceof FenceBlock;
    }

    private EnumPostMaterial(String name, BlockBehaviour.Properties properties, ResourceLocation texture, Supplier<Block> sourceBlockSupplier) {
        this.name = name;
        this.properties = properties;
        this.texture = texture;
        this.sourceBlockSupplier = sourceBlockSupplier;
    }

    @Override
    public ItemStack getItemStack() {
        Block block = this.getSourceBlock();
        return block == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)block);
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.texture == null) {
            return new ResourceLocation("immersiveposts", "block/posts/post_" + this.getName());
        }
        return this.texture;
    }

    @Override
    public Block getSourceBlock() {
        if (this.sourceBlock == null) {
            this.sourceBlock = this.sourceBlockSupplier.get();
            this.isFence = this.sourceBlock != null && this.sourceBlock instanceof FenceBlock;
        }
        return this.sourceBlock;
    }

    @Override
    public boolean isFence() {
        return this.isFence;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBlockName() {
        return this.name + "post";
    }

    @Override
    public BlockBehaviour.Properties getBlockProperties() {
        return this.properties;
    }

    public static class PostBlockProperties {
        public static final BlockBehaviour.Properties WOOD = PostBlockProperties.wood();
        public static final BlockBehaviour.Properties STONE = PostBlockProperties.stone();
        public static final BlockBehaviour.Properties METAL = PostBlockProperties.metal();

        public static BlockBehaviour.Properties wood() {
            return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 5.0f).m_60955_().m_60971_((s, r, p) -> false);
        }

        public static BlockBehaviour.Properties stone() {
            return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60999_().m_60913_(1.5f, 6.0f).m_60955_().m_60971_((s, r, p) -> false);
        }

        public static BlockBehaviour.Properties metal() {
            return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60999_().m_60913_(3.0f, 15.0f).m_60955_().m_60971_((s, r, p) -> false);
        }
    }
}

