/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.IPOTileTypes;
import twistedgate.immersiveposts.common.blocks.IPOBlockBase;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.common.tileentity.PostBaseTileEntity;
import twistedgate.immersiveposts.enums.EnumFlipState;
import twistedgate.immersiveposts.enums.EnumPostMaterial;
import twistedgate.immersiveposts.enums.EnumPostType;

public class PostBaseBlock
extends IPOBlockBase
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty HIDDEN = BooleanProperty.m_61465_((String)"hidden");
    private static final VoxelShape BASE_SIZE = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75);

    private static BlockBehaviour.Properties prop() {
        BlockBehaviour.Properties prop = EnumPostMaterial.PostBlockProperties.stone().m_60999_().m_60913_(5.0f, 3.0f).m_60955_();
        return prop;
    }

    public PostBaseBlock() {
        super(PostBaseBlock.prop());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HIDDEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HIDDEN, WATERLOGGED});
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return !((Boolean)state.m_61143_((Property)HIDDEN)).booleanValue() ? !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() : super.m_7420_(state, reader, pos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack;
        if (player.m_6144_() && ((Boolean)state.m_61143_((Property)HIDDEN)).booleanValue() && (stack = ((PostBaseTileEntity)world.m_7702_(pos)).getStack()) != ItemStack.f_41583_) {
            return stack;
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)HIDDEN) == false && (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        FluidState fs = context.m_43725_().m_6425_(context.m_8083_());
        state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.m_76152_() == Fluids.f_76193_));
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (!((Boolean)state.m_61143_((Property)HIDDEN)).booleanValue() && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)HIDDEN) == false && super.m_6044_(world, pos, state, fluid);
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)IPOTileTypes.POST_BASE.get()).m_155264_(pPos, pState);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, worldIn, pos, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HIDDEN) != false ? Shapes.m_83144_() : BASE_SIZE;
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        ItemStack held;
        PostBaseTileEntity baseTe;
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof PostBaseTileEntity && (baseTe = (PostBaseTileEntity)te).interact(state, worldIn, pos, playerIn, handIn)) {
            return InteractionResult.SUCCESS;
        }
        if (worldIn.f_46443_) {
            held = playerIn.m_21205_();
            if (IPostMaterial.isValidItem(held)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        held = playerIn.m_21205_();
        if (IPostMaterial.isValidItem(held)) {
            ItemStack tmp;
            BlockState aboveState;
            Block b;
            if (!worldIn.m_46859_(pos.m_121945_(Direction.UP)) && (b = (aboveState = worldIn.m_8055_(pos.m_121945_(Direction.UP))).m_60734_()) instanceof PostBlock && !held.m_150930_((tmp = ((PostBlock)b).getPostMaterial().getItemStack()).m_41720_())) {
                playerIn.m_5661_((Component)Component.m_237110_((String)"immersiveposts.expectedlocal", (Object[])new Object[]{tmp.m_41786_()}), true);
                return InteractionResult.SUCCESS;
            }
            for (int y = 1; y <= worldIn.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) - pos.m_123342_(); ++y) {
                BlockPos nPos = pos.m_7918_(0, y, 0);
                BlockState nState = worldIn.m_8055_(nPos);
                if (nState.m_60734_() instanceof PostBlock) {
                    EnumPostType type = (EnumPostType)((Object)nState.m_61143_(PostBlock.TYPE));
                    if (type != EnumPostType.POST && type != EnumPostType.POST_TOP && nState.m_61143_(PostBlock.FLIPSTATE) == EnumFlipState.DOWN) {
                        return InteractionResult.SUCCESS;
                    }
                    nState = worldIn.m_8055_(nPos.m_121945_(Direction.UP));
                    if (nState.m_60734_() instanceof PostBlock && (type = (EnumPostType)((Object)nState.m_61143_(PostBlock.TYPE))) != EnumPostType.POST && type != EnumPostType.POST_TOP) {
                        return InteractionResult.SUCCESS;
                    }
                }
                if (worldIn.m_46859_(nPos) || worldIn.m_8055_(nPos).m_60734_() == Blocks.f_49990_) {
                    BlockState fb = (BlockState)IPostMaterial.getPostState(held).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.m_8055_(nPos).m_60734_() == Blocks.f_49990_));
                    if (fb != null && !playerIn.m_20183_().equals((Object)nPos) && worldIn.m_46597_(nPos, fb.m_60728_(null, null, (LevelAccessor)worldIn, nPos, null)) && !playerIn.m_7500_()) {
                        held.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (worldIn.m_8055_(nPos).m_60734_() instanceof PostBlock) continue;
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public static class ItemPostBase
    extends BlockItem {
        public ItemPostBase(Block block) {
            super(block, new Item.Properties());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
            tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)"tooltip.postbase", (Object[])new Object[0])));
        }
    }
}

