/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.blocks;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.blocks.GenericPostBlock;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.enums.EnumHTrussType;
import twistedgate.immersiveposts.enums.EnumPostMaterial;

public class HorizontalTrussBlock
extends GenericPostBlock
implements IPostBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty CONNECTOR_POINT_TOP = BooleanProperty.m_61465_((String)"connector_point_top");
    public static final BooleanProperty CONNECTOR_POINT_BOTTOM = BooleanProperty.m_61465_((String)"connector_point_bottom");
    public static final BooleanProperty PANEL_NORTH = BooleanProperty.m_61465_((String)"panel_north");
    public static final BooleanProperty PANEL_EAST = BooleanProperty.m_61465_((String)"panel_east");
    public static final BooleanProperty PANEL_SOUTH = BooleanProperty.m_61465_((String)"panel_south");
    public static final BooleanProperty PANEL_WEST = BooleanProperty.m_61465_((String)"panel_west");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<EnumHTrussType> TYPE = EnumProperty.m_61587_((String)"type", EnumHTrussType.class);
    static final VoxelShape NORTH_SOUTH = Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.0, (double)0.6875, (double)1.0, (double)1.0);
    static final VoxelShape EAST_WEST = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.3125, (double)1.0, (double)1.0, (double)0.6875);
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[32];

    public HorizontalTrussBlock(IPostMaterial material) {
        super(material);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)EnumHTrussType.SINGLE))).m_61124_((Property)CONNECTOR_POINT_TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTOR_POINT_BOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PANEL_NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PANEL_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PANEL_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PANEL_WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, TYPE, PANEL_NORTH, PANEL_EAST, PANEL_SOUTH, PANEL_WEST, CONNECTOR_POINT_TOP, CONNECTOR_POINT_BOTTOM});
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        FluidState fs = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        boolean b0 = PostBlock.canConnect((BlockGetter)world, pos, Direction.UP);
        boolean b1 = PostBlock.canConnect((BlockGetter)world, pos, Direction.DOWN) || world.m_8055_(pos.m_121945_(Direction.DOWN)).m_60734_() instanceof PostBlock;
        return (BlockState)((BlockState)state.m_61124_((Property)CONNECTOR_POINT_TOP, (Comparable)Boolean.valueOf(b0))).m_61124_((Property)CONNECTOR_POINT_BOTTOM, (Comparable)Boolean.valueOf(b1));
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (this.getPostMaterial() == EnumPostMaterial.URANIUM && rand.m_188501_() < 0.125f) {
            double x = (double)pos.m_123341_() + 0.375 + 0.25 * rand.m_188500_();
            double y = (double)pos.m_123342_() + rand.m_188500_();
            double z = (double)pos.m_123343_() + 0.375 + 0.25 * rand.m_188500_();
            worldIn.m_7106_((ParticleOptions)PostBlock.URAN_PARTICLE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.getPostMaterial().getItemStack();
    }

    public boolean canConnectTransformer(BlockGetter world, BlockPos pos) {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        ItemStack held;
        if (!worldIn.f_46443_ && Utils.isHammer((ItemStack)(held = playerIn.m_21205_()))) {
            Direction face = hit.m_82434_();
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            BlockState newState = state;
            switch (facing) {
                case NORTH: 
                case SOUTH: {
                    if (face == Direction.EAST) {
                        newState = (BlockState)newState.m_61124_((Property)PANEL_EAST, (Comparable)Boolean.valueOf((Boolean)newState.m_61143_((Property)PANEL_EAST) == false));
                        break;
                    }
                    if (face != Direction.WEST) break;
                    newState = (BlockState)newState.m_61124_((Property)PANEL_WEST, (Comparable)Boolean.valueOf((Boolean)newState.m_61143_((Property)PANEL_WEST) == false));
                    break;
                }
                case EAST: 
                case WEST: {
                    if (face == Direction.NORTH) {
                        newState = (BlockState)newState.m_61124_((Property)PANEL_NORTH, (Comparable)Boolean.valueOf((Boolean)newState.m_61143_((Property)PANEL_NORTH) == false));
                        break;
                    }
                    if (face != Direction.SOUTH) break;
                    newState = (BlockState)newState.m_61124_((Property)PANEL_SOUTH, (Comparable)Boolean.valueOf((Boolean)newState.m_61143_((Property)PANEL_SOUTH) == false));
                    break;
                }
            }
            if (!newState.equals(state)) {
                worldIn.m_46597_(pos, newState);
                return InteractionResult.SUCCESS;
            }
        }
        if (Utils.isHammer((ItemStack)playerIn.m_21205_())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.f_46443_) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos posA = pos.m_121945_(facing);
        BlockPos posB = pos.m_121945_(facing.m_122424_());
        BlockState stateA = world.m_8055_(posA);
        BlockState stateB = world.m_8055_(posB);
        if (stateA.m_60795_() || stateB.m_60795_() || stateA.m_60734_() == Blocks.f_49990_ || stateB.m_60734_() == Blocks.f_49990_) {
            this.replaceSelf(state, world, pos);
            return;
        }
    }

    private static int getCacheIndex(Direction.Axis axis, boolean panelNorth, boolean panelEast, boolean panelSouth, boolean panelWest) {
        int result;
        int n = result = axis == Direction.Axis.X ? 1 : 0;
        if (panelNorth) {
            result |= 2;
        }
        if (panelEast) {
            result |= 4;
        }
        if (panelSouth) {
            result |= 8;
        }
        if (panelWest) {
            result |= 0x10;
        }
        return result;
    }

    private static VoxelShape computeShape(Direction.Axis axis, boolean panelNorth, boolean panelEast, boolean panelSouth, boolean panelWest) {
        VoxelShape shape = null;
        switch (axis) {
            case Z: {
                shape = NORTH_SOUTH;
                break;
            }
            case X: {
                shape = EAST_WEST;
                break;
            }
        }
        if (shape == null) {
            return Shapes.m_83040_();
        }
        if (panelNorth) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5), (BooleanOp)BooleanOp.f_82695_);
        }
        if (panelEast) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        }
        if (panelSouth) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        }
        if (panelWest) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        }
        return shape.m_83296_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction.Axis axis = ((Direction)state.m_61143_((Property)FACING)).m_122434_();
        if (axis != Direction.Axis.X && axis != Direction.Axis.Z) {
            return Shapes.m_83040_();
        }
        return SHAPE_CACHE[HorizontalTrussBlock.getCacheIndex(axis, (Boolean)state.m_61143_((Property)PANEL_NORTH), (Boolean)state.m_61143_((Property)PANEL_EAST), (Boolean)state.m_61143_((Property)PANEL_SOUTH), (Boolean)state.m_61143_((Property)PANEL_WEST))];
    }

    static {
        boolean[] bools = new boolean[]{false, true};
        for (Direction.Axis axis : new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z}) {
            for (boolean north : bools) {
                for (boolean east : bools) {
                    for (boolean south : bools) {
                        for (boolean west : bools) {
                            HorizontalTrussBlock.SHAPE_CACHE[HorizontalTrussBlock.getCacheIndex((Direction.Axis)axis, (boolean)north, (boolean)east, (boolean)south, (boolean)west)] = HorizontalTrussBlock.computeShape(axis, north, east, south, west);
                        }
                    }
                }
            }
        }
    }
}

