/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraftforge.registries.RegistryObject;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.IPORegistries;
import twistedgate.immersiveposts.common.IPOTileTypes;
import twistedgate.immersiveposts.common.blocks.HorizontalTrussBlock;
import twistedgate.immersiveposts.common.blocks.MetalFenceBlock;
import twistedgate.immersiveposts.common.blocks.PostBaseBlock;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.common.items.IPOItemBase;
import twistedgate.immersiveposts.enums.EnumPostMaterial;

public class IPOContent {
    public static boolean containsBlockOrItem(@Nullable Block block, @Nullable Item item) {
        if (block != null) {
            return IPORegistries.BLOCK_REGISTER.getEntries().stream().anyMatch(r -> r.get() == block);
        }
        if (item != null) {
            return IPORegistries.ITEM_REGISTER.getEntries().stream().anyMatch(r -> r.get() == item);
        }
        return false;
    }

    protected static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> constructor) {
        return IPORegistries.BLOCK_REGISTER.register(name, constructor);
    }

    protected static RegistryObject<PostBlock> registerPostBlock(EnumPostMaterial material) {
        return IPOContent.registerBlock(material.getBlockName(), () -> new PostBlock(material));
    }

    protected static RegistryObject<HorizontalTrussBlock> registerTrussBlock(EnumPostMaterial material) {
        return IPOContent.registerBlock(material.getBlockName() + "_truss", () -> new HorizontalTrussBlock(material));
    }

    protected static RegistryObject<FenceBlock> registerMetalFence(String materialName) {
        materialName = "fence_" + (String)materialName;
        RegistryObject block = IPORegistries.BLOCK_REGISTER.register((String)materialName, MetalFenceBlock::new);
        IPORegistries.ITEM_REGISTER.register((String)materialName, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    protected static <T extends Item> RegistryObject<T> registerItem(String name, Supplier<T> constructor) {
        return IPORegistries.ITEM_REGISTER.register(name, constructor);
    }

    public static void modConstruction() {
        Blocks.forceClassLoad();
        IPOTileTypes.forceClassLoad();
    }

    public static class Blocks {
        public static final RegistryObject<PostBaseBlock> POST_BASE = IPOContent.registerBlock("postbase", PostBaseBlock::new);

        private static void forceClassLoad() {
            Posts.forceClassLoad();
            HorizontalTruss.forceClassLoad();
            Fences.forceClassLoad();
            Items.forceClassLoad();
        }

        static {
            IPOContent.registerItem("postbase", () -> new PostBaseBlock.ItemPostBase((Block)POST_BASE.get()));
        }

        public static class Posts {
            static final EnumMap<EnumPostMaterial, RegistryObject<PostBlock>> ALL = (EnumMap)Util.m_137469_(new EnumMap(EnumPostMaterial.class), map -> {
                for (EnumPostMaterial material : EnumPostMaterial.values()) {
                    map.put(material, IPOContent.registerPostBlock(material));
                }
            });

            @CheckForNull
            public static PostBlock get(@Nonnull IPostMaterial material) {
                if (!ALL.containsKey(material)) {
                    return null;
                }
                return (PostBlock)((Object)ALL.get(material).get());
            }

            @CheckForNull
            public static RegistryObject<PostBlock> getRegObject(@Nonnull IPostMaterial material) {
                if (!ALL.containsKey(material)) {
                    return null;
                }
                return ALL.get(material);
            }

            private static void forceClassLoad() {
            }
        }

        public static class HorizontalTruss {
            static EnumMap<EnumPostMaterial, RegistryObject<HorizontalTrussBlock>> ALL = (EnumMap)Util.m_137469_(new EnumMap(EnumPostMaterial.class), map -> {
                for (EnumPostMaterial material : EnumPostMaterial.values()) {
                    map.put(material, IPOContent.registerTrussBlock(material));
                }
            });

            public static HorizontalTrussBlock get(@Nonnull IPostMaterial material) {
                if (!ALL.containsKey(material)) {
                    return null;
                }
                return (HorizontalTrussBlock)((Object)ALL.get(material).get());
            }

            public static RegistryObject<HorizontalTrussBlock> getRegObject(@Nonnull IPostMaterial material) {
                if (!ALL.containsKey(material)) {
                    return null;
                }
                return ALL.get(material);
            }

            private static void forceClassLoad() {
            }
        }

        public static class Fences {
            public static final List<RegistryObject<FenceBlock>> ALL_FENCES;
            public static final RegistryObject<FenceBlock> IRON;
            public static final RegistryObject<FenceBlock> GOLD;
            public static final RegistryObject<FenceBlock> COPPER;
            public static final RegistryObject<FenceBlock> LEAD;
            public static final RegistryObject<FenceBlock> SILVER;
            public static final RegistryObject<FenceBlock> NICKEL;
            public static final RegistryObject<FenceBlock> CONSTANTAN;
            public static final RegistryObject<FenceBlock> ELECTRUM;
            public static final RegistryObject<FenceBlock> URANIUM;

            private static void forceClassLoad() {
            }

            static {
                ArrayList<RegistryObject<FenceBlock>> list = new ArrayList<RegistryObject<FenceBlock>>();
                IRON = IPOContent.registerMetalFence("iron");
                list.add(IRON);
                GOLD = IPOContent.registerMetalFence("gold");
                list.add(GOLD);
                COPPER = IPOContent.registerMetalFence("copper");
                list.add(COPPER);
                LEAD = IPOContent.registerMetalFence("lead");
                list.add(LEAD);
                SILVER = IPOContent.registerMetalFence("silver");
                list.add(SILVER);
                NICKEL = IPOContent.registerMetalFence("nickel");
                list.add(NICKEL);
                CONSTANTAN = IPOContent.registerMetalFence("constantan");
                list.add(CONSTANTAN);
                ELECTRUM = IPOContent.registerMetalFence("electrum");
                list.add(ELECTRUM);
                URANIUM = IPOContent.registerMetalFence("uranium");
                list.add(URANIUM);
                ALL_FENCES = Collections.unmodifiableList(list);
            }
        }
    }

    public static class Items {
        public static final RegistryObject<Item> ROD_GOLD = IPOContent.registerItem("stick_gold", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_COPPER = IPOContent.registerItem("stick_copper", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_LEAD = IPOContent.registerItem("stick_lead", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_SILVER = IPOContent.registerItem("stick_silver", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_NICKEL = IPOContent.registerItem("stick_nickel", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_CONSTANTAN = IPOContent.registerItem("stick_constantan", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_ELECTRUM = IPOContent.registerItem("stick_electrum", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_URANIUM = IPOContent.registerItem("stick_uranium", IPOItemBase::new);

        private static void forceClassLoad() {
        }
    }
}

