/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.util;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class GlyphEffectUtil {
    public static void placeBlocks(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver, BlockState toPlace) {
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)world));
        if (shooter == null) {
            return;
        }
        for (BlockPos pos : SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)rayTraceResult.m_82425_(), (BlockHitResult)rayTraceResult, (SpellStats)spellStats)) {
            BlockState state;
            ANFakePlayer aNFakePlayer;
            BlockPos blockPos = pos = rayTraceResult.m_82436_() ? pos : pos.m_121945_(rayTraceResult.m_82434_());
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                aNFakePlayer = player;
            } else {
                aNFakePlayer = fakePlayer;
            }
            if (!BlockUtil.destroyRespectsClaim((Entity)aNFakePlayer, (Level)world, (BlockPos)pos) || !(state = world.m_8055_(pos)).m_247087_() || !world.m_45752_(toPlace, pos, CollisionContext.m_82750_((Entity)fakePlayer))) continue;
            world.m_46597_(pos, toPlace);
            ShapersFocus.tryPropagateBlockSpell((BlockHitResult)new BlockHitResult(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), rayTraceResult.m_82434_(), pos, false), (Level)world, (Entity)shooter, (SpellContext)spellContext, (SpellResolver)resolver);
        }
    }

    public static boolean hasFollowingEffect(SpellContext spellContext, AbstractEffect toFind) {
        for (AbstractSpellPart part : spellContext.getSpell().recipe.subList(spellContext.getCurrentIndex(), spellContext.getSpell().getSpellSize())) {
            if (!(part instanceof AbstractEffect)) continue;
            if (part != toFind) break;
            return true;
        }
        return false;
    }

    public static boolean checkIgnoreFilters(Entity e, Set<IFilter> filters) {
        boolean flag = true;
        if (filters == null) {
            return true;
        }
        for (IFilter spellPart : filters) {
            flag &= spellPart.shouldAffect((HitResult)new EntityHitResult(e), e.m_9236_());
        }
        return !flag;
    }

    public static Set<IFilter> getFilters(List<AbstractSpellPart> recipe, int index) {
        HashSet<IFilter> list = new HashSet<IFilter>();
        for (AbstractSpellPart glyph : recipe.subList(index, recipe.size())) {
            if (glyph instanceof AbstractCastMethod) continue;
            if (glyph instanceof IFilter) {
                IFilter filter = (IFilter)glyph;
                list.add(filter);
                continue;
            }
            if (!(glyph instanceof AbstractEffect)) continue;
            break;
        }
        return list;
    }

    public static Predicate<Entity> getFilterPredicate(Spell spell, Predicate<Entity> defaultFilter) {
        Set<IFilter> set = GlyphEffectUtil.getFilters(spell.recipe, 0);
        if (set.isEmpty()) {
            return defaultFilter;
        }
        return entity -> !GlyphEffectUtil.checkIgnoreFilters(entity, set);
    }
}

