/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.plugins.ClientPluginManager;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerException;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.ALUtil;
import org.lwjgl.openal.EXTThreadLocalContext;

public class SoundManager {
    @Nullable
    private final String deviceName;
    private long device;
    private long context;
    private final ALCCapabilities alcCaps;
    private final ALCapabilities alCaps;
    private final float maxGain;
    private static final Pattern DEVICE_NAME = Pattern.compile("^(?:OpenAL.+?on )?(.*)$");

    public SoundManager(@Nullable String deviceName, long device, long context, ALCCapabilities alcCaps, ALCapabilities alCaps, float maxGain) {
        this.deviceName = deviceName;
        this.device = device;
        this.context = context;
        this.alcCaps = alcCaps;
        this.alCaps = alCaps;
        this.maxGain = maxGain;
    }

    public static SoundManager create() throws SpeakerException {
        return SoundManager.create(VoicechatClient.CLIENT_CONFIG.speaker.get());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SoundManager create(@Nullable String deviceName) throws SpeakerException {
        SoundManager soundManager;
        long prevContext = ALC11.alcGetCurrentContext();
        long prevDevice = prevContext != 0L ? ALC11.alcGetContextsDevice((long)prevContext) : 0L;
        try {
            float maxGain;
            long device = SoundManager.openSpeaker(deviceName);
            long context = ALC11.alcCreateContext((long)device, (IntBuffer)null);
            if (context == 0L) {
                int error = ALC11.alcGetError((long)device);
                ALC11.alcCloseDevice((long)device);
                SoundManager.checkAlcError(device);
                throw new SpeakerException(String.format("Failed to create OpenAL context: %s", SoundManager.getAlcError(error)));
            }
            if (!ALC11.alcMakeContextCurrent((long)context)) {
                int error = ALC11.alcGetError((long)device);
                ALC11.alcDestroyContext((long)context);
                SoundManager.checkAlcError(device);
                ALC11.alcCloseDevice((long)device);
                SoundManager.checkAlcError(device);
                throw new SpeakerException(String.format("Failed to make OpenAL context current: %s", SoundManager.getAlcError(error)));
            }
            ALCCapabilities alcCaps = ALC.createCapabilities((long)device);
            ALCapabilities alCaps = AL.createCapabilities((ALCCapabilities)alcCaps);
            if (alCaps.AL_SOFT_gain_clamp_ex) {
                maxGain = AL11.alGetFloat((int)8206);
                SoundManager.checkAlcError(device);
            } else {
                maxGain = 1.0f;
                Voicechat.LOGGER.warn("OpenAL extension 'AL_SOFT_gain_clamp_ex' not supported - Voice chat volume can't exceed 100%", new Object[0]);
            }
            ClientPluginManager.instance().onCreateALContext(context, device);
            soundManager = new SoundManager(deviceName, device, context, alcCaps, alCaps, maxGain);
        }
        catch (SpeakerException speakerException) {
            try {
                throw speakerException;
                catch (Throwable t) {
                    throw new SpeakerException("Failed to initialize OpenAL context", t);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (prevContext == 0L) throw throwable;
                    if (ALC11.alcMakeContextCurrent((long)prevContext)) {
                        if (prevDevice == 0L) throw throwable;
                        ALCCapabilities prevAlcCaps = ALC.createCapabilities((long)prevDevice);
                        AL.createCapabilities((ALCCapabilities)prevAlcCaps);
                        throw throwable;
                    }
                    if (prevDevice != 0L) {
                        int error = ALC11.alcGetError((long)prevDevice);
                        Voicechat.LOGGER.error("Failed to restore previous OpenAL context ({}): {}", prevContext, SoundManager.getAlcError(error));
                        throw throwable;
                    }
                    Voicechat.LOGGER.error("Failed to restore previous OpenAL context ({}): Device not found", prevContext);
                    throw throwable;
                }
                catch (Throwable t) {
                    Voicechat.LOGGER.warn("Failed to restore previous OpenAL context", t);
                }
                throw throwable;
            }
        }
        try {
            if (prevContext == 0L) return soundManager;
            if (ALC11.alcMakeContextCurrent((long)prevContext)) {
                if (prevDevice == 0L) return soundManager;
                ALCCapabilities prevAlcCaps = ALC.createCapabilities((long)prevDevice);
                AL.createCapabilities((ALCCapabilities)prevAlcCaps);
                return soundManager;
            }
            if (prevDevice != 0L) {
                int error = ALC11.alcGetError((long)prevDevice);
                Voicechat.LOGGER.error("Failed to restore previous OpenAL context ({}): {}", prevContext, SoundManager.getAlcError(error));
                return soundManager;
            }
            Voicechat.LOGGER.error("Failed to restore previous OpenAL context ({}): Device not found", prevContext);
            return soundManager;
        }
        catch (Throwable t) {
            Voicechat.LOGGER.warn("Failed to restore previous OpenAL context", t);
        }
        return soundManager;
    }

    public void close() {
        ClientPluginManager.instance().onDestroyALContext(this.context, this.device);
        if (this.context != 0L) {
            ALC11.alcDestroyContext((long)this.context);
            SoundManager.checkAlcError(this.device);
        }
        if (this.device != 0L && !ALC11.alcCloseDevice((long)this.device)) {
            SoundManager.checkAlcError(this.device);
        }
        this.context = 0L;
        this.device = 0L;
    }

    public float getMaxGain() {
        return this.maxGain;
    }

    public boolean isClosed() {
        return this.context == 0L || this.device == 0L;
    }

    private static long openSpeaker(@Nullable String name) throws SpeakerException {
        try {
            return SoundManager.tryOpenSpeaker(name);
        }
        catch (SpeakerException e) {
            if (name == null) {
                throw e;
            }
            Voicechat.LOGGER.warn("Failed to open audio device '{}', falling back to default", name);
            return SoundManager.tryOpenSpeaker(null);
        }
    }

    private static long tryOpenSpeaker(@Nullable String string) throws SpeakerException {
        long device = ALC11.alcOpenDevice((CharSequence)string);
        if (device == 0L) {
            throw new SpeakerException(String.format("Failed to open audio device: Audio device '%s' not found", string));
        }
        int error = ALC11.alcGetError((long)device);
        if (error != 0) {
            if (!ALC11.alcCloseDevice((long)device)) {
                Voicechat.LOGGER.warn("Failed to close audio device", new Object[0]);
            }
            throw new SpeakerException(String.format("Failed to open audio device: %s", SoundManager.getAlcError(error)));
        }
        return device;
    }

    public static List<String> getAllSpeakers() {
        List devices = null;
        if (SoundManager.canEnumerateAll()) {
            devices = ALUtil.getStringList((long)0L, (int)4115);
        } else {
            Voicechat.LOGGER.warn("Extension ALC_ENUMERATE_ALL_EXT is not present", new Object[0]);
        }
        boolean canEnumerate = SoundManager.canEnumerate();
        if (devices == null && !canEnumerate) {
            Voicechat.LOGGER.warn("Extension ALC_ENUMERATION_EXT is not present", new Object[0]);
        }
        if (devices == null && canEnumerate) {
            devices = ALUtil.getStringList((long)0L, (int)4101);
        }
        if (devices == null) {
            devices = Collections.emptyList();
        }
        return devices;
    }

    public static boolean canEnumerateAll() {
        return ALC11.alcIsExtensionPresent((long)0L, (CharSequence)"ALC_ENUMERATE_ALL_EXT");
    }

    public static boolean canEnumerate() {
        return ALC11.alcIsExtensionPresent((long)0L, (CharSequence)"ALC_ENUMERATION_EXT");
    }

    public void runInContext(Executor executor, Runnable runnable) {
        long time = System.currentTimeMillis();
        executor.execute(() -> {
            long diff = System.currentTimeMillis() - time;
            if (diff > 20L || diff >= 5L && Voicechat.debugMode()) {
                Voicechat.LOGGER.warn("Sound executor delay: {} ms!", diff);
            }
            if (this.openContext()) {
                runnable.run();
                this.closeContext();
            }
        });
    }

    public boolean openContext() {
        if (this.context == 0L) {
            return false;
        }
        boolean success = EXTThreadLocalContext.alcSetThreadContext((long)this.context);
        SoundManager.checkAlcError(this.device);
        return success;
    }

    public void closeContext() {
        EXTThreadLocalContext.alcSetThreadContext((long)0L);
        SoundManager.checkAlcError(this.device);
    }

    public static boolean checkAlError() {
        int error = AL11.alGetError();
        if (error == 0) {
            return false;
        }
        StackTraceElement stack = Thread.currentThread().getStackTrace()[2];
        Voicechat.LOGGER.error("Voicechat sound manager AL error: {}.{}[{}] {}", stack.getClassName(), stack.getMethodName(), stack.getLineNumber(), SoundManager.getAlError(error));
        return true;
    }

    public static boolean checkAlcError(long device) {
        int error = ALC11.alcGetError((long)device);
        if (error == 0) {
            return false;
        }
        StackTraceElement stack = Thread.currentThread().getStackTrace()[2];
        Voicechat.LOGGER.error("Voicechat sound manager ALC error: {}.{}[{}] {}", stack.getClassName(), stack.getMethodName(), stack.getLineNumber(), SoundManager.getAlcError(error));
        return true;
    }

    public static String getAlError(int errorCode) {
        switch (errorCode) {
            case 40961: {
                return "Invalid name";
            }
            case 40962: {
                return "Invalid enum ";
            }
            case 40963: {
                return "Invalid value";
            }
            case 40964: {
                return "Invalid operation";
            }
            case 40965: {
                return "Out of memory";
            }
        }
        return String.format("Error %#X", errorCode);
    }

    public static String getAlcError(int i) {
        switch (i) {
            case 40961: {
                return "Invalid device";
            }
            case 40962: {
                return "Invalid context";
            }
            case 40963: {
                return "Invalid enum";
            }
            case 40964: {
                return "Invalid value";
            }
            case 40965: {
                return "Out of memory";
            }
        }
        return "Unknown error";
    }

    public static String cleanDeviceName(String name) {
        Matcher matcher = DEVICE_NAME.matcher(name);
        if (!matcher.matches()) {
            return name;
        }
        return matcher.group(1);
    }
}

