/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.core.registration;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockPartBlock;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import mctmods.immersivetechnology.common.items.helper.ITBlockItem;
import mctmods.immersivetechnology.common.multiblocks.helper.ITClearTank;
import mctmods.immersivetechnology.common.multiblocks.helper.ITDisassemblyTicker;
import mctmods.immersivetechnology.common.multiblocks.helper.ITMultiblockBuilder;
import mctmods.immersivetechnology.common.multiblocks.helper.ITMultiblockPartBlockNonMirror;
import mctmods.immersivetechnology.common.multiblocks.helper.ITMultiblockPartBlockNonMirrorActive;
import mctmods.immersivetechnology.common.multiblocks.helper.ITMultiblockPartBlockWithMirror;
import mctmods.immersivetechnology.common.multiblocks.helper.ITNonMirrorableWithActiveBlock;
import mctmods.immersivetechnology.common.multiblocks.helper.ITTemplateMultiblock;
import mctmods.immersivetechnology.common.multiblocks.metal.Alternator;
import mctmods.immersivetechnology.common.multiblocks.metal.BoilerLiquid;
import mctmods.immersivetechnology.common.multiblocks.metal.BoilerSolid;
import mctmods.immersivetechnology.common.multiblocks.metal.BoilerTank;
import mctmods.immersivetechnology.common.multiblocks.metal.Distiller;
import mctmods.immersivetechnology.common.multiblocks.metal.GasTurbine;
import mctmods.immersivetechnology.common.multiblocks.metal.SolarMelter;
import mctmods.immersivetechnology.common.multiblocks.metal.SolarReflector;
import mctmods.immersivetechnology.common.multiblocks.metal.SolarTower;
import mctmods.immersivetechnology.common.multiblocks.metal.SteamTurbine;
import mctmods.immersivetechnology.common.multiblocks.metal.SteelSheetmetalTank;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.AlternatorLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.BoilerLiquidLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.BoilerSolidLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.BoilerTankLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.DistillerLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.GasTurbineLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SolarMelterLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SolarReflectorLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SolarTowerLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SteamTurbineLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SteelSheetmetalTankLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.process.BoilerLiquidProcess;
import mctmods.immersivetechnology.common.multiblocks.metal.process.BoilerSolidProcess;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.AlternatorShape;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.BoilerLiquidShape;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.BoilerSolidShape;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.BoilerTankShape;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.DistillerShape;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.GasTurbineShape;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.SolarMelterShape;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.SolarReflectorShape;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.SolarTowerShape;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.SteamTurbineShape;
import mctmods.immersivetechnology.common.multiblocks.stone.CoolingTower;
import mctmods.immersivetechnology.common.multiblocks.stone.logic.CoolingTowerLogic;
import mctmods.immersivetechnology.common.multiblocks.stone.shapes.CoolingTowerShape;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.registration.ITBlockEntities;
import mctmods.immersivetechnology.core.registration.ITBlocks;
import mctmods.immersivetechnology.core.registration.ITItems;
import mctmods.immersivetechnology.core.registration.ITMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.DeferredRegister;

public class ITMultiblockProvider {
    public static HashMap<String, MultiblockRegistration<?>> MB_REGISTRY_MAP = new HashMap();
    public static final HashMap<String, TemplateMultiblock> MB_TEMPLATE_MAP = new HashMap();
    public static Function<String, TemplateMultiblock> getMBTemplate = MB_TEMPLATE_MAP::get;
    public static final MultiblockRegistration<AlternatorLogic.State> ALTERNATOR = ((ITMultiblockBuilder)((ITMultiblockBuilder)ITMultiblockProvider.metalNoMirror(new AlternatorLogic(), "alternator").structure(() -> getMBTemplate.apply("alternator"))).component((IMultiblockComponent)new ITDisassemblyTicker(AlternatorShape.DISASSEMBLY_POS), state -> null)).build();
    public static final MultiblockRegistration<BoilerLiquidLogic.State> BOILER_LIQUID = ((ITMultiblockBuilder)((ITMultiblockBuilder)((ITMultiblockBuilder)((ITMultiblockBuilder)ITMultiblockProvider.metalNoMirror(new BoilerLiquidLogic(), "boiler_liquid").structure(() -> getMBTemplate.apply("boiler_liquid"))).redstone(s -> s.rsState, BoilerLiquidLogic.REDSTONE_POI).component(new BoilerLiquidProcess())).component(new ITClearTank<BoilerLiquidLogic.State>(BoilerLiquidLogic.FLUID_INPUT_POI, s -> s.tanks.input1().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE), (Component)Component.m_237115_((String)TranslationKey.GUI_INPUT_TANK_CLEARED.getLocation())))).component((IMultiblockComponent)new ITDisassemblyTicker(BoilerLiquidShape.DISASSEMBLY_POS), state -> null)).gui(ITMenuTypes.BOILER_LIQUID_MENU).build();
    public static final MultiblockRegistration<BoilerSolidLogic.State> BOILER_SOLID = ((ITMultiblockBuilder)((ITMultiblockBuilder)((ITMultiblockBuilder)ITMultiblockProvider.metalNoMirrorWithActive(new BoilerSolidLogic(), "boiler_solid").structure(() -> getMBTemplate.apply("boiler_solid"))).redstone(s -> s.rsState, BoilerSolidLogic.REDSTONE_POI).component(new BoilerSolidProcess())).component((IMultiblockComponent)new ITDisassemblyTicker(BoilerSolidShape.DISASSEMBLY_POS), state -> null)).gui(ITMenuTypes.BOILER_SOLID_MENU).build();
    public static final MultiblockRegistration<BoilerTankLogic.State> BOILER_TANK = ((ITMultiblockBuilder)((ITMultiblockBuilder)((ITMultiblockBuilder)ITMultiblockProvider.metalNoMirror(new BoilerTankLogic(), "boiler_tank").structure(() -> getMBTemplate.apply("boiler_tank"))).component(new ITClearTank<BoilerTankLogic.State>(BoilerTankLogic.FLUID_INPUT_POI, s -> s.tanks.input().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE), (Component)Component.m_237115_((String)TranslationKey.GUI_INPUT_TANK_CLEARED.getLocation())))).component((IMultiblockComponent)new ITDisassemblyTicker(BoilerTankShape.DISASSEMBLY_POS), state -> null)).gui(ITMenuTypes.BOILER_TANK_MENU).build();
    public static final MultiblockRegistration<CoolingTowerLogic.State> COOLING_TOWER = ((ITMultiblockBuilder)((ITMultiblockBuilder)((ITMultiblockBuilder)ITMultiblockProvider.metal(new CoolingTowerLogic(), "cooling_tower").structure(() -> getMBTemplate.apply("cooling_tower"))).component(new ITClearTank<CoolingTowerLogic.State>(CoolingTowerLogic.FLUID_INPUT_POIS, s -> {
        s.tanks.input0().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        s.tanks.input1().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
    }, (Component)Component.m_237115_((String)TranslationKey.GUI_INPUT_TANKS_CLEARED.getLocation())))).component((IMultiblockComponent)new ITDisassemblyTicker(CoolingTowerShape.DISASSEMBLY_POS), state -> null)).build();
    public static final MultiblockRegistration<DistillerLogic.State> DISTILLER = ((ITMultiblockBuilder)((ITMultiblockBuilder)((ITMultiblockBuilder)ITMultiblockProvider.metal(new DistillerLogic(), "distiller").structure(() -> getMBTemplate.apply("distiller"))).redstone(s -> s.rsState, DistillerLogic.REDSTONE_POI).component(new ITClearTank<DistillerLogic.State>((List<BlockPos>)ImmutableList.of((Object)DistillerLogic.INPUT_FLUID_POI.posInMultiblock()), s -> s.tanks.input().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE), (Component)Component.m_237115_((String)TranslationKey.GUI_INPUT_TANK_CLEARED.getLocation())))).component((IMultiblockComponent)new ITDisassemblyTicker(DistillerShape.DISASSEMBLY_POS), state -> null)).gui(ITMenuTypes.DISTILLER_MENU).build();
    public static final MultiblockRegistration<GasTurbineLogic.State> GAS_TURBINE = ((ITMultiblockBuilder)((ITMultiblockBuilder)((ITMultiblockBuilder)ITMultiblockProvider.metal(new GasTurbineLogic(), "gas_turbine").structure(() -> getMBTemplate.apply("gas_turbine"))).redstone(s -> s.rsState, GasTurbineLogic.REDSTONE_POI).component(new ITClearTank<GasTurbineLogic.State>((List<BlockPos>)ImmutableList.of((Object)GasTurbineLogic.INPUT_FLUID_POI.posInMultiblock()), s -> s.tanks.input().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE), (Component)Component.m_237115_((String)TranslationKey.GUI_INPUT_TANK_CLEARED.getLocation())))).component((IMultiblockComponent)new ITDisassemblyTicker(GasTurbineShape.DISASSEMBLY_POS), state -> null)).build();
    public static final MultiblockRegistration<SolarMelterLogic.State> SOLAR_MELTER = ((ITMultiblockBuilder)((ITMultiblockBuilder)((ITMultiblockBuilder)ITMultiblockProvider.metalNoMirror(new SolarMelterLogic(), "solar_melter").structure(() -> getMBTemplate.apply("solar_melter"))).redstone(s -> s.rsState, SolarMelterLogic.REDSTONE_POI).component(new ITClearTank<SolarMelterLogic.State>((List<BlockPos>)ImmutableList.of((Object)SolarMelterLogic.INPUT_FLUID_POI.posInMultiblock()), s -> s.tanks.input().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE), (Component)Component.m_237115_((String)TranslationKey.GUI_INPUT_TANK_CLEARED.getLocation())))).component((IMultiblockComponent)new ITDisassemblyTicker(SolarMelterShape.DISASSEMBLY_POS), state -> null)).gui(ITMenuTypes.SOLAR_MELTER_MENU).build();
    public static final MultiblockRegistration<SolarReflectorLogic.State> SOLAR_REFLECTOR = ((ITMultiblockBuilder)((ITMultiblockBuilder)ITMultiblockProvider.metalNoMirror(new SolarReflectorLogic(), "solar_reflector").structure(() -> getMBTemplate.apply("solar_reflector"))).component((IMultiblockComponent)new ITDisassemblyTicker(SolarReflectorShape.DISASSEMBLY_POS), state -> null)).build();
    public static final MultiblockRegistration<SolarTowerLogic.State> SOLAR_TOWER = ((ITMultiblockBuilder)((ITMultiblockBuilder)((ITMultiblockBuilder)ITMultiblockProvider.metalNoMirror(new SolarTowerLogic(), "solar_tower").structure(() -> getMBTemplate.apply("solar_tower"))).redstone(s -> s.rsState, SolarTowerLogic.REDSTONE_POI).component(new ITClearTank<SolarTowerLogic.State>((List<BlockPos>)ImmutableList.of((Object)SolarTowerLogic.INPUT_FLUID_POI.posInMultiblock()), s -> s.tanks.input().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE), (Component)Component.m_237115_((String)TranslationKey.GUI_INPUT_TANK_CLEARED.getLocation())))).component((IMultiblockComponent)new ITDisassemblyTicker(SolarTowerShape.DISASSEMBLY_POS), state -> null)).gui(ITMenuTypes.SOLAR_TOWER_MENU).build();
    public static final MultiblockRegistration<SteamTurbineLogic.State> STEAM_TURBINE = ((ITMultiblockBuilder)((ITMultiblockBuilder)((ITMultiblockBuilder)ITMultiblockProvider.metal(new SteamTurbineLogic(), "steam_turbine").structure(() -> getMBTemplate.apply("steam_turbine"))).redstone(s -> s.rsState, SteamTurbineLogic.REDSTONE_POI).component(new ITClearTank<SteamTurbineLogic.State>((List<BlockPos>)ImmutableList.of((Object)SteamTurbineLogic.INPUT_FLUID_POI.posInMultiblock()), s -> s.tanks.input().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE), (Component)Component.m_237115_((String)TranslationKey.GUI_INPUT_TANK_CLEARED.getLocation())))).component((IMultiblockComponent)new ITDisassemblyTicker(SteamTurbineShape.DISASSEMBLY_POS), state -> null)).build();
    public static final MultiblockRegistration<SteelSheetmetalTankLogic.State> STEEL_SHEETMETAL_TANK = ((ITMultiblockBuilder)((ITMultiblockBuilder)ITMultiblockProvider.metalNoMirror(new SteelSheetmetalTankLogic(), "steel_sheetmetal_tank").structure(() -> getMBTemplate.apply("steel_sheetmetal_tank"))).redstone(s -> s.rsState, SteelSheetmetalTankLogic.REDSTONE_POI).withComparator()).build();

    private static <T extends MultiblockHandler.IMultiblock> T registerMultiblock(T multiblock) {
        MultiblockHandler.registerMultiblock(multiblock);
        return multiblock;
    }

    private static void registerMB(String registry_name, ITTemplateMultiblock block, MultiblockRegistration<?> registration) {
        ITMultiblockProvider.registerMultiblockTemplate(registry_name, block);
        MB_REGISTRY_MAP.put(registry_name, registration);
    }

    public static void registerMultiblockTemplate(String registry_name, TemplateMultiblock template) {
        MB_TEMPLATE_MAP.put(registry_name, ITMultiblockProvider.registerMultiblock(template));
    }

    public static <S extends IMultiblockState> ITMultiblockBuilder<S> stone(IMultiblockLogic<S> logic, String name, boolean solid) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60913_(2.0f, 20.0f);
        if (!solid) {
            properties.m_60955_();
        }
        return ((ITMultiblockBuilder)new ITMultiblockBuilder<S>(logic, name).notMirrored()).customBlock((DeferredRegister)ITBlocks.REGISTER, (DeferredRegister)ITItems.REGISTER, r -> new ITNonMirrorableWithActiveBlock(properties, r), ITBlockItem::new).customBEs(ITBlockEntities.REGISTER);
    }

    public static <S extends IMultiblockState> ITMultiblockBuilder<S> metal(IMultiblockLogic<S> logic, String name) {
        return new ITMultiblockBuilder<S>(logic, name).customBlock((DeferredRegister)ITBlocks.REGISTER, (DeferredRegister)ITItems.REGISTER, r -> new ITMultiblockPartBlockWithMirror(ITBlocks.METAL_PROPERTIES_NO_OCCLUSION.get(), r), ITBlockItem::new).customBEs(ITBlockEntities.REGISTER);
    }

    public static <S extends IMultiblockState> ITMultiblockBuilder<S> metalNoMirror(IMultiblockLogic<S> logic, String name) {
        return ((ITMultiblockBuilder)new ITMultiblockBuilder<S>(logic, name).notMirrored()).customBlock((DeferredRegister)ITBlocks.REGISTER, (DeferredRegister)ITItems.REGISTER, r -> new ITMultiblockPartBlockNonMirror(ITBlocks.METAL_PROPERTIES_NO_OCCLUSION.get(), r), ITBlockItem::new).customBEs(ITBlockEntities.REGISTER);
    }

    public static <S extends IMultiblockState> ITMultiblockBuilder<S> metalNoMirrorWithActive(IMultiblockLogic<S> logic, String name) {
        return ((ITMultiblockBuilder)new ITMultiblockBuilder<S>(logic, name).notMirrored()).customBlock((DeferredRegister)ITBlocks.REGISTER, (DeferredRegister)ITItems.REGISTER, r -> new ITMultiblockPartBlockNonMirrorActive(ITBlocks.METAL_PROPERTIES_NO_OCCLUSION.get(), r), ITBlockItem::new).customBEs(ITBlockEntities.REGISTER);
    }

    public static List<Class<? extends Block>> getAllBlockClasses() {
        return List.of(((MultiblockPartBlock)ALTERNATOR.block().get()).getClass(), ((MultiblockPartBlock)BOILER_LIQUID.block().get()).getClass(), ((MultiblockPartBlock)BOILER_SOLID.block().get()).getClass(), ((MultiblockPartBlock)BOILER_TANK.block().get()).getClass(), ((MultiblockPartBlock)COOLING_TOWER.block().get()).getClass(), ((MultiblockPartBlock)DISTILLER.block().get()).getClass(), ((MultiblockPartBlock)GAS_TURBINE.block().get()).getClass(), ((MultiblockPartBlock)SOLAR_MELTER.block().get()).getClass(), ((MultiblockPartBlock)SOLAR_REFLECTOR.block().get()).getClass(), ((MultiblockPartBlock)SOLAR_TOWER.block().get()).getClass(), ((MultiblockPartBlock)STEAM_TURBINE.block().get()).getClass(), ((MultiblockPartBlock)STEEL_SHEETMETAL_TANK.block().get()).getClass());
    }

    public static void init() {
        ITMultiblockProvider.registerMB("alternator", Alternator.INSTANCE, ALTERNATOR);
        ITMultiblockProvider.registerMB("boiler_liquid", BoilerLiquid.INSTANCE, BOILER_LIQUID);
        ITMultiblockProvider.registerMB("boiler_solid", BoilerSolid.INSTANCE, BOILER_SOLID);
        ITMultiblockProvider.registerMB("boiler_tank", BoilerTank.INSTANCE, BOILER_TANK);
        ITMultiblockProvider.registerMB("cooling_tower", CoolingTower.INSTANCE, COOLING_TOWER);
        ITMultiblockProvider.registerMB("distiller", Distiller.INSTANCE, DISTILLER);
        ITMultiblockProvider.registerMB("gas_turbine", GasTurbine.INSTANCE, GAS_TURBINE);
        ITMultiblockProvider.registerMB("solar_melter", SolarMelter.INSTANCE, SOLAR_MELTER);
        ITMultiblockProvider.registerMB("solar_reflector", SolarReflector.INSTANCE, SOLAR_REFLECTOR);
        ITMultiblockProvider.registerMB("solar_tower", SolarTower.INSTANCE, SOLAR_TOWER);
        ITMultiblockProvider.registerMB("steam_turbine", SteamTurbine.INSTANCE, STEAM_TURBINE);
        ITMultiblockProvider.registerMB("steel_sheetmetal_tank", SteelSheetmetalTank.INSTANCE, STEEL_SHEETMETAL_TANK);
    }

    public static void forceClassLoad() {
        ITMultiblockProvider.init();
    }
}

