/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.core.registration;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.common.fluids.ITFluid;
import mctmods.immersivetechnology.common.fluids.ITFluidBlock;
import mctmods.immersivetechnology.core.lib.ITLib;
import mctmods.immersivetechnology.core.registration.ITBlocks;
import mctmods.immersivetechnology.core.registration.ITItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public class ITFluids {
    public static final DeferredRegister<Fluid> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"immersivetechnology");
    public static final DeferredRegister<FluidType> TYPE_REGISTER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"immersivetechnology");
    public static final List<FluidEntry> ALL_ENTRIES = new ArrayList<FluidEntry>();
    public static final Set<ITBlocks.BlockEntry<? extends LiquidBlock>> ALL_FLUID_BLOCKS = new HashSet<ITBlocks.BlockEntry<? extends LiquidBlock>>();
    private static final HashMap<String, RegistryObject<? extends Fluid>> FLUID_REGISTRY_MAP = new HashMap();
    public static Function<String, Fluid> getFluid = key -> (Fluid)FLUID_REGISTRY_MAP.get(key).get();
    public static final FluidEntry CHLORINE = FluidEntry.make("chlorine", 0, ITLib.rl("block/fluid/fluid_gas_still"), ITLib.rl("block/fluid/fluid_gas_flowing"), props -> props.density(-100).viscosity(1000), -4135301);
    public static final FluidEntry EXHAUST_STEAM = FluidEntry.make("exhaust_steam", 0, ITLib.rl("block/fluid/fluid_gas_still"), ITLib.rl("block/fluid/fluid_gas_flowing"), props -> props.density(-100).viscosity(500).temperature(500), -4079163);
    public static final FluidEntry GRAVEL_SLURRY = FluidEntry.make("gravel_slurry", 0, ITLib.rl("block/fluid/fluid_still"), ITLib.rl("block/fluid/fluid_flowing"), props -> props.density(1000).viscosity(1000), -9607835);
    public static final FluidEntry DISTILLED_WATER = FluidEntry.make("distilled_water", 0, ITLib.rl("block/fluid/fluid_still"), ITLib.rl("block/fluid/fluid_flowing"), props -> props.density(1000).viscosity(1000), -9405984);
    public static final FluidEntry FLUE_GAS = FluidEntry.make("flue_gas", 0, ITLib.rl("block/fluid/fluid_gas_still"), ITLib.rl("block/fluid/fluid_gas_flowing"), props -> props.density(-100).viscosity(500), -1);
    public static final FluidEntry HEATED_GRAVEL = FluidEntry.make("heated_gravel_slurry", 0, ITLib.rl("block/fluid/molten_still"), ITLib.rl("block/fluid/molten_flowing"), props -> props.density(930).viscosity(10000).temperature(400), -5724506);
    public static final FluidEntry HEATED_SALT = FluidEntry.make("heated_salt_slurry", 0, ITLib.rl("block/fluid/molten_still"), ITLib.rl("block/fluid/molten_flowing"), props -> props.density(930).viscosity(10000).temperature(400), -4013374);
    public static final FluidEntry MOLTEN_SALT = FluidEntry.make("molten_salt", 0, ITLib.rl("block/fluid/molten_still"), ITLib.rl("block/fluid/molten_flowing"), props -> props.density(1000).viscosity(10000).temperature(1000), -5332830);
    public static final FluidEntry SALT_SLURRY = FluidEntry.make("salt_slurry", 0, ITLib.rl("block/fluid/fluid_still"), ITLib.rl("block/fluid/fluid_flowing"), props -> props.density(1000).viscosity(1000), -4496088);
    public static final FluidEntry STEAM = FluidEntry.make("steam", 0, ITLib.rl("block/fluid/fluid_gas_still"), ITLib.rl("block/fluid/fluid_gas_flowing"), props -> props.density(-100).viscosity(500).temperature(1000), -12696497);

    public static List<? extends Fluid> getITFluids() {
        return REGISTER.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
    }

    static {
        FLUID_REGISTRY_MAP.put("chlorine", CHLORINE.getStillGetter());
        FLUID_REGISTRY_MAP.put("distilled_water", DISTILLED_WATER.getStillGetter());
        FLUID_REGISTRY_MAP.put("exhaust_steam", EXHAUST_STEAM.getStillGetter());
        FLUID_REGISTRY_MAP.put("flue_gas", FLUE_GAS.getStillGetter());
        FLUID_REGISTRY_MAP.put("gravel_slurry", GRAVEL_SLURRY.getStillGetter());
        FLUID_REGISTRY_MAP.put("heated_salt_slurry", HEATED_SALT.getStillGetter());
        FLUID_REGISTRY_MAP.put("molten_salt", MOLTEN_SALT.getStillGetter());
        FLUID_REGISTRY_MAP.put("salt_slurry", SALT_SLURRY.getStillGetter());
        FLUID_REGISTRY_MAP.put("steam", STEAM.getStillGetter());
    }

    public record FluidEntry(RegistryObject<ITFluid> flowing, RegistryObject<ITFluid> still, ITBlocks.BlockEntry<ITFluidBlock> block, RegistryObject<BucketItem> bucket, RegistryObject<FluidType> type, List<Property<?>> properties, int tintColor) {
        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex) {
            return FluidEntry.make(name, 0, stillTex, flowingTex, null, -1);
        }

        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex, Consumer<FluidType.Properties> buildAttributes) {
            return FluidEntry.make(name, 0, stillTex, flowingTex, buildAttributes, -1);
        }

        private static FluidEntry make(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex) {
            return FluidEntry.make(name, burnTime, stillTex, flowingTex, null, -1);
        }

        private static FluidEntry make(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex, @Nullable Consumer<FluidType.Properties> buildAttributes, int tintColor) {
            return FluidEntry.make(name, burnTime, stillTex, flowingTex, ITFluid::new, ITFluid.Flowing::new, buildAttributes, ImmutableList.of(), tintColor);
        }

        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex, Function<FluidEntry, ? extends ITFluid> makeStill, Function<FluidEntry, ? extends ITFluid> makeFlowing, @Nullable Consumer<FluidType.Properties> buildAttributes, ImmutableList<Property<?>> properties, int tintColor) {
            return FluidEntry.make(name, 0, stillTex, flowingTex, makeStill, makeFlowing, buildAttributes, properties, tintColor);
        }

        private static FluidEntry make(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex, Function<FluidEntry, ? extends ITFluid> makeStill, Function<FluidEntry, ? extends ITFluid> makeFlowing, @Nullable Consumer<FluidType.Properties> buildAttributes, List<Property<?>> properties, int tintColor) {
            FluidType.Properties builder = FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_);
            if (buildAttributes != null) {
                buildAttributes.accept(builder);
            }
            RegistryObject type = TYPE_REGISTER.register(name, () -> FluidEntry.makeTypeWithTextures(builder, stillTex, flowingTex, tintColor));
            MutableObject thisMutable = new MutableObject();
            RegistryObject still = REGISTER.register(name, () -> FluidEntry.lambda$make$1(makeStill, (Mutable)thisMutable));
            RegistryObject flowing = REGISTER.register(name + "_flowing", () -> FluidEntry.lambda$make$2(makeFlowing, (Mutable)thisMutable));
            ITBlocks.BlockEntry<ITFluidBlock> block = new ITBlocks.BlockEntry<ITFluidBlock>(name + "_fluid_block", () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_), arg_0 -> FluidEntry.lambda$make$4((Mutable)thisMutable, arg_0));
            RegistryObject bucket = ITItems.REGISTER.register(name + "_bucket", () -> FluidEntry.makeBucket((RegistryObject<ITFluid>)still, burnTime));
            FluidEntry entry = new FluidEntry((RegistryObject<ITFluid>)flowing, (RegistryObject<ITFluid>)still, block, (RegistryObject<BucketItem>)bucket, (RegistryObject<FluidType>)type, properties, tintColor);
            thisMutable.setValue((Object)entry);
            ALL_FLUID_BLOCKS.add(block);
            ALL_ENTRIES.add(entry);
            return entry;
        }

        private static FluidType makeTypeWithTextures(FluidType.Properties builder, final ResourceLocation stillTex, final ResourceLocation flowingTex, final int tintColor) {
            return new FluidType(builder){

                public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                    consumer.accept(new IClientFluidTypeExtensions(){

                        public ResourceLocation getStillTexture() {
                            return stillTex;
                        }

                        public ResourceLocation getFlowingTexture() {
                            return flowingTex;
                        }

                        public int getTintColor() {
                            return tintColor;
                        }
                    });
                }
            };
        }

        public ITFluid getFlowing() {
            return (ITFluid)((Object)this.flowing.get());
        }

        public ITFluid getStill() {
            return (ITFluid)((Object)this.still.get());
        }

        public ITFluidBlock getBlock() {
            return this.block.get();
        }

        public BucketItem getBucket() {
            return (BucketItem)this.bucket.get();
        }

        private static BucketItem makeBucket(RegistryObject<ITFluid> still, final int burnTime) {
            return new BucketItem((Supplier)still, new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_)){

                @NotNull
                public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, @Nullable CompoundTag nbt) {
                    return new FluidBucketWrapper(stack);
                }

                public int getBurnTime(ItemStack itemStack, RecipeType<?> type) {
                    return burnTime;
                }

                public boolean emptyContents(@Nullable Player player, Level level, BlockPos pos, @Nullable HitResult target) {
                    FluidState placedState;
                    boolean result;
                    if (target == null) {
                        result = super.emptyContents(player, level, pos, null, null);
                    } else if (target instanceof BlockHitResult) {
                        BlockHitResult blockHitResult = (BlockHitResult)target;
                        result = super.emptyContents(player, level, pos, blockHitResult, null);
                    } else {
                        return false;
                    }
                    if (result && (placedState = level.m_6425_(pos)).m_76152_().getFluidType().getDensity() < 0) {
                        level.m_186469_(pos, placedState.m_76152_(), 100);
                    }
                    return result;
                }
            };
        }

        public RegistryObject<ITFluid> getStillGetter() {
            return this.still;
        }

        private static /* synthetic */ ITFluidBlock lambda$make$4(Mutable thisMutable, BlockBehaviour.Properties p) {
            return new ITFluidBlock((FluidEntry)thisMutable.getValue(), p);
        }

        private static /* synthetic */ ITFluid lambda$make$2(Function makeFlowing, Mutable thisMutable) {
            return ITFluid.makeFluid(makeFlowing, (FluidEntry)thisMutable.getValue());
        }

        private static /* synthetic */ ITFluid lambda$make$1(Function makeStill, Mutable thisMutable) {
            return ITFluid.makeFluid(makeStill, (FluidEntry)thisMutable.getValue());
        }
    }
}

