/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.core.proxy;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.Tree;
import java.util.function.Supplier;
import mctmods.immersivetechnology.client.gui.BoilerLiquidScreen;
import mctmods.immersivetechnology.client.gui.BoilerSolidScreen;
import mctmods.immersivetechnology.client.gui.BoilerTankScreen;
import mctmods.immersivetechnology.client.gui.CrateCreativeScreen;
import mctmods.immersivetechnology.client.gui.DistillerScreen;
import mctmods.immersivetechnology.client.gui.RotorCreativeScreen;
import mctmods.immersivetechnology.client.gui.SolarScreen;
import mctmods.immersivetechnology.client.gui.TrashItemScreen;
import mctmods.immersivetechnology.client.gui.ValveFluidScreen;
import mctmods.immersivetechnology.client.gui.ValveLimiterScreen;
import mctmods.immersivetechnology.client.gui.ValveLoadScreen;
import mctmods.immersivetechnology.client.gui.helper.ITContainerScreen;
import mctmods.immersivetechnology.client.models.RotorModels;
import mctmods.immersivetechnology.client.models.SolarReflectorModels;
import mctmods.immersivetechnology.client.models.helper.ITDynamicModel;
import mctmods.immersivetechnology.client.models.helper.ITModelConfigurableSides;
import mctmods.immersivetechnology.client.models.helper.ITObjLoader;
import mctmods.immersivetechnology.client.models.mirror.ITMirroredModelLoader;
import mctmods.immersivetechnology.client.models.split.ITSplitModelLoader;
import mctmods.immersivetechnology.client.particles.helper.ITColoredSmokeProvider;
import mctmods.immersivetechnology.client.particles.helper.ITSmokeCustomProvider;
import mctmods.immersivetechnology.client.renderer.GasTurbineRenderer;
import mctmods.immersivetechnology.client.renderer.OpenBarrelRenderer;
import mctmods.immersivetechnology.client.renderer.RotorCreativeRenderer;
import mctmods.immersivetechnology.client.renderer.SolarMelterRenderer;
import mctmods.immersivetechnology.client.renderer.SolarReflectorRenderer;
import mctmods.immersivetechnology.client.renderer.SteamTurbineRenderer;
import mctmods.immersivetechnology.client.renderer.SteelSheetmetalTankRenderer;
import mctmods.immersivetechnology.common.blocks.metal.gui.RotorCreativeMenu;
import mctmods.immersivetechnology.common.blocks.metal.gui.ValveFluidMenu;
import mctmods.immersivetechnology.common.blocks.metal.gui.ValveLimiterMenu;
import mctmods.immersivetechnology.common.blocks.metal.gui.ValveLoadMenu;
import mctmods.immersivetechnology.common.items.helper.ITFlagItem;
import mctmods.immersivetechnology.core.lib.ITLib;
import mctmods.immersivetechnology.core.proxy.CommonProxy;
import mctmods.immersivetechnology.core.registration.ITBlockEntities;
import mctmods.immersivetechnology.core.registration.ITFluids;
import mctmods.immersivetechnology.core.registration.ITItems;
import mctmods.immersivetechnology.core.registration.ITMenuTypes;
import mctmods.immersivetechnology.core.registration.ITMultiblockProvider;
import mctmods.immersivetechnology.core.registration.ITParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="immersivetechnology", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy
extends CommonProxy {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            for (ITFluids.FluidEntry entry : ITFluids.ALL_ENTRIES) {
                ItemBlockRenderTypes.setRenderLayer((Fluid)entry.getStill(), (RenderType)RenderType.m_110466_());
                ItemBlockRenderTypes.setRenderLayer((Fluid)entry.getFlowing(), (RenderType)RenderType.m_110466_());
            }
            MenuScreens.m_96206_(ITMenuTypes.BOILER_LIQUID_MENU.getType(), BoilerLiquidScreen::new);
            MenuScreens.m_96206_(ITMenuTypes.BOILER_SOLID_MENU.getType(), BoilerSolidScreen::new);
            MenuScreens.m_96206_(ITMenuTypes.BOILER_TANK_MENU.getType(), BoilerTankScreen::new);
            MenuScreens.m_96206_(ITMenuTypes.CRATE_CREATIVE.getType(), CrateCreativeScreen::new);
            MenuScreens.m_96206_(ITMenuTypes.DISTILLER_MENU.getType(), DistillerScreen::new);
            MenuScreens.m_96206_(ITMenuTypes.TRASH_ITEM.getType(), TrashItemScreen::new);
            MenuScreens.m_96206_(ITMenuTypes.SOLAR_MELTER_MENU.getType(), SolarScreen::new);
            MenuScreens.m_96206_(ITMenuTypes.SOLAR_TOWER_MENU.getType(), SolarScreen::new);
            MenuScreens.m_96206_(ITMenuTypes.ROTOR_CREATIVE.getType(), (menu, inv, title) -> new RotorCreativeScreen((RotorCreativeMenu)menu, inv));
            MenuScreens.m_96206_(ITMenuTypes.VALVE_FLUID.getType(), (menu, inv, title) -> new ValveFluidScreen((ValveFluidMenu)menu, inv));
            MenuScreens.m_96206_(ITMenuTypes.VALVE_LIMITER.getType(), (menu, inv, title) -> new ValveLimiterScreen((ValveLimiterMenu)menu, inv));
            MenuScreens.m_96206_(ITMenuTypes.VALVE_LOAD.getType(), (menu, inv, title) -> new ValveLoadScreen((ValveLoadMenu)menu, inv));
            ManualInstance instance = ManualHelper.getManual();
            Tree.InnerNode parent_category = instance.getRoot().getOrCreateSubnode((Comparable)ITLib.rl("main"), 99);
            ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            builder.readFromFile(ITLib.rl("intro"));
            instance.addEntry(parent_category, builder.create());
            Tree.InnerNode multiblock_category = parent_category.getOrCreateSubnode((Comparable)ITLib.rl("it_multiblocks"), 0);
            ManualEntry.ManualEntryBuilder multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            multiblock.readFromFile(ITLib.rl("alternator"));
            instance.addEntry(multiblock_category, multiblock.create());
            multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            multiblock.readFromFile(ITLib.rl("boiler_liquid"));
            instance.addEntry(multiblock_category, multiblock.create());
            multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            multiblock.readFromFile(ITLib.rl("boiler_solid"));
            instance.addEntry(multiblock_category, multiblock.create());
            multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            multiblock.readFromFile(ITLib.rl("boiler_tank"));
            instance.addEntry(multiblock_category, multiblock.create());
            multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            multiblock.readFromFile(ITLib.rl("cooling_tower"));
            instance.addEntry(multiblock_category, multiblock.create());
            multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            multiblock.readFromFile(ITLib.rl("distiller"));
            instance.addEntry(multiblock_category, multiblock.create());
            multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            multiblock.readFromFile(ITLib.rl("gas_turbine"));
            instance.addEntry(multiblock_category, multiblock.create());
            multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            multiblock.readFromFile(ITLib.rl("solar_melter"));
            instance.addEntry(multiblock_category, multiblock.create());
            multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            multiblock.readFromFile(ITLib.rl("solar_reflector"));
            instance.addEntry(multiblock_category, multiblock.create());
            multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            multiblock.readFromFile(ITLib.rl("solar_tower"));
            instance.addEntry(multiblock_category, multiblock.create());
            multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            multiblock.readFromFile(ITLib.rl("steam_turbine"));
            instance.addEntry(multiblock_category, multiblock.create());
            multiblock = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
            multiblock.readFromFile(ITLib.rl("steel_sheetmetal_tank"));
            instance.addEntry(multiblock_category, multiblock.create());
        });
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ITParticles.COLORED_SMOKE.get(), ITColoredSmokeProvider::new);
        event.registerSpriteSet((ParticleType)ITParticles.SMOKE_CUSTOM.get(), ITSmokeCustomProvider::new);
    }

    @SubscribeEvent
    public static void onItemColor(RegisterColorHandlersEvent.Item event) {
        for (RegistryObject<? extends Item> holder : ITItems.getItemRegistryMap().values()) {
            Item i = (Item)holder.get();
            if (!(i instanceof ITFlagItem)) continue;
            event.register((stack, tintIndex) -> {
                Item patt9248$temp = stack.m_41720_();
                if (patt9248$temp instanceof ITFlagItem) {
                    ITFlagItem type = (ITFlagItem)patt9248$temp;
                    return type.getColor(tintIndex);
                }
                return 0xFFFFFF;
            }, new ItemLike[]{i});
        }
        for (ITFluids.FluidEntry entry : ITFluids.ALL_ENTRIES) {
            int tint = entry.tintColor();
            event.register((stack, index) -> {
                if (index == 1) {
                    return tint;
                }
                return -1;
            }, new ItemLike[]{(ItemLike)entry.bucket().get()});
        }
    }

    @SubscribeEvent
    public static void onBlockColor(RegisterColorHandlersEvent.Block event) {
        for (ITFluids.FluidEntry entry : ITFluids.ALL_ENTRIES) {
            int tint = entry.tintColor();
            event.register((state, level, pos, index) -> tint, new Block[]{entry.block().get()});
        }
    }

    @Override
    public void reinitializeGUI() {
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen instanceof ITContainerScreen) {
            currentScreen.m_6575_(Minecraft.m_91087_(), currentScreen.f_96543_, currentScreen.f_96544_);
        }
    }

    @Override
    public Level getClientWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    @Override
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @SubscribeEvent
    public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders ev) {
        ev.register("obj", (IGeometryLoader)ITObjLoader.INSTANCE);
        ev.register(ITModelConfigurableSides.Loader.NAME.m_135815_(), (IGeometryLoader)new ITModelConfigurableSides.Loader());
        ev.register(ITMirroredModelLoader.ID.m_135815_(), (IGeometryLoader)new ITMirroredModelLoader());
        ev.register(ITSplitModelLoader.LOCATION.m_135815_(), (IGeometryLoader)new ITSplitModelLoader());
        RotorModels.ROTOR = new ITDynamicModel("rotor");
        RotorModels.ROTOR_EAST_WEST = new ITDynamicModel("rotor_east_west");
        SolarReflectorModels.SUPPORT = new ITDynamicModel("solar_reflector_support");
        SolarReflectorModels.MIRROR = new ITDynamicModel("solar_reflector_mirror");
    }

    @SubscribeEvent
    public static void registerRenders(EntityRenderersEvent.RegisterRenderers event) {
        ClientProxy.registerBERenders(event);
    }

    private static <T extends BlockEntity> void registerBERender(EntityRenderersEvent.RegisterRenderers event, Supplier<BlockEntityType<? extends T>> type, BlockEntityRendererProvider<T> provider) {
        event.registerBlockEntityRenderer(type.get(), provider);
    }

    public static void registerBERenders(EntityRenderersEvent.RegisterRenderers event) {
        ClientProxy.registerBERender(event, () -> ITBlockEntities.BARREL_OPEN.get(), ctx3 -> new OpenBarrelRenderer());
        ClientProxy.registerBERender(event, () -> ITBlockEntities.ROTOR_CREATIVE.get(), context -> new RotorCreativeRenderer());
        ClientProxy.registerBERender(event, ITMultiblockProvider.STEAM_TURBINE.masterBE(), ctx2 -> new SteamTurbineRenderer());
        ClientProxy.registerBERender(event, ITMultiblockProvider.GAS_TURBINE.masterBE(), ctx -> new GasTurbineRenderer());
        ClientProxy.registerBERender(event, ITMultiblockProvider.SOLAR_REFLECTOR.masterBE(), ctx1 -> new SolarReflectorRenderer());
        ClientProxy.registerBERender(event, ITMultiblockProvider.SOLAR_MELTER.masterBE(), ctx -> new SolarMelterRenderer());
        ClientProxy.registerBERender(event, ITMultiblockProvider.STEEL_SHEETMETAL_TANK.masterBE(), ctx -> new SteelSheetmetalTankRenderer());
    }
}

