/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.solarregistry;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mctmods.immersivetechnology.common.util.solarregistry.SolarRegistryData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class SolarRegistry {
    public static final int SOLAR_MAX_RANGE = 22;
    public static final int SOLAR_MIN_RANGE = 12;

    public static SolarRegistryData getData(Level level) {
        return (SolarRegistryData)((ServerLevel)level).m_8895_().m_164861_(SolarRegistryData::load, SolarRegistryData::new, "it_solar_registry");
    }

    public static synchronized RegisterResult registerTower(Level level, BlockPos base) {
        RegisterResult result = new RegisterResult();
        if (level.f_46443_) {
            return result;
        }
        SolarRegistryData data = SolarRegistry.getData(level);
        int y = base.m_123342_();
        Set towersAtY = data.towerBasesByY.computeIfAbsent(y, k -> new HashSet());
        if (towersAtY.contains(base)) {
            result.success = true;
            return result;
        }
        boolean verticalFail = false;
        double minDist = Double.MAX_VALUE;
        boolean overlapFail = false;
        for (Set<BlockPos> set : data.towerBasesByY.values()) {
            for (BlockPos existing : set) {
                int dx = base.m_123341_() - existing.m_123341_();
                int dy = base.m_123342_() - existing.m_123342_();
                int dz = base.m_123343_() - existing.m_123343_();
                double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                minDist = Math.min(minDist, dist);
                if (dx == 0 && dz == 0) {
                    verticalFail = true;
                    continue;
                }
                if (!(dist < 44.0)) continue;
                overlapFail = true;
            }
        }
        if (verticalFail) {
            result.vertical = true;
            return result;
        }
        if (overlapFail) {
            result.requiredMove = (int)Math.ceil(44.0 - minDist) + 1;
            return result;
        }
        towersAtY.add(base);
        data.m_77762_();
        result.success = true;
        return result;
    }

    public static synchronized void unregisterTower(Level level, BlockPos base) {
        if (level.f_46443_) {
            return;
        }
        SolarRegistryData data = SolarRegistry.getData(level);
        int y = base.m_123342_();
        if (data.towerBasesByY.containsKey(y)) {
            data.towerBasesByY.get(y).remove(base);
            if (data.towerBasesByY.get(y).isEmpty()) {
                data.towerBasesByY.remove(y);
            }
            data.m_77762_();
        }
    }

    public static synchronized void registerReflector(Level level, BlockPos poi) {
        if (level.f_46443_) {
            return;
        }
        SolarRegistryData data = SolarRegistry.getData(level);
        int y = poi.m_123342_();
        data.reflectorPOIsByY.computeIfAbsent(y, k -> new HashSet()).add(poi);
        data.untakenReflectors.add(poi);
        data.groupsDirty = true;
        data.m_77762_();
    }

    public static synchronized void unregisterReflector(Level level, BlockPos poi) {
        if (level.f_46443_) {
            return;
        }
        SolarRegistryData data = SolarRegistry.getData(level);
        int y = poi.m_123342_();
        if (data.reflectorPOIsByY.containsKey(y)) {
            data.reflectorPOIsByY.get(y).remove(poi);
            if (data.reflectorPOIsByY.get(y).isEmpty()) {
                data.reflectorPOIsByY.remove(y);
            }
            data.untakenReflectors.remove(poi);
            data.groupsDirty = true;
            data.m_77762_();
        }
    }

    public static synchronized void notifyTaken(Level level, BlockPos poi, boolean taken) {
        if (level.f_46443_) {
            return;
        }
        SolarRegistryData data = SolarRegistry.getData(level);
        boolean changed = taken ? data.untakenReflectors.remove(poi) : data.untakenReflectors.add(poi);
        if (changed) {
            data.groupsDirty = true;
            if (taken && data.untakenReflectors.isEmpty()) {
                data.groupData.clear();
                data.groupsDirty = false;
            }
            data.m_77762_();
        }
    }

    public static synchronized void updateDance(Level level) {
        if (level.f_46443_) {
            return;
        }
        SolarRegistryData data = SolarRegistry.getData(level);
        if (data.groupsDirty) {
            SolarRegistry.buildGroups(level);
            data.groupsDirty = false;
            data.m_77762_();
        }
        boolean changed = false;
        for (GroupData gd : data.groupData.values()) {
            float currentPhase;
            if (gd.animationPhase == -5) {
                long currentTime = level.m_46467_();
                if (currentTime < gd.pendingTick) continue;
                gd.danceStartTick = currentTime;
                gd.animationPhase = -2;
                changed = true;
                continue;
            }
            if (gd.animationPhase == -2) {
                float currentPhase2 = (float)(level.m_46467_() - gd.danceStartTick) * 0.05f;
                if (!(currentPhase2 >= 63.0f)) continue;
                gd.animationPhase = -3;
                changed = true;
                continue;
            }
            if (gd.animationPhase != -3 || !((currentPhase = (float)(level.m_46467_() - gd.danceStartTick) * 0.05f) >= 64.0f)) continue;
            gd.animationPhase = -4;
            changed = true;
        }
        if (changed) {
            data.m_77762_();
        }
    }

    private static synchronized void buildGroups(Level level) {
        SolarRegistryData data = SolarRegistry.getData(level);
        data.parent.clear();
        data.rank.clear();
        HashSet<BlockPos> untaken = new HashSet<BlockPos>(data.untakenReflectors);
        for (BlockPos pos : untaken) {
            data.parent.put(pos, pos);
            data.rank.put(pos, 0);
        }
        double connSq = Math.pow(44.0, 2.0);
        int rad = (int)Math.ceil(44.0);
        for (BlockPos blockPos : untaken) {
            int y1 = blockPos.m_123342_();
            for (int dy = -rad; dy <= rad; ++dy) {
                int cy = y1 + dy;
                Set set = data.reflectorPOIsByY.getOrDefault(cy, new HashSet());
                for (BlockPos p2 : set) {
                    if (!untaken.contains(p2) || blockPos.m_121878_() <= p2.m_121878_() || !(blockPos.m_123331_((Vec3i)p2) <= connSq)) continue;
                    SolarRegistry.union(data, blockPos, p2);
                }
            }
        }
        HashMap<BlockPos, Set> groups = new HashMap<BlockPos, Set>();
        for (BlockPos pos : untaken) {
            BlockPos root = SolarRegistry.find(data, pos);
            groups.computeIfAbsent(root, k -> new HashSet()).add(pos);
        }
        HashMap<BlockPos, GroupData> hashMap = new HashMap<BlockPos, GroupData>();
        long currentTime = level.m_46467_();
        for (Map.Entry entry : groups.entrySet()) {
            Integer r;
            BlockPos root = (BlockPos)entry.getKey();
            Set members = (Set)entry.getValue();
            BlockPos leader = members.stream().min(Comparator.comparingLong(BlockPos::m_121878_)).orElse(root);
            GroupData gd = data.groupData.remove(leader);
            int currentSize = members.size();
            if (gd == null || gd.animationPhase == -4 || gd.groupSize != currentSize) {
                gd = new GroupData();
                gd.pendingTick = currentTime + 100L;
                gd.animationPhase = -5;
            }
            gd.groupSize = currentSize;
            hashMap.put(leader, gd);
            if (!leader.equals((Object)root) && (r = data.rank.remove(root)) != null) {
                data.rank.put(leader, r);
            }
            for (BlockPos p : members) {
                data.parent.put(p, leader);
            }
        }
        data.groupData.clear();
        data.groupData.putAll(hashMap);
    }

    public static BlockPos find(SolarRegistryData data, BlockPos pos) {
        BlockPos p = data.parent.get(pos);
        if (p == null) {
            return null;
        }
        if (!pos.equals((Object)p)) {
            BlockPos pp = SolarRegistry.find(data, p);
            data.parent.put(pos, pp);
        }
        return data.parent.get(pos);
    }

    public static void union(SolarRegistryData data, BlockPos a, BlockPos b) {
        int rb;
        BlockPos pa = SolarRegistry.find(data, a);
        BlockPos pb = SolarRegistry.find(data, b);
        if (pa == null || pb == null) {
            return;
        }
        if (pa.equals((Object)pb)) {
            return;
        }
        int ra = data.rank.getOrDefault(pa, 0);
        if (ra > (rb = data.rank.getOrDefault(pb, 0).intValue())) {
            data.parent.put(pb, pa);
        } else {
            data.parent.put(pa, pb);
            if (ra == rb) {
                data.rank.put(pb, rb + 1);
            }
        }
    }

    public static BlockPos findRoot(Level level, BlockPos poi) {
        if (level.f_46443_) {
            return null;
        }
        SolarRegistryData data = SolarRegistry.getData(level);
        return SolarRegistry.find(data, poi);
    }

    public static GroupData getGroupData(Level level, BlockPos root) {
        if (level.f_46443_) {
            return null;
        }
        SolarRegistryData data = SolarRegistry.getData(level);
        return data.groupData.get(root);
    }

    public static synchronized Set<BlockPos> getReflectorsInRange(Level level, BlockPos base, double minDist, double maxDist) {
        if (level.f_46443_) {
            return new HashSet<BlockPos>();
        }
        SolarRegistryData data = SolarRegistry.getData(level);
        int y = base.m_123342_();
        HashSet<BlockPos> inRange = new HashSet<BlockPos>();
        Set allAtY = data.reflectorPOIsByY.getOrDefault(y, new HashSet());
        for (BlockPos poi : allAtY) {
            double distSq = base.m_123331_((Vec3i)poi);
            if (!(distSq >= minDist * minDist) || !(distSq <= maxDist * maxDist)) continue;
            inRange.add(poi);
        }
        return inRange;
    }

    public static class RegisterResult {
        public boolean success = false;
        public boolean vertical = false;
        public int requiredMove = 0;
    }

    public static class GroupData {
        public long danceStartTick = -1L;
        public long pendingTick = -1L;
        public int animationPhase = -4;
        public int groupSize = 1;
    }
}

