/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.multiblock;

import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import mctmods.immersivetechnology.common.util.multiblock.MultiblockData;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.core.lib.ITLib;

public class MultiblockDataLoader {
    private static final Map<String, MultiblockData> CACHE = new HashMap<String, MultiblockData>();

    public static MultiblockData loadMultiblockData(String multiblockName) {
        if (CACHE.containsKey(multiblockName)) {
            return CACHE.get(multiblockName);
        }
        MultiblockData data = null;
        try {
            InputStream is = MultiblockDataLoader.class.getResourceAsStream("/assets/immersivetechnology/multiblocks/" + multiblockName + ".json");
            if (is != null) {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(is));
                Gson gson = new Gson();
                data = (MultiblockData)gson.fromJson(reader, MultiblockData.class);
                reader.close();
                for (PoIJSONSchema poi : data.pointsOfInterest) {
                    if (poi.facing == null) continue;
                    if (poi.facing.isJsonPrimitive()) {
                        String str = poi.facing.getAsString();
                        RelativeBlockFace face = str.isEmpty() || str.equalsIgnoreCase("any") ? null : RelativeBlockFace.valueOf((String)str.toUpperCase());
                        poi.relativeFaces.add(face);
                        continue;
                    }
                    if (!poi.facing.isJsonArray()) continue;
                    for (JsonElement el : poi.facing.getAsJsonArray()) {
                        String str = el.getAsString();
                        RelativeBlockFace face = str.isEmpty() || str.equalsIgnoreCase("any") ? null : RelativeBlockFace.valueOf((String)str.toUpperCase());
                        poi.relativeFaces.add(face);
                    }
                }
            } else {
                ITLib.IT_LOGGER.error("{} JSON resource not found at /assets/immersivetechnology/multiblocks/{}.json", (Object)multiblockName, (Object)multiblockName);
            }
        }
        catch (Exception e) {
            ITLib.IT_LOGGER.error("Error loading {} from JSON", (Object)multiblockName, (Object)e);
        }
        if (data != null) {
            CACHE.put(multiblockName, data);
        }
        return data;
    }
}

