/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.multiblock;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mctmods.immersivetechnology.common.util.multiblock.MultiblockData;
import mctmods.immersivetechnology.core.lib.ITLib;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class GenericShape
implements Function<BlockPos, VoxelShape> {
    public static final AABB FULL_BLOCK = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public static int[] loadDimensions(String multiblockName, String category) {
        String path = "/assets/immersivetechnology/models/multiblock/" + category + "/obj/" + multiblockName + "/" + multiblockName + ".obj";
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxZ = Double.MIN_VALUE;
        InputStream is = GenericShape.class.getResourceAsStream(path);
        boolean hasVertices = false;
        if (is == null) {
            ITLib.IT_LOGGER.error("OBJ file not found at resource path: {} for multiblock: {}", (Object)path, (Object)multiblockName);
        } else {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] parts;
                    if (!(line = line.trim()).startsWith("v ") || (parts = line.split("\\s+")).length < 4) continue;
                    double x = Double.parseDouble(parts[1]);
                    double y = Double.parseDouble(parts[2]);
                    double z = Double.parseDouble(parts[3]);
                    minX = Math.min(minX, x);
                    maxX = Math.max(maxX, x);
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                    minZ = Math.min(minZ, z);
                    maxZ = Math.max(maxZ, z);
                    hasVertices = true;
                }
                if (!hasVertices) {
                    ITLib.IT_LOGGER.warn("OBJ file loaded but no vertices ('v ') found in: {} for multiblock: {}", (Object)path, (Object)multiblockName);
                }
            }
            catch (Exception e) {
                ITLib.IT_LOGGER.error("Error reading OBJ file at {} for multiblock: {}", new Object[]{path, multiblockName, e});
            }
        }
        double dx = maxX - minX;
        double dy = maxY - minY;
        double dz = maxZ - minZ;
        if (dx <= 0.0 || dy <= 0.0 || dz <= 0.0 || !hasVertices) {
            return new int[]{0, 0, 0};
        }
        return new int[]{GenericShape.computeDim(dx), GenericShape.computeDim(dy), GenericShape.computeDim(dz)};
    }

    private static int computeDim(double d) {
        double floor = Math.floor(d);
        if (d == floor) {
            return (int)floor;
        }
        return (int)Math.ceil(d);
    }

    public static List<List<AABB>> loadShapes(MultiblockData data, int expectedNum) {
        if (data.shapeAABB == null) {
            return null;
        }
        ArrayList<List<AABB>> shapes = new ArrayList<List<AABB>>(expectedNum);
        for (JsonElement posElem : data.shapeAABB) {
            ArrayList<AABB> posShapes = new ArrayList<AABB>();
            if (posElem.isJsonNull() || !posElem.isJsonArray()) {
                shapes.add(posShapes);
                continue;
            }
            JsonArray posArray = posElem.getAsJsonArray();
            if (posArray.isEmpty()) {
                posShapes.add(FULL_BLOCK);
            }
            for (JsonElement aabbElem : posArray) {
                JsonArray aabbArray;
                if (!aabbElem.isJsonArray() || (aabbArray = aabbElem.getAsJsonArray()).size() != 6) continue;
                double[] vals = new double[6];
                for (int i = 0; i < 6; ++i) {
                    vals[i] = aabbArray.get(i).getAsDouble();
                }
                posShapes.add(new AABB(vals[0], vals[1], vals[2], vals[3], vals[4], vals[5]));
            }
            shapes.add(posShapes);
        }
        if (shapes.size() != expectedNum) {
            return null;
        }
        return shapes;
    }

    private static VoxelShape toVoxelShape(AABB aabb) {
        return aabb == null ? Shapes.m_83040_() : Shapes.m_83064_((AABB)aabb);
    }

    @Override
    public VoxelShape apply(BlockPos posInMultiblock) {
        List<AABB> list = this.getShape(posInMultiblock);
        if (list.isEmpty()) {
            return Shapes.m_83040_();
        }
        VoxelShape base = GenericShape.toVoxelShape(list.get(0));
        if (list.size() > 1) {
            return list.subList(1, list.size()).stream().map(GenericShape::toVoxelShape).reduce(base, Shapes::m_83110_);
        }
        return base;
    }

    protected abstract List<AABB> getShape(BlockPos var1);

    public static class JsonShape
    extends GenericShape {
        private final int WIDTH;
        private final int HEIGHT;
        private final int LENGTH;
        private final List<List<AABB>> SHAPES;

        public JsonShape(int width, int height, int length, List<List<AABB>> shapes) {
            this.WIDTH = width;
            this.HEIGHT = height;
            this.LENGTH = length;
            this.SHAPES = shapes;
        }

        @Override
        protected List<AABB> getShape(BlockPos posInMultiblock) {
            int x = posInMultiblock.m_123341_();
            int y = posInMultiblock.m_123342_();
            int z = posInMultiblock.m_123343_();
            if (x < 0 || x >= this.WIDTH || y < 0 || y >= this.HEIGHT || z < 0 || z >= this.LENGTH) {
                return new ArrayList<AABB>();
            }
            int index = y * (this.WIDTH * this.LENGTH) + z * this.WIDTH + x;
            if (index < this.SHAPES.size()) {
                return this.SHAPES.get(index);
            }
            return List.of(FULL_BLOCK);
        }
    }
}

