/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.network;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.common.network.ITMessage;
import mctmods.immersivetechnology.common.network.ITMessageContainerData;
import mctmods.immersivetechnology.common.network.ITMessageContainerUpdate;
import mctmods.immersivetechnology.common.network.ITMessageTileSync;
import mctmods.immersivetechnology.common.network.ITOSDRequestMessage;
import mctmods.immersivetechnology.common.network.ITOSDSyncBlock;
import mctmods.immersivetechnology.common.network.ITOSDSyncMessage;
import mctmods.immersivetechnology.core.lib.ITLib;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ITPacketHandler {
    public static final String NET_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ITLib.rl("main")).networkProtocolVersion(() -> "1").serverAcceptedVersions("1"::equals).clientAcceptedVersions("1"::equals).simpleChannel();
    private static int id = 0;

    public static void initialize() {
        ITPacketHandler.registerMessage(ITMessageContainerUpdate.class, ITMessageContainerUpdate::new);
        ITPacketHandler.registerMessage(ITMessageContainerData.class, ITMessageContainerData::new);
        ITPacketHandler.registerMessage(ITOSDRequestMessage.class, ITOSDRequestMessage::new);
        ITPacketHandler.registerMessage(ITOSDSyncMessage.class, ITOSDSyncMessage::new);
        ITPacketHandler.registerMessage(ITOSDSyncBlock.class, ITOSDSyncBlock::new);
        ITPacketHandler.registerMessage(ITMessageTileSync.class, ITMessageTileSync::new);
    }

    public static <T extends ITMessage> void registerMessage(Class<T> type, Function<FriendlyByteBuf, T> decoder) {
        INSTANCE.registerMessage(id++, type, ITMessage::toBytes, decoder, (t, ctx) -> {
            t.process((Supplier<NetworkEvent.Context>)ctx);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public static <MSG> void sendToPlayer(Player player, @Nonnull MSG message) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), message);
        }
    }

    public static <MSG> void sendToServer(MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.SERVER.noArg(), message);
    }

    public static <MSG> void sendToDimension(ResourceKey<Level> dim, MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> dim), message);
    }

    public static <MSG> void sendAll(MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }
}

