/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.network;

import java.util.function.Supplier;
import mctmods.immersivetechnology.common.blocks.metal.logic.OSDCommonBlockEntity;
import mctmods.immersivetechnology.common.blocks.metal.logic.ValveCommonBlockEntity;
import mctmods.immersivetechnology.common.network.ITMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record ITOSDSyncMessage(BlockPos pos, long lastAccepted, long average, int packetAverage) implements ITMessage
{
    public ITOSDSyncMessage(FriendlyByteBuf buf) {
        this(buf.m_130135_(), buf.readLong(), buf.readLong(), buf.readInt());
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeLong(this.lastAccepted);
        buf.writeLong(this.average);
        buf.writeInt(this.packetAverage);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection() == NetworkDirection.PLAY_TO_CLIENT && Minecraft.m_91087_().f_91073_ != null) {
                BlockEntity te = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
                if (te instanceof OSDCommonBlockEntity) {
                    OSDCommonBlockEntity osd = (OSDCommonBlockEntity)te;
                    osd.lastAcceptedAmount = this.lastAccepted;
                }
                if (te instanceof ValveCommonBlockEntity) {
                    ValveCommonBlockEntity valve = (ValveCommonBlockEntity)te;
                    valve.lastAcceptedAmount = this.lastAccepted;
                    valve.average = this.average;
                    valve.packetAverage = this.packetAverage;
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

