/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.network;

import java.util.function.Supplier;
import mctmods.immersivetechnology.common.blocks.metal.logic.OSDCommonBlockEntity;
import mctmods.immersivetechnology.common.blocks.metal.logic.ValveCommonBlockEntity;
import mctmods.immersivetechnology.common.network.ITMessage;
import mctmods.immersivetechnology.common.network.ITOSDSyncMessage;
import mctmods.immersivetechnology.common.network.ITPacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record ITOSDRequestMessage(BlockPos pos) implements ITMessage
{
    public ITOSDRequestMessage(FriendlyByteBuf buf) {
        this(buf.m_130135_());
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player;
            if (ctx.getDirection() == NetworkDirection.PLAY_TO_SERVER && (player = ctx.getSender()) != null) {
                Level level = player.m_9236_();
                BlockEntity te = level.m_7702_(this.pos);
                if (te instanceof OSDCommonBlockEntity) {
                    OSDCommonBlockEntity trash = (OSDCommonBlockEntity)te;
                    ITPacketHandler.sendToPlayer((Player)player, new ITOSDSyncMessage(this.pos, trash.lastAcceptedAmount, 0L, 0));
                }
                if (te instanceof ValveCommonBlockEntity) {
                    ValveCommonBlockEntity valve = (ValveCommonBlockEntity)te;
                    ITPacketHandler.sendToPlayer((Player)player, new ITOSDSyncMessage(this.pos, valve.lastAcceptedAmount, valve.average, valve.packetAverage));
                }
            }
        });
    }
}

