/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.shapes;

import java.util.List;
import java.util.function.Function;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.FullblockShape;
import mctmods.immersivetechnology.common.util.multiblock.GenericShape;
import mctmods.immersivetechnology.common.util.multiblock.MultiblockData;
import mctmods.immersivetechnology.common.util.multiblock.MultiblockDataLoader;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.core.lib.ITLib;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SteamTurbineShape {
    public static final MultiblockData DATA = MultiblockDataLoader.loadMultiblockData("steam_turbine");
    public static final Function<BlockPos, VoxelShape> GETTER;
    public static int WIDTH;
    public static int HEIGHT;
    public static int LENGTH;
    public static BlockPos MASTER_POS;
    public static BlockPos TRIGGER_POS;
    public static BlockPos CLIENT_OFFSET;
    public static BlockPos DISASSEMBLY_POS;
    public static float MANUAL_SCALE;

    static {
        int[] dims = GenericShape.loadDimensions("steam_turbine", "metal");
        WIDTH = dims[0] + SteamTurbineShape.DATA.padShape[0];
        HEIGHT = dims[1] + SteamTurbineShape.DATA.padShape[1];
        LENGTH = dims[2] + SteamTurbineShape.DATA.padShape[2];
        ITLib.IT_LOGGER.info("Loaded dimensions for steam_turbine: W={}, H={}, L={}", new Object[]{WIDTH, HEIGHT, LENGTH});
        if (WIDTH <= 0 || HEIGHT <= 0 || LENGTH <= 0) {
            GETTER = FullblockShape.GETTER;
            LENGTH = 0;
            HEIGHT = 0;
            WIDTH = 0;
            if (SteamTurbineShape.DATA.shapeAABB == null || !SteamTurbineShape.DATA.shapeAABB.isEmpty()) {
                ITLib.IT_LOGGER.error("Invalid dimensions loaded for steam_turbine multiblock.");
            }
        } else {
            int num = WIDTH * HEIGHT * LENGTH;
            if (SteamTurbineShape.DATA.shapeAABB == null) {
                ITLib.IT_LOGGER.error("Failed to load shapes for steam_turbine multiblock. (shapeAABB null)");
                GETTER = FullblockShape.GETTER;
            } else if (SteamTurbineShape.DATA.shapeAABB.isEmpty()) {
                ITLib.IT_LOGGER.info("Using full block shape for steam_turbine.");
                GETTER = FullblockShape.GETTER;
            } else {
                List<List<AABB>> shapes = GenericShape.loadShapes(DATA, num);
                if (shapes == null) {
                    ITLib.IT_LOGGER.error("Failed to load shapes for steam_turbine multiblock.");
                    GETTER = FullblockShape.GETTER;
                } else {
                    boolean allFull = !shapes.isEmpty() && shapes.stream().allMatch(list -> list.size() == 1 && ((AABB)list.get(0)).equals((Object)GenericShape.FULL_BLOCK));
                    GETTER = allFull ? FullblockShape.GETTER : new GenericShape.JsonShape(WIDTH, HEIGHT, LENGTH, shapes);
                }
            }
        }
        MANUAL_SCALE = SteamTurbineShape.DATA.manualScale;
        if (SteamTurbineShape.DATA.pointsOfInterest != null) {
            block12: for (PoIJSONSchema poi : SteamTurbineShape.DATA.pointsOfInterest) {
                switch (poi.name) {
                    case "master": {
                        MASTER_POS = new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2]);
                        continue block12;
                    }
                    case "trigger": {
                        TRIGGER_POS = new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2]);
                        continue block12;
                    }
                    case "client_offset": {
                        CLIENT_OFFSET = new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2]);
                        continue block12;
                    }
                    case "disassembly_ticker": {
                        DISASSEMBLY_POS = new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2]);
                    }
                }
            }
        }
    }
}

