/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.recipe.serializer;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.BoilerLiquidRecipe;
import mctmods.immersivetechnology.core.registration.ITMultiblockProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoilerLiquidRecipeSerializer
extends IERecipeSerializer<BoilerLiquidRecipe> {
    public ItemStack getIcon() {
        return ITMultiblockProvider.BOILER_LIQUID.iconStack();
    }

    public BoilerLiquidRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        FluidTagInput input = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        double heatPerTick = GsonHelper.m_144784_((JsonObject)json, (String)"heatPerTick");
        double targetHeat = GsonHelper.m_144742_((JsonObject)json, (String)"targetHeat", (double)100.0);
        return new BoilerLiquidRecipe(recipeId, input, time, heatPerTick, targetHeat);
    }

    @Nullable
    public BoilerLiquidRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        FluidTagInput input = FluidTagInput.read((FriendlyByteBuf)buffer);
        int time = buffer.readInt();
        double heatPerTick = buffer.readDouble();
        double targetHeat = buffer.readDouble();
        return new BoilerLiquidRecipe(recipeId, input, time, heatPerTick, targetHeat);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, BoilerLiquidRecipe recipe) {
        recipe.input.write(buffer);
        buffer.writeInt(recipe.getTotalProcessTime());
        buffer.writeDouble(recipe.getHeatPerTick());
        buffer.writeDouble(recipe.getTargetHeat());
    }
}

