/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.recipe;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.core.registration.ITRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class DistillerRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<DistillerRecipe>> SERIALIZER;
    public static final CachedRecipeList<DistillerRecipe> RECIPES;
    public final FluidTagInput input;
    @Nullable
    public final FluidStack fluidOutput;
    public final ItemStack itemOutput;
    public final float chance;
    private final int time;
    private final int energy;
    Lazy<Integer> totalProcessTime;
    Lazy<Integer> totalProcessEnergy;

    public DistillerRecipe(ResourceLocation id, FluidTagInput input, @Nullable FluidStack fluidOutput, ItemStack itemOutput, float chance, int time, int energy) {
        super(Lazy.of(() -> ItemStack.f_41583_), ITRecipeTypes.DISTILLER, id);
        this.input = input;
        this.fluidOutput = fluidOutput;
        this.itemOutput = itemOutput;
        this.chance = chance;
        this.time = time;
        this.energy = energy;
        this.totalProcessTime = Lazy.of(() -> this.time);
        this.totalProcessEnergy = Lazy.of(() -> this.energy);
        this.fluidInputList = Lists.newArrayList((Object[])new FluidTagInput[]{this.input});
        if (this.fluidOutput != null) {
            this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
        }
        this.outputList = Lazy.of(NonNullList::m_122779_);
    }

    public static DistillerRecipe findRecipe(Level level, FluidStack inputFluid) {
        for (DistillerRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.input.test(inputFluid)) continue;
            return recipe;
        }
        return null;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    public int getTotalProcessEnergy() {
        return (Integer)this.totalProcessEnergy.get();
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        RECIPES = new CachedRecipeList(ITRecipeTypes.DISTILLER);
    }
}

