/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.recipe;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.Lists;
import mctmods.immersivetechnology.core.registration.ITRecipeTypes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BoilerSolidRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<BoilerSolidRecipe>> SERIALIZER;
    public static final CachedRecipeList<BoilerSolidRecipe> RECIPES;
    public IngredientWithSize input;
    private final double heatPerTick;
    private final double targetHeat;

    public BoilerSolidRecipe(ResourceLocation id, IngredientWithSize input, double heatPerTick, double targetHeat) {
        super(Lazy.of(() -> ItemStack.f_41583_), ITRecipeTypes.BOILER_SOLID, id);
        this.input = input;
        this.heatPerTick = heatPerTick;
        this.targetHeat = Math.min(targetHeat, 2000.0);
        this.setInputListWithSizes(Lists.newArrayList((Object[])new IngredientWithSize[]{this.input}));
    }

    public static BoilerSolidRecipe findRecipe(Level level, ItemStack input) {
        for (BoilerSolidRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.input.testIgnoringSize(input)) continue;
            return recipe;
        }
        return null;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public int getTotalProcessTime() {
        return 0;
    }

    public int getTotalProcessEnergy() {
        return 0;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public double getHeatPerTick() {
        return this.heatPerTick;
    }

    public double getTargetHeat() {
        return this.targetHeat;
    }

    static {
        RECIPES = new CachedRecipeList(ITRecipeTypes.BOILER_SOLID);
    }
}

