/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.process;

public class RotationInertiaProcess {
    private final int speedUpRate;
    private final int speedDownRate;
    private final double inertia;
    private final double torque;
    private final double fixedFriction;
    private final double drag;

    public RotationInertiaProcess(double mass, double torque, double friction, int maxRpm) {
        this.inertia = mass;
        this.torque = torque;
        this.fixedFriction = friction;
        this.drag = Math.max(0.0, torque - this.fixedFriction) / (double)maxRpm;
        this.speedUpRate = (int)Math.round(torque / this.inertia);
        this.speedDownRate = (int)Math.round((this.fixedFriction + this.drag * (double)maxRpm) / this.inertia);
    }

    public int getSpeedUpRate() {
        return this.speedUpRate;
    }

    public int getSpeedDownRate() {
        return this.speedDownRate;
    }

    public double getAlpha(float ratio, int currentSpeed) {
        double opposing = this.fixedFriction + this.drag * (double)currentSpeed;
        double netTorque = this.torque * (double)ratio - opposing;
        return netTorque / this.inertia;
    }

    public int getDelta(float ratio, int currentSpeed) {
        double alpha = this.getAlpha(ratio, currentSpeed);
        return (int)Math.round(alpha);
    }
}

