/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.logic;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.InitialMultiblockContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mctmods.immersivetechnology.common.fluids.helper.ITArrayFluidHandler;
import mctmods.immersivetechnology.common.fluids.helper.ITMarkableFluidTank;
import mctmods.immersivetechnology.common.fluids.helper.ITSolarTank;
import mctmods.immersivetechnology.common.multiblocks.helper.ITDisplayContext;
import mctmods.immersivetechnology.common.multiblocks.helper.ITMultiBlockInventoryUtils;
import mctmods.immersivetechnology.common.multiblocks.helper.ITPressurizedFluidOutput;
import mctmods.immersivetechnology.common.multiblocks.helper.ITSlotwiseItemHandler;
import mctmods.immersivetechnology.common.multiblocks.metal.interfaces.ITISolarMultiblockState;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SolarReflectorLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.SolarTowerRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.SolarTowerShape;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.common.util.solarregistry.SolarRegistry;
import mctmods.immersivetechnology.core.lib.ITSound;
import mctmods.immersivetechnology.core.registration.ITSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SolarTowerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State>,
ITPressurizedFluidOutput<State> {
    public static final int SLOT_INPUT_FILLED = 0;
    public static final int SLOT_INPUT_EMPTY = 1;
    public static final int SLOT_OUTPUT_EMPTY = 2;
    public static final int SLOT_OUTPUT_FILLED = 3;
    public static final double WORKING_HEAT_LEVEL = 400.0;
    private static final double DAY_MIN_HEAT_LOSS = 0.0;
    private static final double LOSS_PER_SECTION_DROP = 0.035;
    private static final double TEMP_DEPENDENT_LOSS_FACTOR = 6.0E-4;
    private static final double HEAT_INCREASE_FACTOR = 0.003;
    private static final double TEMP_TO_MIN_REFLECTORS_DIVISOR = 25.0;
    private static final double REFLECTOR_TIER_OFFSET = 4.0;
    public static final int PROGRESS_LOSS_OFF_TEMP = 2;
    public static final float SPEED_MULTIPLIER = 1.0f;
    private static final List<PoIJSONSchema> RAW_POIS = ImmutableList.copyOf((Object[])SolarTowerShape.DATA.pointsOfInterest);
    public static final BlockPos REDSTONE_POI = SolarTowerLogic.getPosList("redstone").get(0);
    public static final BlockPos RUNNING_SOUND_POI = SolarTowerLogic.getPosList("sound").get(0);
    public static final BlockPos LINK_POI = SolarTowerLogic.getPosList("link").get(0);
    public static final BlockPos REFLECTOR_POI = SolarTowerLogic.getPosList("reflector").get(0);
    public static final BlockPos SUN_POI = SolarTowerLogic.getPosList("sun").get(0);
    public static final CapabilityPosition INPUT_FLUID_POI = new CapabilityPosition(SolarTowerLogic.getPosList("fluid_input").get(0), SolarTowerLogic.getFacing("fluid_input"));
    public static final CapabilityPosition OUTPUT_FLUID_POI = new CapabilityPosition(SolarTowerLogic.getPosList("fluid_output").get(0), SolarTowerLogic.getFacing("fluid_output"));
    public static final List<BlockPos> FLUID_OUTPUT_POIS = SolarTowerLogic.getPosList("fluid_output");
    private static final RelativeBlockFace OUTPUT_FACING = SolarTowerLogic.getFacing("fluid_output");

    private static List<BlockPos> getPosList(String name) {
        return (List)RAW_POIS.stream().filter(poi -> poi.name.equals(name)).map(poi -> new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2])).collect(ImmutableList.toImmutableList());
    }

    private static RelativeBlockFace getFacing(String name) {
        List facings = RAW_POIS.stream().filter(poi -> poi.name.equals(name)).flatMap(poi -> poi.relativeFaces.stream()).distinct().toList();
        if (facings.size() != 1) {
            throw new RuntimeException("Inconsistent facings for POI: " + name);
        }
        return (RelativeBlockFace)facings.get(0);
    }

    @Override
    public List<BlockPos> getOutputPositions() {
        return FLUID_OUTPUT_POIS;
    }

    @Override
    public Direction getOutputDirection(IMultiblockContext<State> ctx) {
        return ctx.getLevel().toAbsolute(OUTPUT_FACING);
    }

    @Override
    public List<ITMarkableFluidTank> getOutputTanks(State state) {
        return ImmutableList.of((Object)((Object)state.tanks.output()));
    }

    @Override
    public List<CapabilityReference<IFluidHandler>> getFluidOutputs(State state) {
        return ImmutableList.of(state.fluidOutput);
    }

    public void tickClient(IMultiblockContext<State> ctx) {
        State state = (State)ctx.getState();
        if (!state.isSoundPlaying.getAsBoolean()) {
            double distSq;
            float att;
            float heatFactor;
            float vol;
            LocalPlayer player;
            boolean shouldPlay;
            Vec3 soundVec = ctx.getLevel().toAbsolute(new Vec3((double)RUNNING_SOUND_POI.m_123341_() + 0.5, (double)RUNNING_SOUND_POI.m_123342_() + 0.5, (double)RUNNING_SOUND_POI.m_123343_() + 0.5));
            FluidStack fs = state.tanks.input().getFluid();
            SolarTowerRecipe recipe = fs.getAmount() > 0 ? SolarTowerRecipe.findRecipe(ctx.getLevel().getRawLevel(), fs) : null;
            double maxHeat = recipe != null ? recipe.requiredTemp : 400.0;
            boolean bl = shouldPlay = state.heatLevel >= maxHeat && state.sunVisible && state.reflectorStrength > 0.0;
            if (shouldPlay && (player = Minecraft.m_91087_().f_91074_) != null && (vol = 2.0f * (heatFactor = (float)(state.heatLevel / maxHeat)) / (att = (float)Math.max((distSq = player.m_20238_(soundVec)) / 32.0, 1.0))) > 0.01f) {
                ++state.soundId;
                int thisId = state.soundId;
                state.isSoundPlaying = ITSound.startSound(() -> {
                    FluidStack fsActive = state.tanks.input().getFluid();
                    SolarTowerRecipe recipeActive = fsActive.getAmount() > 0 ? SolarTowerRecipe.findRecipe(ctx.getLevel().getRawLevel(), fsActive) : null;
                    double maxHeatActive = recipeActive != null ? recipeActive.requiredTemp : 400.0;
                    return state.heatLevel >= maxHeatActive && state.sunVisible && state.reflectorStrength > 0.0 && state.soundId == thisId;
                }, ctx.isValid(), soundVec, ITSounds.solarTower, () -> {
                    LocalPlayer playerVol = Minecraft.m_91087_().f_91074_;
                    if (playerVol == null) {
                        return Float.valueOf(0.0f);
                    }
                    float a = (float)Math.max(playerVol.m_20238_(soundVec) / 32.0, 1.0);
                    FluidStack fsVol = state.tanks.input().getFluid();
                    SolarTowerRecipe recipeVol = fsVol.getAmount() > 0 ? SolarTowerRecipe.findRecipe(ctx.getLevel().getRawLevel(), fsVol) : null;
                    double maxHeatVol = recipeVol != null ? recipeVol.requiredTemp : 400.0;
                    float heatFactorVol = (float)(state.heatLevel / maxHeatVol);
                    return Float.valueOf(2.0f * heatFactorVol / a);
                }, () -> Float.valueOf(1.0f));
            }
        }
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        FluidActionResult res;
        ItemStack outputEmpty;
        FluidActionResult res2;
        ItemStack inputFilled;
        State state = (State)ctx.getState();
        IMultiblockLevel mlevel = ctx.getLevel();
        Level level = mlevel.getRawLevel();
        boolean update = false;
        ++state.loadTicks;
        if (state.loadTicks > 10 && !state.isLoaded && !level.f_46443_) {
            state.isLoaded = true;
            this.updatePortNeighbors(mlevel);
            SolarRegistry.RegisterResult result = SolarRegistry.registerTower(level, state.basePos);
            state.registered = result.success;
            state.failVertical = result.vertical;
            state.requiredMove = result.requiredMove;
            if (!state.registered && state.savedRegistered) {
                int y = state.basePos.m_123342_();
                Set towersAtY = SolarRegistry.getData((Level)level).towerBasesByY.computeIfAbsent(y, k -> new HashSet());
                towersAtY.add(state.basePos);
                SolarRegistry.getData(level).m_77762_();
                state.registered = true;
                state.failVertical = false;
                state.requiredMove = 0;
            }
            if (state.registered) {
                state.reflectorStrength = this.checkReflectorPositions(mlevel, state);
            }
            update = true;
        }
        if (state.loadTicks > 20 && state.reCheckOnLoad && !level.f_46443_) {
            state.reCheckOnLoad = false;
            if (state.registered) {
                state.reflectorStrength = this.checkReflectorPositions(mlevel, state);
            }
            update = true;
        }
        if (!state.registered) {
            return;
        }
        boolean oldVisible = state.sunVisible;
        state.sunVisible = level.m_45527_(state.sunPos);
        if (oldVisible != state.sunVisible) {
            update = true;
        }
        long time = level.m_46467_();
        boolean enabled = state.rsState.isEnabled(ctx);
        if (!enabled && state.reflectorStrength > 0.0) {
            this.detachReflectorPositions(state);
            state.reflectorStrength = 0.0;
            update = true;
        }
        if (enabled && (time % 60L == 0L || state.reflectorStrength == 0.0)) {
            state.reflectorStrength = this.checkReflectorPositions(mlevel, state);
        }
        boolean wasActive = state.active;
        update |= this.heatLogic(state, level, enabled);
        update |= this.recipeLogic(state, level, enabled);
        boolean bl = state.active = enabled && state.activeRecipe != null && state.heatLevel >= state.activeRecipe.requiredTemp;
        if (wasActive != state.active) {
            update = true;
        }
        if (!(inputFilled = state.inventory.getStackInSlot(0)).m_41619_() && (res2 = FluidUtil.tryEmptyContainer((ItemStack)inputFilled, (IFluidHandler)state.tanks.input(), (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess()) {
            ItemStack resultItem = res2.getResult();
            ItemStack inputEmpty = state.inventory.getStackInSlot(1);
            if ((inputEmpty.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)resultItem, (ItemStack)inputEmpty) && inputEmpty.m_41613_() + resultItem.m_41613_() <= inputEmpty.m_41741_()) && (res2 = FluidUtil.tryEmptyContainer((ItemStack)inputFilled, (IFluidHandler)state.tanks.input(), (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
                resultItem = res2.getResult();
                inputFilled.m_41774_(1);
                if (inputFilled.m_41619_()) {
                    state.inventory.setStackInSlot(0, ItemStack.f_41583_);
                }
                if (inputEmpty.m_41619_()) {
                    state.inventory.setStackInSlot(1, resultItem);
                } else {
                    inputEmpty.m_41769_(resultItem.m_41613_());
                }
                update = true;
            }
        }
        if (!(outputEmpty = state.inventory.getStackInSlot(2)).m_41619_() && (res = FluidUtil.tryFillContainer((ItemStack)outputEmpty, (IFluidHandler)state.tanks.output(), (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess()) {
            ItemStack resultItem = res.getResult();
            ItemStack outputFilled = state.inventory.getStackInSlot(3);
            if ((outputFilled.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)resultItem, (ItemStack)outputFilled) && outputFilled.m_41613_() + resultItem.m_41613_() <= outputFilled.m_41741_()) && (res = FluidUtil.tryFillContainer((ItemStack)outputEmpty, (IFluidHandler)state.tanks.output(), (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
                resultItem = res.getResult();
                outputEmpty.m_41774_(1);
                if (outputEmpty.m_41619_()) {
                    state.inventory.setStackInSlot(2, ItemStack.f_41583_);
                }
                if (outputFilled.m_41619_()) {
                    state.inventory.setStackInSlot(3, resultItem);
                } else {
                    outputFilled.m_41769_(resultItem.m_41613_());
                }
                update = true;
            }
        }
        this.pumpOutputs(ctx);
        if (update) {
            ctx.markMasterDirty();
            ctx.requestMasterBESync();
        }
    }

    private void updatePortNeighbors(IMultiblockLevel mlevel) {
        Level level = mlevel.getRawLevel();
        BlockPos inputPos = mlevel.toAbsolute(INPUT_FLUID_POI.posInMultiblock());
        level.m_46672_(inputPos, level.m_8055_(inputPos).m_60734_());
        BlockPos outputPos = mlevel.toAbsolute(OUTPUT_FLUID_POI.posInMultiblock());
        level.m_46672_(outputPos, level.m_8055_(outputPos).m_60734_());
    }

    private double checkReflectorPositions(IMultiblockLevel mlevel, State state) {
        SolarReflectorLogic.State reflectorState;
        IMultiblockBE mbe;
        IMultiblockBEHelper helper;
        BlockEntity be;
        double totalMirrorStrength = 0.0;
        int count = 0;
        byte[] dirCountsTemp = new byte[4];
        Level level = mlevel.getRawLevel();
        BlockPos basePos = mlevel.toAbsolute(LINK_POI);
        BlockPos collectorPos = mlevel.toAbsolute(REFLECTOR_POI);
        Set<BlockPos> reflectors = SolarRegistry.getReflectorsInRange(level, basePos, 12.0, 22.0);
        HashSet<BlockPos> unattached = new HashSet<BlockPos>();
        for (BlockPos poiPos : reflectors) {
            IMultiblockState iMultiblockState;
            be = level.m_7702_(poiPos);
            if (!(be instanceof IMultiblockBE) || (helper = (mbe = (IMultiblockBE)be).getHelper()) == null || !((iMultiblockState = helper.getState()) instanceof SolarReflectorLogic.State)) continue;
            reflectorState = (SolarReflectorLogic.State)iMultiblockState;
            BlockPos currentTower = reflectorState.getTowerCollectorPosition();
            if (currentTower.equals((Object)collectorPos)) {
                int dir;
                if (!reflectorState.setTowerCollectorPosition(collectorPos)) continue;
                totalMirrorStrength += reflectorState.getSolarCollectorStrength();
                int n = dir = this.getReflectorDir(poiPos.m_123341_() - basePos.m_123341_(), poiPos.m_123343_() - basePos.m_123343_());
                dirCountsTemp[n] = (byte)(dirCountsTemp[n] + 1);
                ++count;
                continue;
            }
            unattached.add(poiPos);
        }
        for (BlockPos poiPos : unattached) {
            int dir;
            IMultiblockState currentTower;
            if (count >= 24) break;
            be = level.m_7702_(poiPos);
            if (!(be instanceof IMultiblockBE) || (helper = (mbe = (IMultiblockBE)be).getHelper()) == null || !((currentTower = helper.getState()) instanceof SolarReflectorLogic.State)) continue;
            reflectorState = (SolarReflectorLogic.State)currentTower;
            if (reflectorState.isMirrorTaken || !reflectorState.setTowerCollectorPosition(collectorPos)) continue;
            totalMirrorStrength += reflectorState.getSolarCollectorStrength();
            int n = dir = this.getReflectorDir(poiPos.m_123341_() - basePos.m_123341_(), poiPos.m_123343_() - basePos.m_123343_());
            dirCountsTemp[n] = (byte)(dirCountsTemp[n] + 1);
            ++count;
        }
        state.dirCounts = dirCountsTemp;
        state.reflectorCount = (byte)count;
        return totalMirrorStrength;
    }

    private int getReflectorDir(int dx, int dz) {
        if (Math.abs(dx) > Math.abs(dz)) {
            if (dx > 0) {
                return 1;
            }
            return 3;
        }
        if (dz > 0) {
            return 2;
        }
        return 0;
    }

    private boolean heatLogic(State state, Level level, boolean enabled) {
        double inc = enabled ? this.getTemperatureIncrease(state, level) : 0.0;
        double loss = this.getTemperatureLoss(state, level);
        double oldHeat = state.heatLevel;
        state.heatLevel = Math.max(0.0, state.heatLevel + inc - loss);
        double maxHeat = state.activeRecipe != null ? state.activeRecipe.requiredTemp : 400.0;
        state.heatLevel = Math.min(maxHeat, state.heatLevel);
        return oldHeat != state.heatLevel;
    }

    private double getTemperatureIncrease(State state, Level level) {
        double inc = 0.0;
        if (state.registered && state.reflectorStrength > 0.0 && level.m_46461_() && !level.m_46471_() && state.sunVisible) {
            double effectiveStrength = state.reflectorStrength;
            if (state.activeRecipe != null) {
                double minReflectors = state.activeRecipe.requiredTemp / 25.0;
                double bestReflectors = minReflectors + 8.0;
                effectiveStrength = Math.min(state.reflectorStrength, bestReflectors);
            }
            inc = effectiveStrength * 0.003 * (double)SolarTowerLogic.getSolarIncidenceAngleSection(level);
        }
        return inc;
    }

    private double getTemperatureLoss(State state, Level level) {
        double loss = 0.0;
        int section = SolarTowerLogic.getSolarIncidenceAngleSection(level);
        loss += 0.035 * (double)(4 - section);
        return loss += state.heatLevel * 6.0E-4;
    }

    private boolean recipeLogic(State state, Level level, boolean enabled) {
        FluidStack fs = state.tanks.input().getFluid();
        if (fs.getAmount() <= 0) {
            state.activeRecipe = null;
            state.processProgress = 0;
            return false;
        }
        if (state.activeRecipe == null && state.activeRecipeId != null) {
            state.activeRecipe = (SolarTowerRecipe)SolarTowerRecipe.RECIPES.getById(level, state.activeRecipeId);
            state.activeRecipeId = null;
        }
        if (state.activeRecipe == null || !state.activeRecipe.input.testIgnoringAmount(fs)) {
            state.activeRecipe = SolarTowerRecipe.findRecipe(level, fs);
            state.processProgress = 0;
            if (state.activeRecipe == null) {
                return false;
            }
        }
        if (state.activeRecipe == null) {
            state.processProgress = 0;
            return false;
        }
        state.processProgress = enabled && state.heatLevel >= state.activeRecipe.requiredTemp ? ++state.processProgress : Math.max(0, state.processProgress - 2);
        if (state.processProgress >= state.activeRecipe.getTotalProcessTime()) {
            FluidStack drained;
            assert (state.activeRecipe.fluidOutput != null);
            FluidStack out = state.activeRecipe.fluidOutput.copy();
            if (state.tanks.output().fill(out, IFluidHandler.FluidAction.SIMULATE) == out.getAmount() && (drained = state.tanks.input().drain(state.activeRecipe.input.getAmount(), IFluidHandler.FluidAction.EXECUTE)).getAmount() == state.activeRecipe.input.getAmount() && state.activeRecipe.input.testIgnoringAmount(drained)) {
                state.tanks.output().fill(out, IFluidHandler.FluidAction.EXECUTE);
                state.processProgress = 0;
                return true;
            }
        }
        return false;
    }

    private void detachReflectorPositions(State state) {
        Level level = state.levelSupplier.get();
        if (level == null || level.f_46443_) {
            return;
        }
        BlockPos collectorPos = state.collectorPos;
        Set<BlockPos> reflectors = SolarRegistry.getReflectorsInRange(level, state.basePos, 12.0, 22.0);
        for (BlockPos poiPos : reflectors) {
            IMultiblockState iMultiblockState;
            IMultiblockBE mbe;
            IMultiblockBEHelper helper;
            BlockEntity be = level.m_7702_(poiPos);
            if (!(be instanceof IMultiblockBE) || (helper = (mbe = (IMultiblockBE)be).getHelper()) == null || !((iMultiblockState = helper.getState()) instanceof SolarReflectorLogic.State)) continue;
            SolarReflectorLogic.State reflectorState = (SolarReflectorLogic.State)iMultiblockState;
            reflectorState.detachTower(collectorPos);
        }
    }

    public static int getSolarIncidenceAngleSection(Level level) {
        int skyDarken = level.m_7445_();
        if (skyDarken == 3) {
            return 1;
        }
        if (skyDarken == 2) {
            return 2;
        }
        if (skyDarken == 1) {
            return 3;
        }
        if (skyDarken == 0) {
            return 4;
        }
        return 0;
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (position.equals((Object)INPUT_FLUID_POI)) {
                return state.inputCap.cast();
            }
            if (position.equals((Object)OUTPUT_FLUID_POI)) {
                return state.outputCap.cast();
            }
        }
        return LazyOptional.empty();
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return SolarTowerShape.GETTER;
    }

    public State createInitialState(IInitialMultiblockContext<State> ctx) {
        return new State(ctx);
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        Level level = state.levelSupplier.get();
        if (level != null && !level.f_46443_) {
            this.detachReflectorPositions(state);
            SolarRegistry.unregisterTower(level, state.basePos);
        }
        ITMultiBlockInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
        state.inputCap.invalidate();
        state.outputCap.invalidate();
    }

    public static class State
    implements ITISolarMultiblockState,
    ITDisplayContext {
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final ITSolarTank tanks;
        public final LazyOptional<IFluidHandler> inputCap;
        public final LazyOptional<IFluidHandler> outputCap;
        public final CapabilityReference<IFluidHandler> fluidOutput;
        public final ITSlotwiseItemHandler inventory;
        public double heatLevel = 0.0;
        public double reflectorStrength = 0.0;
        public byte reflectorCount = 0;
        public final BlockPos basePos;
        public final BlockPos collectorPos;
        public final BlockPos sunPos;
        public final Supplier<Level> levelSupplier;
        public byte[] dirCounts = new byte[4];
        public int processProgress = 0;
        public SolarTowerRecipe activeRecipe = null;
        private ResourceLocation activeRecipeId;
        public boolean isLoaded = false;
        public boolean registered;
        public boolean failVertical = false;
        public int requiredMove = 0;
        public boolean active;
        public BooleanSupplier isSoundPlaying = () -> false;
        private int soundId = 0;
        public boolean sunVisible = true;
        private int loadTicks = 0;
        private boolean reCheckOnLoad = false;
        private transient boolean savedRegistered = false;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            Runnable onChanged = () -> {
                markDirty.run();
                sync.run();
            };
            this.tanks = new ITSolarTank(v -> onChanged.run());
            this.inventory = new ITSlotwiseItemHandler(Lists.newArrayList((Object[])new ITSlotwiseItemHandler.IOConstraint[]{ITSlotwiseItemHandler.IOConstraint.FLUID_INPUT, ITSlotwiseItemHandler.IOConstraint.OUTPUT, ITSlotwiseItemHandler.IOConstraint.FLUID_INPUT, ITSlotwiseItemHandler.IOConstraint.OUTPUT}), onChanged);
            this.inputCap = LazyOptional.of(() -> new ITArrayFluidHandler((IFluidTank)this.tanks.input(), false, true, onChanged));
            this.outputCap = LazyOptional.of(() -> new ITArrayFluidHandler((IFluidTank)this.tanks.output(), true, false, onChanged));
            MultiblockFace outputMBFace = new MultiblockFace(OUTPUT_FACING, FLUID_OUTPUT_POIS.get(0));
            CapabilityPosition oppCp = CapabilityPosition.opposing((MultiblockFace)outputMBFace);
            MultiblockFace oppMbf = new MultiblockFace(oppCp.side(), oppCp.posInMultiblock());
            this.fluidOutput = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, oppMbf);
            InitialMultiblockContext initialContext = (InitialMultiblockContext)ctx;
            MultiblockOrientation orientation = initialContext.orientation();
            BlockPos masterOffset = initialContext.masterOffset();
            BlockPos masterPos = initialContext.masterBE().m_58899_();
            BlockPos origin = masterPos.m_121996_((Vec3i)orientation.getAbsoluteOffset(masterOffset));
            this.basePos = origin.m_121955_((Vec3i)orientation.getAbsoluteOffset(LINK_POI));
            this.collectorPos = origin.m_121955_((Vec3i)orientation.getAbsoluteOffset(REFLECTOR_POI));
            this.sunPos = origin.m_121955_((Vec3i)orientation.getAbsoluteOffset(SUN_POI));
            this.levelSupplier = ctx.levelSupplier();
            Level level = this.levelSupplier.get();
            SolarRegistry.RegisterResult result = level != null && !level.f_46443_ ? SolarRegistry.registerTower(level, this.basePos) : new SolarRegistry.RegisterResult();
            this.registered = result.success;
            if (!this.registered) {
                this.failVertical = result.vertical;
                this.requiredMove = result.requiredMove;
            }
        }

        @Override
        public double getHeatLevel() {
            return this.heatLevel;
        }

        @Override
        public byte[] getDirCounts() {
            return this.dirCounts;
        }

        @Override
        public int getProcessProgress() {
            return this.processProgress;
        }

        @Override
        public boolean isSunVisible() {
            return this.sunVisible;
        }

        @Override
        public ITSolarTank getTanks() {
            return this.tanks;
        }

        @Override
        public ITSlotwiseItemHandler getInventory() {
            return this.inventory;
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("tanks", this.tanks.toNBT());
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128347_("heatLevel", this.heatLevel);
            nbt.m_128347_("reflectorStrength", this.reflectorStrength);
            nbt.m_128344_("reflectorCount", this.reflectorCount);
            nbt.m_128382_("dirCounts", this.dirCounts);
            nbt.m_128405_("processProgress", this.processProgress);
            if (this.activeRecipe != null) {
                nbt.m_128359_("activeRecipe", this.activeRecipe.m_6423_().toString());
            }
            nbt.m_128379_("registered", this.registered);
            nbt.m_128379_("failVertical", this.failVertical);
            nbt.m_128405_("requiredMove", this.requiredMove);
            nbt.m_128379_("active", this.active);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.heatLevel = nbt.m_128459_("heatLevel");
            this.reflectorStrength = nbt.m_128459_("reflectorStrength");
            this.reflectorCount = nbt.m_128445_("reflectorCount");
            this.dirCounts = nbt.m_128463_("dirCounts");
            this.processProgress = nbt.m_128451_("processProgress");
            if (nbt.m_128441_("activeRecipe")) {
                this.activeRecipeId = ResourceLocation.m_135820_((String)nbt.m_128461_("activeRecipe"));
            }
            this.registered = nbt.m_128471_("registered");
            this.failVertical = nbt.m_128471_("failVertical");
            this.requiredMove = nbt.m_128451_("requiredMove");
            this.active = nbt.m_128471_("active");
            this.savedRegistered = nbt.m_128471_("registered");
            this.reCheckOnLoad = nbt.m_128471_("registered");
            this.isLoaded = false;
            Level level = this.levelSupplier.get();
            if (level != null && !level.f_46443_) {
                SolarRegistry.RegisterResult result = SolarRegistry.registerTower(level, this.basePos);
                this.registered = result.success;
                this.failVertical = result.vertical;
                this.requiredMove = result.requiredMove;
                if (!this.registered && this.savedRegistered) {
                    int y = this.basePos.m_123342_();
                    Set towersAtY = SolarRegistry.getData((Level)level).towerBasesByY.computeIfAbsent(y, k -> new HashSet());
                    towersAtY.add(this.basePos);
                    SolarRegistry.getData(level).m_77762_();
                    this.registered = true;
                    this.failVertical = false;
                    this.requiredMove = 0;
                }
            }
        }

        public void writeSyncNBT(CompoundTag nbt) {
            CompoundTag display = new CompoundTag();
            this.writeDisplaySyncNBT(display);
            nbt.m_128365_("display", (Tag)display);
        }

        public void readSyncNBT(CompoundTag nbt) {
            if (nbt.m_128425_("display", 10)) {
                this.readDisplaySyncNBT(nbt.m_128469_("display"));
            }
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return new IFluidTank[]{this.tanks.input(), this.tanks.output()};
        }

        @Override
        public void writeDisplaySyncNBT(CompoundTag nbt) {
            nbt.m_128365_("tanks", this.tanks.toNBT());
            nbt.m_128347_("heatLevel", this.heatLevel);
            nbt.m_128347_("reflectorStrength", this.reflectorStrength);
            nbt.m_128382_("dirCounts", this.dirCounts);
            nbt.m_128379_("sunVisible", this.sunVisible);
            nbt.m_128379_("active", this.active);
        }

        @Override
        public void readDisplaySyncNBT(CompoundTag nbt) {
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.heatLevel = nbt.m_128459_("heatLevel");
            this.reflectorStrength = nbt.m_128459_("reflectorStrength");
            this.dirCounts = nbt.m_128463_("dirCounts");
            this.sunVisible = nbt.m_128471_("sunVisible");
            this.active = nbt.m_128471_("active");
        }
    }
}

