/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.logic;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import mctmods.immersivetechnology.api.MechanicalCapabilities;
import mctmods.immersivetechnology.api.capability.IMechanicalEnergyConsumer;
import mctmods.immersivetechnology.api.capability.IMechanicalEnergyProvider;
import mctmods.immersivetechnology.client.particles.ColoredSmoke;
import mctmods.immersivetechnology.common.fluids.helper.ITArrayFluidHandler;
import mctmods.immersivetechnology.common.fluids.helper.ITMarkableFluidTank;
import mctmods.immersivetechnology.common.multiblocks.helper.ITDisplayContext;
import mctmods.immersivetechnology.common.multiblocks.helper.ITPressurizedFluidOutput;
import mctmods.immersivetechnology.common.multiblocks.metal.process.RotationInertiaProcess;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.GasTurbineRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.GasTurbineShape;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.core.lib.ITLib;
import mctmods.immersivetechnology.core.lib.ITSound;
import mctmods.immersivetechnology.core.registration.ITSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class GasTurbineLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State>,
ITPressurizedFluidOutput<State> {
    public static final int TANK_CAPACITY = 12000;
    public static final int ENERGY_CAPACITY = 8192;
    private static final int ENERGY_CAPACITY_MV = 2048;
    private static final int ELECTRIC_STARTER_CONSUMPTION = 4096;
    private static final int SPARKPLUG_CONSUMPTION = 1024;
    private static final double BASE_MASS = 8.0;
    private static final double DRIVE_TORQUE = 30.0;
    private static final double FRICTION = 60.0;
    private static final int MAX_SPEED = 3600;
    private static final List<PoIJSONSchema> RAW_POIS = ImmutableList.copyOf((Object[])GasTurbineShape.DATA.pointsOfInterest);
    public static final BlockPos REDSTONE_POI = GasTurbineLogic.getPosList("redstone").get(0);
    public static final BlockPos SMOKE_POI1 = GasTurbineLogic.getPosList("smoke1").get(0);
    public static final BlockPos SMOKE_POI2 = GasTurbineLogic.getPosList("smoke2").get(0);
    public static final BlockPos RUNNING_SOUND_POI = GasTurbineLogic.getPosList("sound_running").get(0);
    public static final BlockPos STARTER_SOUND_POI = GasTurbineLogic.getPosList("sound_starter").get(0);
    public static final BlockPos ARC_SOUND_POI = GasTurbineLogic.getPosList("sound_arc").get(0);
    public static final BlockPos SPARK_SOUND_POI = GasTurbineLogic.getPosList("sound_spark").get(0);
    public static final BlockPos IGNITE_SOUND_POI = GasTurbineLogic.getPosList("sound_ignite").get(0);
    public static final CapabilityPosition INPUT_FLUID_POI = new CapabilityPosition(GasTurbineLogic.getPosList("fluid_input").get(0), GasTurbineLogic.getFacing("fluid_input"));
    public static final CapabilityPosition OUTPUT_FLUID_POI = new CapabilityPosition(GasTurbineLogic.getPosList("fluid_output").get(0), GasTurbineLogic.getFacing("fluid_output"));
    public static final CapabilityPosition ENERGY_INPUT_HV_POI = new CapabilityPosition(GasTurbineLogic.getPosList("energy_input_hv").get(0), GasTurbineLogic.getFacing("energy_input_hv"));
    public static final CapabilityPosition ENERGY_INPUT_MV_POI = new CapabilityPosition(GasTurbineLogic.getPosList("energy_input_mv").get(0), GasTurbineLogic.getFacing("energy_input_mv"));
    public static final CapabilityPosition ROTATIONAL_OUTPUT_POI = new CapabilityPosition(GasTurbineLogic.getPosList("mech_output").get(0), GasTurbineLogic.getFacing("mech_output"));
    public static final List<BlockPos> FLUID_OUTPUT_POIS = GasTurbineLogic.getPosList("fluid_output");
    private static final RelativeBlockFace OUTPUT_FACING = GasTurbineLogic.getFacing("fluid_output");

    private static List<BlockPos> getPosList(String name) {
        return (List)RAW_POIS.stream().filter(poi -> poi.name.equals(name)).map(poi -> new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2])).collect(ImmutableList.toImmutableList());
    }

    private static RelativeBlockFace getFacing(String name) {
        List facings = RAW_POIS.stream().filter(poi -> poi.name.equals(name)).flatMap(poi -> poi.relativeFaces.stream()).distinct().toList();
        if (facings.size() != 1) {
            throw new RuntimeException("Inconsistent facings for POI: " + name);
        }
        return (RelativeBlockFace)facings.get(0);
    }

    @Override
    public List<BlockPos> getOutputPositions() {
        return FLUID_OUTPUT_POIS;
    }

    @Override
    public Direction getOutputDirection(IMultiblockContext<State> ctx) {
        return ctx.getLevel().toAbsolute(OUTPUT_FACING);
    }

    @Override
    public List<ITMarkableFluidTank> getOutputTanks(State state) {
        return ImmutableList.of((Object)((Object)state.tanks.output));
    }

    @Override
    public List<CapabilityReference<IFluidHandler>> getFluidOutputs(State state) {
        return ImmutableList.of(state.fluidOutput);
    }

    public void tickClient(IMultiblockContext<State> ctx) {
        float currentBase;
        State state = (State)ctx.getState();
        Level level = ctx.getLevel().getRawLevel();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        float targetLevel = ITLib.remapRange(0.0f, state.effectiveMaxSpeed, 0.2f, 1.0f, state.speed);
        state.currentLevel = state.currentLevel == 0.0f ? targetLevel : state.currentLevel * 0.9f + targetLevel * 0.1f;
        float smoothedLevel = state.currentLevel;
        float targetPitch = ITLib.remapRange(0.0f, state.effectiveMaxSpeed, 0.5f, 1.5f, state.speed);
        if (state.currentPitch == 0.0f) {
            state.currentPitch = targetPitch;
        }
        state.currentPitch = state.currentPitch < 0.5f ? 0.5f : state.currentPitch * 0.95f + targetPitch * 0.05f;
        float step = currentBase = (float)state.speed / (float)state.effectiveMaxSpeed * 72.0f;
        if (state.animation_fanFadeIn > 0) {
            step -= (float)state.animation_fanFadeIn / 80.0f * currentBase;
            --state.animation_fanFadeIn;
        }
        state.animation_fanRotationStep = step;
        state.animation_fanRotation += step;
        state.animation_fanRotation %= 360.0f;
        if (state.speed > 0) {
            state.soundGrace = 40;
        } else if (state.soundGrace > 0) {
            --state.soundGrace;
        }
        Vec3 runningPos = ctx.getLevel().toAbsolute(new Vec3((double)RUNNING_SOUND_POI.m_123341_() + 0.5, (double)RUNNING_SOUND_POI.m_123342_() + 0.5, (double)RUNNING_SOUND_POI.m_123343_() + 0.5));
        Vec3 starterPos = ctx.getLevel().toAbsolute(new Vec3((double)STARTER_SOUND_POI.m_123341_() + 0.5, (double)STARTER_SOUND_POI.m_123342_() + 0.5, (double)STARTER_SOUND_POI.m_123343_() + 0.5));
        Vec3 arcPos = ctx.getLevel().toAbsolute(new Vec3((double)ARC_SOUND_POI.m_123341_() + 0.5, (double)ARC_SOUND_POI.m_123342_() + 0.5, (double)ARC_SOUND_POI.m_123343_() + 0.5));
        Vec3 sparkPos = ctx.getLevel().toAbsolute(new Vec3((double)SPARK_SOUND_POI.m_123341_() + 0.5, (double)SPARK_SOUND_POI.m_123342_() + 0.5, (double)SPARK_SOUND_POI.m_123343_() + 0.5));
        Vec3 ignitePos = ctx.getLevel().toAbsolute(new Vec3((double)IGNITE_SOUND_POI.m_123341_() + 0.5, (double)IGNITE_SOUND_POI.m_123342_() + 0.5, (double)IGNITE_SOUND_POI.m_123343_() + 0.5));
        float runningAtt = (float)Math.max(player.m_20238_(runningPos) / 32.0, 1.0);
        float runningVol = 8.0f * (smoothedLevel - 0.2f) / runningAtt;
        if (state.speed > 0 && (state.everIgnited && !state.starterRunning || state.stall && state.ignited) && runningVol > 0.01f && !state.runningSoundPlaying.getAsBoolean()) {
            ++state.runningSoundId;
            int thisId = state.runningSoundId;
            state.runningSoundPlaying = ITSound.startSound(() -> state.speed > 0 && (state.everIgnited && !state.starterRunning || state.stall && state.ignited) && state.runningSoundId == thisId, ctx.isValid(), runningPos, ITSounds.gasRunning, () -> {
                LocalPlayer p = Minecraft.m_91087_().f_91074_;
                if (p == null) {
                    return Float.valueOf(0.0f);
                }
                float a = (float)Math.max(p.m_20238_(runningPos) / 32.0, 1.0);
                return Float.valueOf(8.0f * (smoothedLevel - 0.2f) / a);
            }, () -> Float.valueOf(state.currentPitch));
        }
        if (state.starterRunning) {
            float arcAtt;
            float arcVol;
            float starterAtt = (float)Math.max(player.m_20238_(starterPos) / 64.0, 1.0);
            float starterVol = Math.min(smoothedLevel / starterAtt, 0.4f);
            if (starterVol > 0.01f && !state.starterSoundPlaying.getAsBoolean()) {
                ++state.starterSoundId;
                int thisId = state.starterSoundId;
                state.starterSoundPlaying = ITSound.startSound(() -> state.starterRunning && state.starterSoundId == thisId, ctx.isValid(), starterPos, ITSounds.gasStarter, () -> {
                    LocalPlayer p = Minecraft.m_91087_().f_91074_;
                    if (p == null) {
                        return Float.valueOf(0.0f);
                    }
                    float a = (float)Math.max(p.m_20238_(starterPos) / 64.0, 1.0);
                    return Float.valueOf(Math.min(smoothedLevel / a, 0.4f));
                }, () -> Float.valueOf(1.0f));
            }
            if (state.speed >= state.effectiveMaxSpeed / 4 && state.hasIgniter && (arcVol = Math.min(smoothedLevel / (arcAtt = (float)Math.max(player.m_20238_(arcPos) / 64.0, 1.0)), 0.4f)) > 0.01f && !state.arcSoundPlaying.getAsBoolean()) {
                ++state.arcSoundId;
                int thisId = state.arcSoundId;
                state.arcSoundPlaying = ITSound.startSound(() -> state.starterRunning && state.speed >= state.effectiveMaxSpeed / 4 && state.hasIgniter && state.arcSoundId == thisId, ctx.isValid(), arcPos, ITSounds.gasArc, () -> {
                    LocalPlayer p = Minecraft.m_91087_().f_91074_;
                    if (p == null) {
                        return Float.valueOf(0.0f);
                    }
                    float a = (float)Math.max(p.m_20238_(arcPos) / 64.0, 1.0);
                    return Float.valueOf(Math.min(smoothedLevel / a, 0.4f));
                }, () -> Float.valueOf(1.0f));
            }
        }
        if (state.ignited && !state.lastIgnited && state.speed < state.effectiveMaxSpeed / 2) {
            state.lastIgnited = true;
            float ignitionAtt = (float)Math.max(player.m_20238_(sparkPos) / 64.0, 1.0);
            level.m_7785_(sparkPos.f_82479_, sparkPos.f_82480_, sparkPos.f_82481_, (SoundEvent)ITSounds.gasSpark.get(), SoundSource.BLOCKS, 1.0f / ignitionAtt, 1.0f, false);
            state.igniteDelay = 3;
        } else {
            state.lastIgnited = state.ignited;
        }
        if (state.igniteDelay > 0) {
            --state.igniteDelay;
            if (state.igniteDelay == 0 && state.starterRunning) {
                float ignitionAtt = (float)Math.max(player.m_20238_(ignitePos) / 64.0, 1.0);
                level.m_7785_(ignitePos.f_82479_, ignitePos.f_82480_, ignitePos.f_82481_, (SoundEvent)ITSounds.gasIgnite.get(), SoundSource.BLOCKS, 1.0f / ignitionAtt, 1.0f, false);
            }
        }
        if (state.starterRunning && state.speed >= state.effectiveMaxSpeed / 4) {
            if (level.f_46441_.m_188503_(40) == 0) {
                return;
            }
            Vec3 particlePos = ctx.getLevel().toAbsolute(new Vec3((double)SMOKE_POI1.m_123341_() + 0.5, (double)SMOKE_POI1.m_123342_() - 0.5, (double)SMOKE_POI1.m_123343_() + 0.5));
            double distSq = player.m_20238_(particlePos);
            if (distSq > 4096.0) {
                return;
            }
            double px = particlePos.f_82479_ + 2.0 - (double)(level.f_46441_.m_188501_() * 3.0f);
            double py = particlePos.f_82480_ + 0.5;
            double pz = particlePos.f_82481_ + 2.0 - (double)(level.f_46441_.m_188501_() * 3.0f);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 0.0, 0.02, 0.0);
        }
        if (state.active && ctx.getLevel().shouldTickModulo(2)) {
            Direction facing = ctx.getLevel().getOrientation().front();
            BlockPos outputAbs = ctx.getLevel().toAbsolute(SMOKE_POI2);
            boolean connected = state.fluidOutput.isPresent();
            if (!connected) {
                Vec3 smokePos = new Vec3((double)outputAbs.m_123341_() + 0.5, (double)outputAbs.m_123342_() + 0.5, (double)outputAbs.m_123343_() + 0.5);
                float normSpeed = Math.max(0.0f, ITLib.remapRange(100.0f, state.effectiveMaxSpeed, 0.0f, 1.0f, state.speed));
                double dirVelHoriz = 0.125 * (double)normSpeed;
                double dirVelVert = 0.1 * (double)normSpeed;
                double baseUp = 0.0625 + 0.1 * (double)(1.0f - normSpeed);
                double velX = (double)facing.m_122429_() * dirVelHoriz + GasTurbineLogic.particleXZSpeed();
                double velY = (double)facing.m_122430_() * dirVelVert + baseUp;
                double velZ = (double)facing.m_122431_() * dirVelHoriz + GasTurbineLogic.particleXZSpeed();
                FluidStack outFluid = state.tanks.output.getFluid();
                float r = 0.5f;
                float g = 0.5f;
                float b = 0.5f;
                if (!outFluid.isEmpty()) {
                    int tint = IClientFluidTypeExtensions.of((Fluid)outFluid.getFluid()).getTintColor(outFluid);
                    r = (float)(tint >> 16 & 0xFF) / 255.0f;
                    g = (float)(tint >> 8 & 0xFF) / 255.0f;
                    b = (float)(tint & 0xFF) / 255.0f;
                }
                level.m_7107_((ParticleOptions)new ColoredSmoke(r, g, b), smokePos.f_82479_, smokePos.f_82480_, smokePos.f_82481_, velX, velY, velZ);
            }
        }
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        int effectiveMax;
        LazyOptional consumerCap;
        this.pumpOutputs(ctx);
        State state = (State)ctx.getState();
        state.hasIgniter = state.mvInput.isPresent();
        state.canIgniteClient = 1024 <= state.energyStorageMV.getEnergyStored();
        boolean wasActive = state.active;
        boolean wasStall = state.stall;
        state.active = false;
        Level level = ctx.getLevel().getRawLevel();
        Direction outputFacing = ctx.getLevel().getOrientation().front();
        BlockPos outputPortAbs = ctx.getLevel().toAbsolute(ROTATIONAL_OUTPUT_POI.posInMultiblock());
        BlockPos consumerAbsPos = outputPortAbs.m_121945_(outputFacing);
        BlockEntity entity = level.m_7702_(consumerAbsPos);
        boolean hasConsumer = false;
        double additionalMass = 0.0;
        double additionalFriction = 0.0;
        int consumerMaxSpeed = 7200;
        if (entity != null && (consumerCap = entity.getCapability(MechanicalCapabilities.MECHANICAL_CONSUMER_CAPABILITY, outputFacing.m_122424_())).isPresent()) {
            hasConsumer = true;
            IMechanicalEnergyConsumer consumer = (IMechanicalEnergyConsumer)consumerCap.orElseThrow(RuntimeException::new);
            additionalMass = consumer.getMass();
            additionalFriction = consumer.getFriction();
            consumerMaxSpeed = consumer.getMaxSpeed();
        }
        state.effectiveMaxSpeed = effectiveMax = hasConsumer ? Math.min(3600, consumerMaxSpeed) : 3600;
        if (additionalMass != state.connectedMass || additionalFriction != state.connectedFriction) {
            state.connectedMass = additionalMass;
            state.connectedFriction = additionalFriction;
            state.inertia = new RotationInertiaProcess(8.0 + state.connectedMass, 30.0, 60.0 + state.connectedFriction, effectiveMax);
        }
        boolean isRSEnabled = state.rsState.isEnabled(ctx);
        state.ignited = state.ignitionGracePeriod > 0;
        state.starterRunning = false;
        if (isRSEnabled && 4096 <= state.energyStorageHV.getEnergyStored()) {
            state.starterRunning = true;
            state.energyStorageHV.extractEnergy(4096, false);
        }
        if (state.speed <= 0) {
            state.speed = 0;
            state.isShutdown = false;
            state.stall = false;
        }
        if (!isRSEnabled || !hasConsumer) {
            state.isShutdown = true;
            state.ignitionGracePeriod = 0;
            state.burnRemaining = 0;
            state.stall = false;
        }
        if (state.speed < effectiveMax / 4) {
            if (isRSEnabled && !state.isShutdown) {
                if (state.ignitionGracePeriod > 0) {
                    --state.ignitionGracePeriod;
                }
                if (state.starterRunning) {
                    state.speed = Math.min(effectiveMax, state.speed + state.inertia.getSpeedUpRate());
                    state.active = true;
                } else {
                    state.speed = Math.max(0, state.speed - state.inertia.getSpeedDownRate());
                }
            } else {
                state.speed = Math.max(0, state.speed - state.inertia.getSpeedDownRate());
            }
        } else if (state.isShutdown) {
            state.speed = Math.max(0, state.speed - state.inertia.getSpeedDownRate());
        } else if (state.starterRunning) {
            if (state.hasIgniter && this.canIgnite(state)) {
                state.stall = true;
                if (!wasStall) {
                    this.ignite(state, ctx);
                } else {
                    state.ignitionGracePeriod = 60;
                }
                state.speed = effectiveMax / 4;
                state.active = true;
                if (state.ignitionGracePeriod > 0) {
                    --state.ignitionGracePeriod;
                }
            } else {
                state.stall = false;
                state.speed = Math.max(0, state.speed - state.inertia.getSpeedDownRate());
            }
        } else {
            state.stall = false;
            if (state.burnRemaining > 0 && (state.ignited || this.canIgnite(state))) {
                --state.burnRemaining;
                if (!state.ignited) {
                    this.ignite(state, ctx);
                }
                state.speed = Math.min(effectiveMax, state.speed + state.inertia.getSpeedUpRate());
                state.active = true;
            } else if (state.ignited || this.canIgnite(state)) {
                FluidStack fluid = state.tanks.input.getFluid();
                GasTurbineRecipe recipe = state.recipeGetter.apply(ctx.getLevel().getRawLevel(), fluid);
                if (recipe != null && fluid.getAmount() >= recipe.input.getAmount()) {
                    int filled;
                    state.tanks.input.drain(recipe.input.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                    if (recipe.fluidOutput == null || (filled = state.tanks.output.fill(recipe.fluidOutput, IFluidHandler.FluidAction.EXECUTE)) < recipe.fluidOutput.getAmount()) {
                        // empty if block
                    }
                    state.burnRemaining = recipe.getTotalProcessTime() - 1;
                    if (!state.ignited) {
                        this.ignite(state, ctx);
                    }
                    state.speed = Math.min(effectiveMax, state.speed + state.inertia.getSpeedUpRate());
                    state.active = true;
                    ctx.markMasterDirty();
                } else {
                    state.speed = Math.max(0, state.speed - state.inertia.getSpeedDownRate());
                }
            } else {
                state.speed = Math.max(0, state.speed - state.inertia.getSpeedDownRate());
            }
        }
        if (wasActive != state.active || wasStall != state.stall || state.speed % 20 == 0) {
            ctx.markMasterDirty();
            ctx.requestMasterBESync();
        }
    }

    private boolean canIgnite(State state) {
        return 1024 <= state.energyStorageMV.getEnergyStored();
    }

    private void ignite(State state, IMultiblockContext<State> ctx) {
        state.energyStorageMV.extractEnergy(1024, false);
        state.everIgnited = true;
        state.ignited = true;
        state.ignitionGracePeriod = 60;
        ctx.requestMasterBESync();
    }

    private static double particleXZSpeed() {
        return ApiUtils.RANDOM.nextDouble(-0.015625, 0.015625);
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY) {
            if (position.equals((Object)ENERGY_INPUT_HV_POI)) {
                return state.energyCapHV.cast(ctx);
            }
            if (position.equals((Object)ENERGY_INPUT_MV_POI)) {
                return state.energyCapMV.cast(ctx);
            }
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (position.equals((Object)INPUT_FLUID_POI)) {
                return state.fluidCap.cast(ctx);
            }
            if (position.equals((Object)OUTPUT_FLUID_POI)) {
                return state.fluidCapExhaust.cast(ctx);
            }
        }
        if (cap == MechanicalCapabilities.MECHANICAL_PROVIDER_CAPABILITY && position.equals((Object)ROTATIONAL_OUTPUT_POI)) {
            return LazyOptional.of(() -> new MechanicalEnergyProvider(state)).cast();
        }
        return LazyOptional.empty();
    }

    public State createInitialState(IInitialMultiblockContext<State> ctx) {
        return new State(ctx);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return GasTurbineShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ITDisplayContext {
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final GasTurbineTank tanks;
        public final StoredCapability<IFluidHandler> fluidCap;
        public final StoredCapability<IFluidHandler> fluidCapExhaust;
        public StoredCapability<IEnergyStorage> energyCapHV;
        public StoredCapability<IEnergyStorage> energyCapMV;
        public AveragingEnergyStorage energyStorageHV;
        public AveragingEnergyStorage energyStorageMV;
        public final CapabilityReference<IFluidHandler> fluidOutput;
        public final CapabilityReference<IEnergyStorage> mvInput;
        private final BiFunction<Level, FluidStack, GasTurbineRecipe> recipeGetter;
        public int speed = 0;
        public boolean active = false;
        public boolean starterRunning = false;
        public boolean ignited = false;
        public boolean stall = false;
        public boolean everIgnited = false;
        public boolean hasIgniter = false;
        public boolean canIgniteClient = false;
        public int burnRemaining = 0;
        public int ignitionGracePeriod = 0;
        public boolean isShutdown = false;
        public int effectiveMaxSpeed = 3600;
        public float animation_fanRotationStep = 0.0f;
        public float animation_fanRotation = 0.0f;
        private transient int animation_fanFadeIn = 0;
        private transient float currentLevel = 0.0f;
        private transient float currentPitch = 0.0f;
        private BooleanSupplier runningSoundPlaying = () -> false;
        private BooleanSupplier starterSoundPlaying = () -> false;
        private BooleanSupplier arcSoundPlaying = () -> false;
        private int runningSoundId = 0;
        private int starterSoundId = 0;
        private int arcSoundId = 0;
        private boolean lastIgnited = false;
        private int igniteDelay = 0;
        private double connectedMass = 0.0;
        private double connectedFriction = 0.0;
        private RotationInertiaProcess inertia;
        private transient int soundGrace = 0;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            Runnable onChanged = () -> {
                markDirty.run();
                sync.run();
            };
            this.tanks = new GasTurbineTank(v -> onChanged.run());
            this.fluidCap = new StoredCapability((Object)new ITArrayFluidHandler((IFluidTank)this.tanks.input, false, true, onChanged));
            this.fluidCapExhaust = new StoredCapability((Object)new ITArrayFluidHandler((IFluidTank)this.tanks.output, true, false, onChanged));
            this.energyStorageHV = new AveragingEnergyStorage(8192);
            this.energyStorageMV = new AveragingEnergyStorage(2048);
            this.energyCapHV = new StoredCapability((Object)this.energyStorageHV);
            this.energyCapMV = new StoredCapability((Object)this.energyStorageMV);
            this.recipeGetter = CachedRecipe.cached(GasTurbineRecipe::findRecipe);
            MultiblockFace outputMBFace = new MultiblockFace(OUTPUT_FACING, FLUID_OUTPUT_POIS.get(0));
            CapabilityPosition oppCp = CapabilityPosition.opposing((MultiblockFace)outputMBFace);
            MultiblockFace oppMbf = new MultiblockFace(oppCp.side(), oppCp.posInMultiblock());
            this.fluidOutput = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, oppMbf);
            MultiblockFace mvInputMBFace = new MultiblockFace(ENERGY_INPUT_MV_POI.side(), ENERGY_INPUT_MV_POI.posInMultiblock());
            CapabilityPosition mvOpposingCP = CapabilityPosition.opposing((MultiblockFace)mvInputMBFace);
            MultiblockFace mvOpposingMBFace = new MultiblockFace(mvOpposingCP.side(), mvOpposingCP.posInMultiblock());
            this.mvInput = ctx.getCapabilityAt(ForgeCapabilities.ENERGY, mvOpposingMBFace);
            this.inertia = new RotationInertiaProcess(8.0, 30.0, 60.0, 3600);
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128405_("speed", this.speed);
            nbt.m_128379_("active", this.active);
            nbt.m_128379_("starterRunning", this.starterRunning);
            nbt.m_128379_("ignited", this.ignited);
            nbt.m_128379_("stall", this.stall);
            nbt.m_128379_("everIgnited", this.everIgnited);
            nbt.m_128405_("burnRemaining", this.burnRemaining);
            nbt.m_128405_("ignitionGracePeriod", this.ignitionGracePeriod);
            nbt.m_128379_("isShutdown", this.isShutdown);
            nbt.m_128405_("effectiveMaxSpeed", this.effectiveMaxSpeed);
            nbt.m_128365_("tanks", (Tag)this.tanks.toNBT());
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.speed = nbt.m_128451_("speed");
            this.active = nbt.m_128471_("active");
            this.starterRunning = nbt.m_128471_("starterRunning");
            this.ignited = nbt.m_128471_("ignited");
            this.stall = nbt.m_128471_("stall");
            this.everIgnited = nbt.m_128471_("everIgnited");
            this.burnRemaining = nbt.m_128451_("burnRemaining");
            this.ignitionGracePeriod = nbt.m_128451_("ignitionGracePeriod");
            this.isShutdown = nbt.m_128471_("isShutdown");
            this.effectiveMaxSpeed = nbt.m_128451_("effectiveMaxSpeed");
            this.tanks.readNBT(nbt.m_128469_("tanks"));
        }

        public void writeSyncNBT(CompoundTag nbt) {
            CompoundTag display = new CompoundTag();
            this.writeDisplaySyncNBT(display);
            nbt.m_128365_("display", (Tag)display);
        }

        public void readSyncNBT(CompoundTag nbt) {
            if (nbt.m_128425_("display", 10)) {
                this.readDisplaySyncNBT(nbt.m_128469_("display"));
            }
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energyStorageHV;
        }

        @Override
        public List<AveragingEnergyStorage> getEnergies() {
            return List.of(this.energyStorageHV, this.energyStorageMV);
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return new IFluidTank[]{this.tanks.input, this.tanks.output};
        }

        @Override
        public void writeDisplaySyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
            nbt.m_128379_("starterRunning", this.starterRunning);
            nbt.m_128379_("ignited", this.ignited);
            nbt.m_128405_("speed", this.speed);
            nbt.m_128379_("isShutdown", this.isShutdown);
            nbt.m_128379_("stall", this.stall);
            nbt.m_128379_("everIgnited", this.everIgnited);
            nbt.m_128379_("hasIgniter", this.hasIgniter);
            nbt.m_128379_("canIgnite", this.canIgniteClient);
            nbt.m_128405_("effectiveMaxSpeed", this.effectiveMaxSpeed);
            nbt.m_128365_("tanks", (Tag)this.tanks.toNBT());
        }

        @Override
        public void readDisplaySyncNBT(CompoundTag nbt) {
            boolean oldActive = this.active;
            this.active = nbt.m_128471_("active");
            this.starterRunning = nbt.m_128471_("starterRunning");
            this.ignited = nbt.m_128471_("ignited");
            this.speed = nbt.m_128451_("speed");
            this.isShutdown = nbt.m_128471_("isShutdown");
            this.stall = nbt.m_128471_("stall");
            this.everIgnited = nbt.m_128471_("everIgnited");
            this.hasIgniter = nbt.m_128471_("hasIgniter");
            this.canIgniteClient = nbt.m_128471_("canIgnite");
            this.effectiveMaxSpeed = nbt.m_128451_("effectiveMaxSpeed");
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            if (this.active && !oldActive && this.speed < this.effectiveMaxSpeed / 4) {
                this.animation_fanFadeIn = 80;
            }
        }
    }

    public record GasTurbineTank(ITMarkableFluidTank input, ITMarkableFluidTank output) {
        public GasTurbineTank(Consumer<Void> markDirty) {
            this(new ITMarkableFluidTank(12000, markDirty), new ITMarkableFluidTank(12000, markDirty));
        }

        public static GasTurbineTank makeClient() {
            return new GasTurbineTank(v -> {});
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("input", (Tag)this.input.writeToNBT(new CompoundTag()));
            tag.m_128365_("output", (Tag)this.output.writeToNBT(new CompoundTag()));
            return tag;
        }

        public void readNBT(CompoundTag tag) {
            this.input.readFromNBT(tag.m_128469_("input"));
            this.output.readFromNBT(tag.m_128469_("output"));
        }

        public int getCapacity() {
            return 12000;
        }
    }

    private record MechanicalEnergyProvider(State state) implements IMechanicalEnergyProvider
    {
        @Override
        public int getSpeed() {
            return this.state.speed;
        }

        @Override
        public float getTorque() {
            return 1.0f;
        }

        @Override
        public int getMaxSpeed() {
            return 3600;
        }

        @Override
        public double getBaseMass() {
            return 8.0;
        }

        @Override
        public double getDriveTorque() {
            return 30.0;
        }

        @Override
        public double getFriction() {
            return 60.0;
        }
    }
}

