/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.logic;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import mctmods.immersivetechnology.common.fluids.helper.ITArrayFluidHandler;
import mctmods.immersivetechnology.common.fluids.helper.ITMarkableFluidTank;
import mctmods.immersivetechnology.common.multiblocks.helper.ITDisplayContext;
import mctmods.immersivetechnology.common.multiblocks.helper.ITMultiBlockInventoryUtils;
import mctmods.immersivetechnology.common.multiblocks.helper.ITPressurizedFluidOutput;
import mctmods.immersivetechnology.common.multiblocks.helper.ITProcessContext;
import mctmods.immersivetechnology.common.multiblocks.helper.ITSlotwiseItemHandler;
import mctmods.immersivetechnology.common.multiblocks.helper.ITWrappingItemHandler;
import mctmods.immersivetechnology.common.multiblocks.metal.process.DistillerProcess;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.DistillerRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.DistillerShape;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.core.lib.ITSound;
import mctmods.immersivetechnology.core.registration.ITSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class DistillerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State>,
ITPressurizedFluidOutput<State> {
    public static final int SLOT_INPUT_FILLED = 0;
    public static final int SLOT_INPUT_EMPTY = 1;
    public static final int SLOT_OUTPUT_EMPTY = 2;
    public static final int SLOT_OUTPUT_FILLED = 3;
    public static final int OUTPUT_SLOT = 4;
    public static final int TANK_CAPACITY = 24000;
    public static final int ENERGY_CAPACITY = 32000;
    private static final List<PoIJSONSchema> RAW_POIS = ImmutableList.copyOf((Object[])DistillerShape.DATA.pointsOfInterest);
    public static final BlockPos REDSTONE_POI = DistillerLogic.getPosList("redstone").get(0);
    public static final CapabilityPosition INPUT_FLUID_POI = new CapabilityPosition(DistillerLogic.getPosList("fluid_input").get(0), DistillerLogic.getFacing("fluid_input"));
    public static final CapabilityPosition OUTPUT_FLUID_POI = new CapabilityPosition(DistillerLogic.getPosList("fluid_output").get(0), DistillerLogic.getFacing("fluid_output"));
    private static final List<BlockPos> ENERGY_POI_POS = DistillerLogic.getPosList("energy_input");
    private static final RelativeBlockFace ENERGY_POI_FACING = DistillerLogic.getFacing("energy_input");
    public static final CapabilityPosition ENERGY_POI = new CapabilityPosition(ENERGY_POI_POS.get(0), ENERGY_POI_FACING);
    public static final MultiblockFace ITEM_OUTPUT_POI = new MultiblockFace(DistillerLogic.getFacing("item_output"), DistillerLogic.getPosList("item_output").get(0));
    private static final List<BlockPos> FLUID_OUTPUT_POIS = DistillerLogic.getPosList("fluid_output");
    private static final RelativeBlockFace OUTPUT_FACING = DistillerLogic.getFacing("fluid_output");

    private static List<BlockPos> getPosList(String name) {
        return (List)RAW_POIS.stream().filter(poi -> poi.name.equals(name)).map(poi -> new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2])).collect(ImmutableList.toImmutableList());
    }

    private static RelativeBlockFace getFacing(String name) {
        List facings = RAW_POIS.stream().filter(poi -> poi.name.equals(name)).flatMap(poi -> poi.relativeFaces.stream()).distinct().toList();
        if (facings.size() != 1) {
            throw new RuntimeException("Inconsistent facings for POI: " + name);
        }
        return (RelativeBlockFace)facings.get(0);
    }

    @Override
    public List<BlockPos> getOutputPositions() {
        return FLUID_OUTPUT_POIS;
    }

    @Override
    public Direction getOutputDirection(IMultiblockContext<State> ctx) {
        return ctx.getLevel().toAbsolute(OUTPUT_FACING);
    }

    @Override
    public List<ITMarkableFluidTank> getOutputTanks(State state) {
        return ImmutableList.of((Object)((Object)state.tanks.output));
    }

    @Override
    public List<CapabilityReference<IFluidHandler>> getFluidOutputs(State state) {
        return ImmutableList.of(state.fluidOutput);
    }

    public void tickClient(IMultiblockContext<State> ctx) {
        State state = (State)ctx.getState();
        List<BlockPos> soundPosList = DistillerLogic.getPosList("sound");
        BlockPos soundBlockPos = soundPosList.get(0);
        Vec3 soundPos = ctx.getLevel().toAbsolute(new Vec3((double)soundBlockPos.m_123341_() + 0.5, (double)soundBlockPos.m_123342_() + 0.5, (double)soundBlockPos.m_123343_() + 0.5));
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        float distSq = (float)player.m_20238_(soundPos);
        float attenuation = Math.max(distSq / 32.0f, 1.0f);
        float vol = 1.0f / attenuation;
        if (state.active && vol > 0.01f && !state.isSoundPlaying.getAsBoolean()) {
            state.isSoundPlaying = ITSound.startSound(() -> state.active, ctx.isValid(), soundPos, ITSounds.distiller, () -> {
                LocalPlayer p = Minecraft.m_91087_().f_91074_;
                if (p == null) {
                    return Float.valueOf(0.0f);
                }
                float a = (float)Math.max(p.m_20238_(soundPos) / 32.0, 1.0);
                return Float.valueOf(1.0f / a);
            }, () -> Float.valueOf(1.0f));
        }
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        boolean update;
        ItemStack itemOutput;
        ItemStack filledContainer;
        State state = (State)ctx.getState();
        state.energy.updateAverage();
        int prevEnergy = state.energy.getEnergyStored();
        CompoundTag prevTanksNBT = state.tanks.toNBT();
        DistillerRecipe recipe = DistillerRecipe.findRecipe(ctx.getLevel().getRawLevel(), state.tanks.input.getFluid());
        boolean wasActive = state.active;
        state.active = state.processor.tickServer((ProcessContext)state, ctx.getLevel(), state.rsState.isEnabled(ctx));
        this.tryEnqueueProcess(state, ctx.getLevel().getRawLevel(), recipe);
        this.tryEmptyContainer((IFluidHandler)state.tanks.input, state.inventory);
        FluidUtils.fillFluidContainer((IFluidHandler)state.tanks.output, (int)2, (int)3, (IItemHandlerModifiable)state.inventory);
        this.pumpOutputs(ctx);
        ITSlotwiseItemHandler inventory = state.inventory;
        ItemStack drainedContainer = inventory.getStackInSlot(1);
        if (!drainedContainer.m_41619_()) {
            drainedContainer = Utils.insertStackIntoInventory(state.outputRef, (ItemStack)drainedContainer, (boolean)false);
            inventory.setStackInSlot(1, drainedContainer);
        }
        if (!(filledContainer = inventory.getStackInSlot(3)).m_41619_()) {
            filledContainer = Utils.insertStackIntoInventory(state.outputRef, (ItemStack)filledContainer, (boolean)false);
            inventory.setStackInSlot(3, filledContainer);
        }
        if (!(itemOutput = inventory.getStackInSlot(4)).m_41619_()) {
            itemOutput = Utils.insertStackIntoInventory(state.outputRef, (ItemStack)itemOutput, (boolean)false);
            inventory.setStackInSlot(4, itemOutput);
        }
        boolean activeChanged = wasActive != state.active;
        int currentEnergy = state.energy.getEnergyStored();
        boolean energyChanged = prevEnergy != currentEnergy;
        CompoundTag currentTanksNBT = state.tanks.toNBT();
        boolean tanksChanged = !prevTanksNBT.equals((Object)currentTanksNBT);
        boolean bl = update = activeChanged || energyChanged || tanksChanged;
        if (update) {
            ctx.markMasterDirty();
            ctx.requestMasterBESync();
        }
    }

    private void tryEmptyContainer(IFluidHandler tank, IItemHandlerModifiable inv) {
        ItemStack filledContainer = inv.getStackInSlot(0);
        if (filledContainer.m_41619_()) {
            return;
        }
        FluidActionResult result = FluidUtils.tryEmptyContainer((ItemStack)filledContainer, (IFluidHandler)tank, (int)1000, (IFluidHandler.FluidAction)IFluidHandler.FluidAction.SIMULATE);
        if (!result.isSuccess()) {
            return;
        }
        ItemStack emptyContainer = result.getResult();
        ItemStack outputStack = inv.getStackInSlot(1);
        if (!outputStack.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)outputStack, (ItemStack)emptyContainer)) {
            return;
        }
        if (outputStack.m_41613_() + emptyContainer.m_41613_() > emptyContainer.m_41741_()) {
            return;
        }
        result = FluidUtils.tryEmptyContainer((ItemStack)filledContainer, (IFluidHandler)tank, (int)1000, (IFluidHandler.FluidAction)IFluidHandler.FluidAction.EXECUTE);
        filledContainer.m_41774_(1);
        inv.setStackInSlot(0, filledContainer);
        if (outputStack.m_41619_()) {
            inv.setStackInSlot(1, result.getResult());
        } else {
            outputStack.m_41769_(result.getResult().m_41613_());
        }
    }

    private void tryEnqueueProcess(State state, Level level, DistillerRecipe recipe) {
        ItemStack currentOutput;
        if (state.processor.getQueueSize() >= state.processor.getMaxQueueSize()) {
            return;
        }
        if (recipe == null) {
            return;
        }
        FluidStack inputFluid = state.tanks.input.getFluid();
        if (inputFluid.getAmount() < recipe.input.getAmount()) {
            return;
        }
        FluidStack outputFluid = recipe.fluidOutput;
        if (outputFluid != null && !outputFluid.isEmpty() && state.tanks.output.getFluidAmount() + outputFluid.getAmount() > state.tanks.output.getCapacity()) {
            return;
        }
        ItemStack itemOutput = recipe.itemOutput;
        if (!(itemOutput.m_41619_() || (currentOutput = state.inventory.getStackInSlot(4)).m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)currentOutput, (ItemStack)itemOutput) && currentOutput.m_41613_() + itemOutput.m_41613_() <= currentOutput.m_41741_())) {
            return;
        }
        DistillerProcess process = new DistillerProcess(recipe);
        process.setInputTanks(new int[]{0});
        state.processor.addProcessToQueue((MultiblockProcess)process, level, false);
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY) {
            if (position.posInMultiblock().equals((Object)ENERGY_POI.posInMultiblock()) && (position.side() == null || position.side() == ENERGY_POI.side())) {
                return state.energyCap.cast(ctx);
            }
        } else if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (position.posInMultiblock().equals((Object)INPUT_FLUID_POI.posInMultiblock()) && (position.side() == null || position.side() == INPUT_FLUID_POI.side())) {
                return state.inputCap.cast(ctx);
            }
            if (position.posInMultiblock().equals((Object)OUTPUT_FLUID_POI.posInMultiblock()) && (position.side() == null || position.side() == OUTPUT_FLUID_POI.side())) {
                return state.outputCapSteam.cast(ctx);
            }
        } else if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (position.posInMultiblock().equals((Object)ITEM_OUTPUT_POI.posInMultiblock()) && (position.side() == null || position.side() == ITEM_OUTPUT_POI.face())) {
                return state.itemOutputCap.cast(ctx);
            }
            return state.invCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        ITMultiBlockInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    public State createInitialState(IInitialMultiblockContext<State> ctx) {
        return new State(ctx);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return DistillerShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ITProcessContext.ProcessContextInMachine<DistillerRecipe>,
    ITDisplayContext {
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final DistillerTank tanks;
        public final StoredCapability<IEnergyStorage> energyCap;
        public final StoredCapability<IFluidHandler> inputCap;
        public final StoredCapability<IFluidHandler> outputCapSteam;
        public final StoredCapability<IItemHandler> invCap;
        public final CapabilityReference<IFluidHandler> fluidOutput;
        public final StoredCapability<IItemHandler> itemOutputCap;
        public final CapabilityReference<IItemHandler> outputRef;
        public final ITSlotwiseItemHandler inventory;
        private final IFluidTank[] tankArray;
        public final MultiblockProcessor.InMachineProcessor<DistillerRecipe> processor;
        public AveragingEnergyStorage energy;
        public boolean active;
        public BooleanSupplier isSoundPlaying = () -> false;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            Runnable onChanged = () -> {
                markDirty.run();
                sync.run();
            };
            this.tanks = new DistillerTank(v -> onChanged.run());
            this.tankArray = new IFluidTank[]{this.tanks.input, this.tanks.output};
            this.inventory = new ITSlotwiseItemHandler(List.of(ITSlotwiseItemHandler.IOConstraint.FLUID_INPUT, ITSlotwiseItemHandler.IOConstraint.OUTPUT, ITSlotwiseItemHandler.IOConstraint.FLUID_INPUT, ITSlotwiseItemHandler.IOConstraint.OUTPUT, ITSlotwiseItemHandler.IOConstraint.OUTPUT), onChanged);
            this.inputCap = new StoredCapability((Object)new ITArrayFluidHandler((IFluidTank)this.tanks.input, false, true, onChanged));
            this.outputCapSteam = new StoredCapability((Object)new ITArrayFluidHandler((IFluidTank)this.tanks.output, true, false, onChanged));
            this.invCap = new StoredCapability((Object)this.inventory);
            this.energy = new SyncEnergyStorage(32000, onChanged);
            this.energyCap = new StoredCapability((Object)this.energy);
            this.processor = new MultiblockProcessor.InMachineProcessor(1, 0.0f, 1, markDirty, (arg_0, arg_1) -> DistillerRecipe.RECIPES.getById(arg_0, arg_1));
            MultiblockFace outputMBFace = new MultiblockFace(OUTPUT_FLUID_POI.side(), OUTPUT_FLUID_POI.posInMultiblock());
            CapabilityPosition opposingCP = CapabilityPosition.opposing((MultiblockFace)outputMBFace);
            MultiblockFace opposingMBFace = new MultiblockFace(opposingCP.side(), opposingCP.posInMultiblock());
            this.fluidOutput = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, opposingMBFace);
            this.itemOutputCap = new StoredCapability((Object)new ITWrappingItemHandler((IItemHandler)this.inventory, false, true, List.of(new ITWrappingItemHandler.IntRange(1, 2), new ITWrappingItemHandler.IntRange(3, 4), new ITWrappingItemHandler.IntRange(4, 5))));
            this.outputRef = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, ITEM_OUTPUT_POI);
        }

        @Override
        public ITSlotwiseItemHandler getInventory() {
            return this.inventory;
        }

        public DistillerTank getTanks() {
            return this.tanks;
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("tanks", (Tag)this.tanks.toNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128379_("active", this.active);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.processor.fromNBT((Tag)nbt.m_128437_("processor", 10), DistillerProcess::new);
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.active = nbt.m_128471_("active");
        }

        public void writeSyncNBT(CompoundTag nbt) {
            CompoundTag display = new CompoundTag();
            this.writeDisplaySyncNBT(display);
            nbt.m_128365_("display", (Tag)display);
        }

        public void readSyncNBT(CompoundTag nbt) {
            if (nbt.m_128425_("display", 10)) {
                this.readDisplaySyncNBT(nbt.m_128469_("display"));
            }
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return this.tankArray;
        }

        public int[] getOutputTanks() {
            return new int[]{1};
        }

        public int[] getOutputSlots() {
            return new int[]{4};
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public void writeDisplaySyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
            nbt.m_128365_("tanks", (Tag)this.tanks.toNBT());
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
        }

        @Override
        public void readDisplaySyncNBT(CompoundTag nbt) {
            this.active = nbt.m_128471_("active");
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            if (this.energy == null) {
                this.energy = new SyncEnergyStorage(32000, () -> {});
            }
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }
    }

    public record DistillerTank(ITMarkableFluidTank input, ITMarkableFluidTank output) {
        public DistillerTank(Consumer<Void> markDirty) {
            this(new ITMarkableFluidTank(24000, markDirty), new ITMarkableFluidTank(24000, markDirty));
        }

        public static DistillerTank makeClient() {
            return new DistillerTank(v -> {});
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("input", (Tag)this.input.writeToNBT(new CompoundTag()));
            tag.m_128365_("output", (Tag)this.output.writeToNBT(new CompoundTag()));
            return tag;
        }

        public void readNBT(CompoundTag tag) {
            this.input.readFromNBT(tag.m_128469_("input"));
            this.output.readFromNBT(tag.m_128469_("output"));
        }

        public int getCapacity() {
            return 24000;
        }
    }

    private static class SyncEnergyStorage
    extends AveragingEnergyStorage {
        private final Runnable onChanged;

        public SyncEnergyStorage(int capacity, Runnable onChanged) {
            super(capacity);
            this.onChanged = onChanged;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (received > 0 && !simulate) {
                this.onChanged.run();
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (extracted > 0 && !simulate) {
                this.onChanged.run();
            }
            return extracted;
        }
    }
}

