/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.logic;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import mctmods.immersivetechnology.api.HeatCapabilities;
import mctmods.immersivetechnology.api.capability.IHeatConsumer;
import mctmods.immersivetechnology.api.capability.IHeatProvider;
import mctmods.immersivetechnology.common.fluids.helper.ITArrayFluidHandler;
import mctmods.immersivetechnology.common.fluids.helper.ITMarkableFluidTank;
import mctmods.immersivetechnology.common.multiblocks.helper.ITDisplayContext;
import mctmods.immersivetechnology.common.multiblocks.helper.ITMultiBlockInventoryUtils;
import mctmods.immersivetechnology.common.multiblocks.helper.ITPressurizedFluidOutput;
import mctmods.immersivetechnology.common.multiblocks.helper.ITSlotwiseItemHandler;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.BoilerTankRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.BoilerTankShape;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class BoilerTankLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
ITPressurizedFluidOutput<State> {
    public static final int INPUT_SLOT_FILLED = 0;
    public static final int INPUT_SLOT_EMPTY = 1;
    public static final int OUTPUT_SLOT_EMPTY = 2;
    public static final int OUTPUT_SLOT_FILLED = 3;
    public static final int TANK_CAPACITY = 24000;
    private static final int PROGRESS_LOSS_PER_TICK = 1;
    public static final double DEFAULT_WORKING_HEAT_LEVEL = 100.0;
    private static final List<PoIJSONSchema> RAW_POIS = ImmutableList.copyOf((Object[])BoilerTankShape.DATA.pointsOfInterest);
    public static final List<BlockPos> FLUID_INPUT_POI = BoilerTankLogic.getPosList("fluid_input");
    private static final List<BlockPos> FLUID_OUTPUT_POI = BoilerTankLogic.getPosList("fluid_output");
    private static final List<BlockPos> HEAT_INPUT_POI = BoilerTankLogic.getPosList("heat_input");
    private static final RelativeBlockFace FLUID_INPUT_FACING = BoilerTankLogic.getFacing("fluid_input");
    private static final RelativeBlockFace FLUID_OUTPUT_FACING = BoilerTankLogic.getFacing("fluid_output");
    private static final RelativeBlockFace HEAT_INPUT_FACING = BoilerTankLogic.getFacing("heat_input");

    private static List<BlockPos> getPosList(String name) {
        return (List)RAW_POIS.stream().filter(poi -> poi.name.equals(name)).map(poi -> new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2])).collect(ImmutableList.toImmutableList());
    }

    private static RelativeBlockFace getFacing(String name) {
        List facings = RAW_POIS.stream().filter(poi -> poi.name.equals(name)).flatMap(poi -> poi.relativeFaces.stream()).distinct().toList();
        if (facings.size() != 1) {
            throw new RuntimeException("Inconsistent facings for POI: " + name);
        }
        return (RelativeBlockFace)facings.get(0);
    }

    @Override
    public List<BlockPos> getOutputPositions() {
        return FLUID_OUTPUT_POI;
    }

    @Override
    public Direction getOutputDirection(IMultiblockContext<State> ctx) {
        return ctx.getLevel().toAbsolute(FLUID_OUTPUT_FACING);
    }

    @Override
    public List<ITMarkableFluidTank> getOutputTanks(State state) {
        return ImmutableList.of((Object)((Object)state.tanks.output));
    }

    @Override
    public List<CapabilityReference<IFluidHandler>> getFluidOutputs(State state) {
        return ImmutableList.of(state.fluidOutput);
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        double required;
        boolean isActive;
        State state = (State)ctx.getState();
        Level level = ctx.getLevel().getRawLevel();
        boolean update = false;
        double heatLevel = 0.0;
        if (state.heatSource.isPresent()) {
            heatLevel = ((IHeatProvider)state.heatSource.get()).getHeatLevel();
        }
        double previousHeatLevel = state.heatLevel;
        state.heatLevel = heatLevel;
        boolean bl = isActive = heatLevel >= state.getWorkingHeatLevel() && state.recipeTimeRemaining > 0;
        if (state.active != isActive) {
            state.active = isActive;
            update = true;
        }
        if (previousHeatLevel != state.heatLevel) {
            update = true;
        }
        if (heatLevel >= (required = state.getWorkingHeatLevel())) {
            if (state.recipeTimeRemaining > 0) {
                if (state.lastRecipe == null) {
                    state.recipeTimeRemaining = 0;
                    update = true;
                } else {
                    --state.recipeTimeRemaining;
                    if (state.recipeTimeRemaining == 0) {
                        state.tanks.output.fill(state.lastRecipe.output.copy(), IFluidHandler.FluidAction.EXECUTE);
                        update = true;
                    }
                }
            } else if (state.tanks.input.getFluidAmount() > 0) {
                int reqAmount;
                FluidStack drained;
                state.lastRecipe = BoilerTankRecipe.findRecipe(level, state.tanks.input.getFluid());
                if (state.lastRecipe != null && state.lastRecipe.input.getAmount() <= state.tanks.input.getFluidAmount() && state.lastRecipe.output.getAmount() <= state.tanks.output.getCapacity() - state.tanks.output.getFluidAmount() && heatLevel >= state.lastRecipe.requiredHeat && (drained = state.tanks.input.drain(reqAmount = state.lastRecipe.input.getAmount(), IFluidHandler.FluidAction.EXECUTE)).getAmount() == reqAmount && state.lastRecipe.input.testIgnoringAmount(drained)) {
                    state.recipeTimeRemaining = state.lastRecipe.getTotalProcessTime();
                    --state.recipeTimeRemaining;
                    if (state.recipeTimeRemaining == 0) {
                        state.tanks.output.fill(state.lastRecipe.output.copy(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    update = true;
                }
            }
        } else if (state.recipeTimeRemaining > 0) {
            int previousProgress = state.recipeTimeRemaining;
            if (state.lastRecipe == null) {
                state.recipeTimeRemaining = 0;
                update = true;
            } else {
                state.recipeTimeRemaining = Math.min(state.recipeTimeRemaining + 1, state.lastRecipe.getTotalProcessTime());
                if (previousProgress != state.recipeTimeRemaining) {
                    update = true;
                }
            }
        }
        if (state.tanks.output.getFluidAmount() > 0 && FluidUtils.fillFluidContainer((IFluidHandler)state.tanks.output, (int)2, (int)3, (IItemHandlerModifiable)state.inventory)) {
            update = true;
        }
        this.pumpOutputs(ctx);
        if (this.tryEmptyContainer((IFluidHandler)state.tanks.input, state.inventory)) {
            update = true;
        }
        if (update) {
            ctx.markMasterDirty();
            ctx.requestMasterBESync();
        }
    }

    private boolean tryEmptyContainer(IFluidHandler tank, IItemHandlerModifiable inv) {
        ItemStack filledContainer = inv.getStackInSlot(0);
        if (filledContainer.m_41619_()) {
            return false;
        }
        FluidActionResult simResult = FluidUtils.tryEmptyContainer((ItemStack)filledContainer, (IFluidHandler)tank, (int)1000, (IFluidHandler.FluidAction)IFluidHandler.FluidAction.SIMULATE);
        if (!simResult.isSuccess()) {
            return false;
        }
        ItemStack emptyContainer = simResult.getResult();
        ItemStack outputStack = inv.getStackInSlot(1);
        if (!outputStack.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)outputStack, (ItemStack)emptyContainer)) {
            return false;
        }
        if (outputStack.m_41613_() + emptyContainer.m_41613_() > emptyContainer.m_41741_()) {
            return false;
        }
        FluidActionResult execResult = FluidUtils.tryEmptyContainer((ItemStack)filledContainer, (IFluidHandler)tank, (int)1000, (IFluidHandler.FluidAction)IFluidHandler.FluidAction.EXECUTE);
        filledContainer.m_41774_(1);
        inv.setStackInSlot(0, filledContainer);
        if (outputStack.m_41619_()) {
            inv.setStackInSlot(1, execResult.getResult());
        } else {
            outputStack.m_41769_(execResult.getResult().m_41613_());
        }
        return true;
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        BlockPos localPos = position.posInMultiblock();
        RelativeBlockFace side = position.side();
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (FLUID_INPUT_POI.contains(localPos) && (side == null || side == FLUID_INPUT_FACING)) {
                return ((State)ctx.getState()).inputCap.cast(ctx);
            }
            if (FLUID_OUTPUT_POI.contains(localPos) && (side == null || side == FLUID_OUTPUT_FACING)) {
                return ((State)ctx.getState()).outputCap.cast(ctx);
            }
        } else if (cap == HeatCapabilities.HEAT_CONSUMER_CAPABILITY && HEAT_INPUT_POI.contains(localPos) && (side == null || side == HEAT_INPUT_FACING)) {
            return ((State)ctx.getState()).boilerInputCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        ITMultiBlockInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    public State createInitialState(IInitialMultiblockContext<State> ctx) {
        return new State(ctx);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return BoilerTankShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ITDisplayContext {
        public final BoilerTanks tanks;
        public StoredCapability<IFluidHandler> inputCap;
        public StoredCapability<IFluidHandler> outputCap;
        public StoredCapability<IHeatConsumer> boilerInputCap;
        public CapabilityReference<IFluidHandler> fluidOutput;
        public CapabilityReference<IHeatProvider> heatSource;
        public ITSlotwiseItemHandler inventory;
        public int recipeTimeRemaining = 0;
        public BoilerTankRecipe lastRecipe;
        public double heatLevel = 0.0;
        public boolean active = false;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            Runnable onChanged = () -> {
                markDirty.run();
                sync.run();
            };
            this.tanks = new BoilerTanks(v -> onChanged.run());
            this.inventory = new ITSlotwiseItemHandler(List.of(ITSlotwiseItemHandler.IOConstraint.FLUID_INPUT, ITSlotwiseItemHandler.IOConstraint.OUTPUT, ITSlotwiseItemHandler.IOConstraint.FLUID_INPUT, ITSlotwiseItemHandler.IOConstraint.OUTPUT), onChanged);
            this.inputCap = new StoredCapability((Object)new ITArrayFluidHandler((IFluidTank)this.tanks.input, false, true, onChanged));
            this.outputCap = new StoredCapability((Object)new ITArrayFluidHandler((IFluidTank)this.tanks.output, true, false, onChanged));
            this.boilerInputCap = new StoredCapability((Object)new BoilerInputImpl(this.tanks.input));
            MultiblockFace outputMBFace = new MultiblockFace(FLUID_OUTPUT_FACING, FLUID_OUTPUT_POI.get(0));
            CapabilityPosition opposingCP = CapabilityPosition.opposing((MultiblockFace)outputMBFace);
            MultiblockFace opposingMBFace = new MultiblockFace(opposingCP.side(), opposingCP.posInMultiblock());
            this.fluidOutput = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, opposingMBFace);
            MultiblockFace heatMBFace = new MultiblockFace(HEAT_INPUT_FACING, HEAT_INPUT_POI.get(0));
            CapabilityPosition heatOpposingCP = CapabilityPosition.opposing((MultiblockFace)heatMBFace);
            MultiblockFace heatOpposingMBFace = new MultiblockFace(heatOpposingCP.side(), heatOpposingCP.posInMultiblock());
            this.heatSource = ctx.getCapabilityAt(HeatCapabilities.HEAT_PROVIDER_CAPABILITY, heatOpposingMBFace);
        }

        public double getWorkingHeatLevel() {
            return this.lastRecipe != null ? this.lastRecipe.requiredHeat : 100.0;
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("tanks", (Tag)this.tanks.toNBT());
            nbt.m_128405_("recipeTimeRemaining", this.recipeTimeRemaining);
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.recipeTimeRemaining = nbt.m_128451_("recipeTimeRemaining");
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }

        public void writeSyncNBT(CompoundTag nbt) {
            CompoundTag display = new CompoundTag();
            this.writeDisplaySyncNBT(display);
            nbt.m_128365_("display", (Tag)display);
        }

        public void readSyncNBT(CompoundTag nbt) {
            if (nbt.m_128425_("display", 10)) {
                this.readDisplaySyncNBT(nbt.m_128469_("display"));
            }
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.inventory;
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return new IFluidTank[]{this.tanks.input, this.tanks.output};
        }

        @Override
        public void writeDisplaySyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
            nbt.m_128347_("heatLevel", this.heatLevel);
            nbt.m_128365_("tanks", (Tag)this.tanks.toNBT());
            nbt.m_128347_("workingHeatLevel", this.getWorkingHeatLevel());
        }

        @Override
        public void readDisplaySyncNBT(CompoundTag nbt) {
            this.active = nbt.m_128471_("active");
            this.heatLevel = nbt.m_128459_("heatLevel");
            this.tanks.readNBT(nbt.m_128469_("tanks"));
        }
    }

    public record BoilerTanks(ITMarkableFluidTank input, ITMarkableFluidTank output) {
        public BoilerTanks(Consumer<Void> markDirty) {
            this(new ITMarkableFluidTank(24000, markDirty), new ITMarkableFluidTank(24000, markDirty));
        }

        public static BoilerTanks makeClient() {
            return new BoilerTanks(v -> {});
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("input", (Tag)this.input.writeToNBT(new CompoundTag()));
            tag.m_128365_("output", (Tag)this.output.writeToNBT(new CompoundTag()));
            return tag;
        }

        public void readNBT(CompoundTag tag) {
            this.input.readFromNBT(tag.m_128469_("input"));
            this.output.readFromNBT(tag.m_128469_("output"));
        }

        public int getCapacity() {
            return 24000;
        }
    }

    private record BoilerInputImpl(ITMarkableFluidTank tank) implements IHeatConsumer
    {
        @Override
        public int getFluidAmount() {
            return this.tank.getFluidAmount();
        }
    }
}

