/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.logic;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import mctmods.immersivetechnology.api.HeatCapabilities;
import mctmods.immersivetechnology.api.capability.IHeatConsumer;
import mctmods.immersivetechnology.api.capability.IHeatProvider;
import mctmods.immersivetechnology.client.particles.ColoredSmoke;
import mctmods.immersivetechnology.common.fluids.helper.ITArrayFluidHandler;
import mctmods.immersivetechnology.common.fluids.helper.ITMarkableFluidTank;
import mctmods.immersivetechnology.common.multiblocks.helper.ITDisplayContext;
import mctmods.immersivetechnology.common.multiblocks.helper.ITMultiBlockInventoryUtils;
import mctmods.immersivetechnology.common.multiblocks.helper.ITSlotwiseItemHandler;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.BoilerLiquidRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.BoilerLiquidShape;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.core.lib.ITSound;
import mctmods.immersivetechnology.core.registration.ITSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class BoilerLiquidLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int INPUT_FUEL_SLOT_FILLED = 0;
    public static final int INPUT_FUEL_SLOT_EMPTY = 1;
    public static final int TANK_CAPACITY = 24000;
    private static final double HEAT_LOSS_PER_TICK = 0.2;
    public static final double DEFAULT_WORKING_HEAT_LEVEL = 100.0;
    public static final double PILOT_HEAT = 20.0;
    private static final List<PoIJSONSchema> RAW_POIS = ImmutableList.copyOf((Object[])BoilerLiquidShape.DATA.pointsOfInterest);
    public static final BlockPos REDSTONE_POI = BoilerLiquidLogic.getPosList("redstone").get(0);
    public static final List<BlockPos> IGNITION_POI = BoilerLiquidLogic.getPosList("ignition");
    public static final List<BlockPos> FLUID_INPUT_POI = BoilerLiquidLogic.getPosList("fluid_input");
    private static final List<BlockPos> HEAT_OUTPUT_POI = BoilerLiquidLogic.getPosList("heat_output");
    private static final List<BlockPos> SOUND_POI = BoilerLiquidLogic.getPosList("sound");
    private static final List<BlockPos> EXHAUST_POI = BoilerLiquidLogic.getPosList("exhaust");
    private static final RelativeBlockFace FLUID_INPUT_FACING = BoilerLiquidLogic.getFacing("fluid_input");
    private static final RelativeBlockFace HEAT_OUTPUT_FACING = BoilerLiquidLogic.getFacing("heat_output");
    public static final RelativeBlockFace IGNITION_FACING = BoilerLiquidLogic.getFacing("ignition");

    private static List<BlockPos> getPosList(String name) {
        return (List)RAW_POIS.stream().filter(poi -> poi.name.equals(name)).map(poi -> new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2])).collect(ImmutableList.toImmutableList());
    }

    private static RelativeBlockFace getFacing(String name) {
        List facings = RAW_POIS.stream().filter(poi -> poi.name.equals(name)).flatMap(poi -> poi.relativeFaces.stream()).distinct().toList();
        if (facings.size() != 1) {
            throw new RuntimeException("Inconsistent facings for POI: " + name);
        }
        return (RelativeBlockFace)facings.get(0);
    }

    public void tickClient(IMultiblockContext<State> ctx) {
        boolean hasWater;
        State state = (State)ctx.getState();
        BlockPos soundAbs = ctx.getLevel().toAbsolute(SOUND_POI.get(0));
        Vec3 soundPos = new Vec3((double)soundAbs.m_123341_() + 0.5, (double)soundAbs.m_123342_() + 0.5, (double)soundAbs.m_123343_() + 0.5);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        float attenuation = (float)Math.max(player.m_20238_(soundPos) / 8.0, 1.0);
        float currentLevel = (float)(state.heatLevel / state.getWorkingHeatLevel());
        float vol = 2.0f * currentLevel / attenuation;
        if (state.heatLevel > 0.0 && vol > 0.01f && !state.isSoundPlaying.getAsBoolean()) {
            state.isSoundPlaying = ITSound.startSound(() -> state.heatLevel > 0.0, ctx.isValid(), soundPos, ITSounds.boiler_liquid, () -> {
                LocalPlayer p = Minecraft.m_91087_().f_91074_;
                if (p == null) {
                    return Float.valueOf(0.0f);
                }
                float a = (float)Math.max(p.m_20238_(soundPos) / 8.0, 1.0);
                return Float.valueOf(2.0f * (float)(state.heatLevel / state.getWorkingHeatLevel()) / a);
            }, () -> Float.valueOf((float)(state.heatLevel / state.getWorkingHeatLevel())));
        }
        Level level = ctx.getLevel().getRawLevel();
        if (state.pilotLit) {
            BlockPos exhaustAbs = ctx.getLevel().toAbsolute(EXHAUST_POI.get(0));
            Vec3 flamePos = new Vec3((double)exhaustAbs.m_123341_() + 0.5, (double)exhaustAbs.m_123342_() + 0.1, (double)exhaustAbs.m_123343_() + 0.5);
            double velX = (double)level.f_46441_.m_188501_() * 0.0625 - 0.03125;
            double velY = 0.0625;
            double velZ = (double)level.f_46441_.m_188501_() * 0.0625 - 0.03125;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, flamePos.f_82479_, flamePos.f_82480_, flamePos.f_82481_, velX, velY, velZ);
        }
        boolean bl = hasWater = state.boilerInput.isPresent() && ((IHeatConsumer)state.boilerInput.get()).getFluidAmount() > 0;
        if (state.pilotLit && state.heatLevel > 20.0 && state.rsState.isEnabled(ctx) && hasWater) {
            BlockPos exhaustAbs = ctx.getLevel().toAbsolute(EXHAUST_POI.get(0));
            Vec3 smokePos = new Vec3((double)exhaustAbs.m_123341_() + 0.5, (double)exhaustAbs.m_123342_() + 1.25, (double)exhaustAbs.m_123343_() + 0.5);
            double velX = 0.0;
            double velY = 0.125;
            double velZ = 0.0;
            float r = 0.2f;
            float g = 0.2f;
            float b = 0.2f;
            level.m_7107_((ParticleOptions)new ColoredSmoke(r, g, b), smokePos.f_82479_, smokePos.f_82480_, smokePos.f_82481_, velX, velY, velZ);
        }
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        boolean update;
        boolean fullMode;
        State state = (State)ctx.getState();
        Level level = ctx.getLevel().getRawLevel();
        CompoundTag prevTanksNBT = state.tanks.toNBT();
        Tag prevInventoryNBT = state.inventory.serializeNBT();
        double prevHeatLevel = state.heatLevel;
        boolean prevPilotLit = state.pilotLit;
        boolean wasActive = state.active;
        if (state.tanks.input1.getFluidAmount() <= 0) {
            state.pilotLit = false;
        }
        double delta = 0.2;
        boolean hasWater = state.boilerInput.isPresent() && ((IHeatConsumer)state.boilerInput.get()).getFluidAmount() > 0;
        boolean bl = fullMode = state.rsState.isEnabled(ctx) && hasWater;
        if (!state.pilotLit) {
            state.heatLevel = Math.max(state.heatLevel - delta, 0.0);
            state.burnRemaining = 0;
        } else if (state.burnRemaining > 0) {
            --state.burnRemaining;
            if (state.lastFuel != null) {
                if (!fullMode) {
                    state.heatLevel = Math.max(state.heatLevel - delta, 20.0);
                }
            } else {
                state.burnRemaining = 0;
            }
        } else {
            state.lastFuel = null;
            if (state.tanks.input1.getFluidAmount() > 0) {
                FluidStack dummy = state.tanks.input1.getFluid().copy();
                dummy = new FluidStack(dummy, Integer.MAX_VALUE);
                state.lastFuel = BoilerLiquidRecipe.findRecipe(level, dummy);
            }
            if (state.lastFuel != null) {
                state.targetHeat = state.lastFuel.getTargetHeat();
                if (fullMode) {
                    int drainAmount = state.lastFuel.input.getAmount();
                    drained = state.tanks.input1.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                    if (drained.getAmount() == drainAmount) {
                        state.heatLevel = Math.min(state.heatLevel + state.lastFuel.getHeatPerTick(), state.targetHeat);
                    } else {
                        drained = state.tanks.input1.drain(1, IFluidHandler.FluidAction.EXECUTE);
                        if (drained.getAmount() >= 1) {
                            state.heatLevel = Math.max(state.heatLevel - delta, 20.0);
                        } else {
                            state.pilotLit = false;
                            state.heatLevel = Math.max(state.heatLevel - delta, 0.0);
                        }
                    }
                } else {
                    drained = state.tanks.input1.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    if (drained.getAmount() >= 1) {
                        state.heatLevel = Math.max(state.heatLevel - delta, 20.0);
                    } else {
                        state.pilotLit = false;
                        state.heatLevel = Math.max(state.heatLevel - delta, 0.0);
                    }
                }
                state.pilotLit = true;
            } else {
                state.pilotLit = false;
                state.heatLevel = Math.max(state.heatLevel - delta, 0.0);
            }
        }
        this.tryEmptyContainer((IFluidHandler)state.tanks.input1, state.inventory);
        state.active = state.pilotLit && fullMode && state.heatLevel >= state.getWorkingHeatLevel();
        boolean heatLevelChanged = prevHeatLevel != state.heatLevel;
        boolean pilotLitChanged = prevPilotLit != state.pilotLit;
        boolean activeChanged = wasActive != state.active;
        CompoundTag currentTanksNBT = state.tanks.toNBT();
        boolean tanksChanged = !prevTanksNBT.equals((Object)currentTanksNBT);
        Tag currentInventoryNBT = state.inventory.serializeNBT();
        boolean inventoryChanged = !prevInventoryNBT.equals(currentInventoryNBT);
        boolean bl2 = update = heatLevelChanged || pilotLitChanged || activeChanged || tanksChanged || inventoryChanged;
        if (update) {
            ctx.markMasterDirty();
            ctx.requestMasterBESync();
        }
    }

    private void tryEmptyContainer(IFluidHandler tank, IItemHandlerModifiable inv) {
        ItemStack filledContainer = inv.getStackInSlot(0);
        if (filledContainer.m_41619_()) {
            return;
        }
        FluidActionResult simResult = FluidUtils.tryEmptyContainer((ItemStack)filledContainer, (IFluidHandler)tank, (int)1000, (IFluidHandler.FluidAction)IFluidHandler.FluidAction.SIMULATE);
        if (!simResult.isSuccess()) {
            return;
        }
        ItemStack emptyContainer = simResult.getResult();
        ItemStack outputStack = inv.getStackInSlot(1);
        if (!outputStack.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)outputStack, (ItemStack)emptyContainer)) {
            return;
        }
        if (outputStack.m_41613_() + emptyContainer.m_41613_() > emptyContainer.m_41741_()) {
            return;
        }
        FluidActionResult execResult = FluidUtils.tryEmptyContainer((ItemStack)filledContainer, (IFluidHandler)tank, (int)1000, (IFluidHandler.FluidAction)IFluidHandler.FluidAction.EXECUTE);
        filledContainer.m_41774_(1);
        inv.setStackInSlot(0, filledContainer);
        if (outputStack.m_41619_()) {
            inv.setStackInSlot(1, execResult.getResult());
        } else {
            outputStack.m_41769_(execResult.getResult().m_41613_());
        }
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        BlockPos localPos = position.posInMultiblock();
        RelativeBlockFace side = position.side();
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (FLUID_INPUT_POI.contains(localPos) && (side == null || side == FLUID_INPUT_FACING)) {
                return ((State)ctx.getState()).inputFuelCap.cast(ctx);
            }
        } else if (cap == HeatCapabilities.HEAT_PROVIDER_CAPABILITY && HEAT_OUTPUT_POI.contains(localPos) && (side == null || side == HEAT_OUTPUT_FACING)) {
            return ((State)ctx.getState()).heatSourceCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        ITMultiBlockInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    public State createInitialState(IInitialMultiblockContext<State> ctx) {
        return new State(ctx);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return BoilerLiquidShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ITDisplayContext {
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final BoilerTank tanks;
        public StoredCapability<IFluidHandler> inputFuelCap;
        public StoredCapability<IHeatProvider> heatSourceCap;
        public CapabilityReference<IHeatConsumer> boilerInput;
        public ITSlotwiseItemHandler inventory;
        public double heatLevel = 0.0;
        public int burnRemaining = 0;
        public BoilerLiquidRecipe lastFuel;
        public double targetHeat = 100.0;
        public boolean pilotLit = false;
        public boolean active = false;
        public BooleanSupplier isSoundPlaying = () -> false;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            Runnable onChanged = () -> {
                markDirty.run();
                sync.run();
            };
            this.tanks = new BoilerTank(v -> onChanged.run());
            this.inventory = new ITSlotwiseItemHandler(List.of(ITSlotwiseItemHandler.IOConstraint.FLUID_INPUT, ITSlotwiseItemHandler.IOConstraint.OUTPUT), onChanged);
            this.inputFuelCap = new StoredCapability((Object)new ITArrayFluidHandler((IFluidTank)this.tanks.input1, false, true, onChanged));
            this.heatSourceCap = new StoredCapability((Object)new HeatSourceImpl(this));
            MultiblockFace heatMBFace = new MultiblockFace(HEAT_OUTPUT_FACING, HEAT_OUTPUT_POI.get(0));
            CapabilityPosition opposingCP = CapabilityPosition.opposing((MultiblockFace)heatMBFace);
            MultiblockFace opposingMBFace = new MultiblockFace(opposingCP.side(), opposingCP.posInMultiblock());
            this.boilerInput = ctx.getCapabilityAt(HeatCapabilities.HEAT_CONSUMER_CAPABILITY, opposingMBFace);
        }

        public double getWorkingHeatLevel() {
            return this.lastFuel != null ? this.lastFuel.getTargetHeat() : 100.0;
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("tanks", (Tag)this.tanks.toNBT());
            nbt.m_128347_("heatLevel", this.heatLevel);
            nbt.m_128405_("burnRemaining", this.burnRemaining);
            nbt.m_128379_("pilotLit", this.pilotLit);
            nbt.m_128347_("targetHeat", this.targetHeat);
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.heatLevel = nbt.m_128459_("heatLevel");
            this.burnRemaining = nbt.m_128451_("burnRemaining");
            this.pilotLit = nbt.m_128471_("pilotLit");
            this.targetHeat = nbt.m_128459_("targetHeat");
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }

        public void writeSyncNBT(CompoundTag nbt) {
            CompoundTag display = new CompoundTag();
            this.writeDisplaySyncNBT(display);
            nbt.m_128365_("display", (Tag)display);
        }

        public void readSyncNBT(CompoundTag nbt) {
            if (nbt.m_128425_("display", 10)) {
                this.readDisplaySyncNBT(nbt.m_128469_("display"));
            }
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.inventory;
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return new IFluidTank[]{this.tanks.input1};
        }

        @Override
        public void writeDisplaySyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
            nbt.m_128347_("heatLevel", this.heatLevel);
            nbt.m_128379_("pilotLit", this.pilotLit);
            nbt.m_128365_("tanks", (Tag)this.tanks.toNBT());
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128347_("workingHeatLevel", this.getWorkingHeatLevel());
        }

        @Override
        public void readDisplaySyncNBT(CompoundTag nbt) {
            this.active = nbt.m_128471_("active");
            this.heatLevel = nbt.m_128459_("heatLevel");
            this.pilotLit = nbt.m_128471_("pilotLit");
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }
    }

    public record BoilerTank(ITMarkableFluidTank input1) {
        public BoilerTank(Consumer<Void> markDirty) {
            this(new ITMarkableFluidTank(24000, markDirty));
        }

        public static BoilerTank makeClient() {
            return new BoilerTank(v -> {});
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("input1", (Tag)this.input1.writeToNBT(new CompoundTag()));
            return tag;
        }

        public void readNBT(CompoundTag tag) {
            this.input1.readFromNBT(tag.m_128469_("input1"));
        }

        public int getCapacity() {
            return 24000;
        }
    }

    private record HeatSourceImpl(State state) implements IHeatProvider
    {
        @Override
        public double getHeatLevel() {
            return this.state.heatLevel;
        }
    }
}

