/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.logic;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import mctmods.immersivetechnology.api.MechanicalCapabilities;
import mctmods.immersivetechnology.api.capability.IMechanicalEnergyConsumer;
import mctmods.immersivetechnology.api.capability.IMechanicalEnergyProvider;
import mctmods.immersivetechnology.common.multiblocks.helper.ITDisplayContext;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.AlternatorShape;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.core.lib.ITLib;
import mctmods.immersivetechnology.core.lib.ITSound;
import mctmods.immersivetechnology.core.registration.ITSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class AlternatorLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int ENERGY_CAPACITY = 1200000;
    private static final double BASE_MASS = 2.0;
    private static final double FRICTION = 0.0;
    private static final int MAX_OUTPUT = 12288;
    private static final int MAX_SPEED = 7200;
    private static final List<PoIJSONSchema> RAW_POIS = ImmutableList.copyOf((Object[])AlternatorShape.DATA.pointsOfInterest);
    public static final BlockPos RUNNING_SOUND_POI = AlternatorLogic.getPosList("running_sound").get(0);
    public static final BlockPos ROTATIONAL_INPUT_POI = AlternatorLogic.getPosList("rotational_input").get(0);
    private static final List<BlockPos> ENERGY_LEFT_POI = AlternatorLogic.getPosList("energy_left");
    private static final List<BlockPos> ENERGY_RIGHT_POI = AlternatorLogic.getPosList("energy_right");
    private static final RelativeBlockFace ENERGY_LEFT_FACING = AlternatorLogic.getFacing("energy_left");
    private static final RelativeBlockFace ENERGY_RIGHT_FACING = AlternatorLogic.getFacing("energy_right");
    private static final RelativeBlockFace ROTATIONAL_INPUT_FACING = AlternatorLogic.getFacing("rotational_input");

    private static List<BlockPos> getPosList(String name) {
        return (List)RAW_POIS.stream().filter(poi -> poi.name.equals(name)).map(poi -> new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2])).collect(ImmutableList.toImmutableList());
    }

    private static RelativeBlockFace getFacing(String name) {
        List facings = RAW_POIS.stream().filter(poi -> poi.name.equals(name)).flatMap(poi -> poi.relativeFaces.stream()).distinct().toList();
        if (facings.size() != 1) {
            throw new RuntimeException("Inconsistent facings for POI: " + name);
        }
        return (RelativeBlockFace)facings.get(0);
    }

    public void tickClient(IMultiblockContext<State> ctx) {
        State state = (State)ctx.getState();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Vec3 soundPos = ctx.getLevel().toAbsolute(new Vec3((double)RUNNING_SOUND_POI.m_123341_() + 0.5, (double)RUNNING_SOUND_POI.m_123342_() + 0.5, (double)RUNNING_SOUND_POI.m_123343_() + 0.5));
        float att = (float)Math.max(player.m_20238_(soundPos) / 32.0, 1.0);
        float vol = 11.0f / att;
        if (state.active && vol > 0.01f && !state.isSoundPlaying.getAsBoolean()) {
            state.isSoundPlaying = ITSound.startSound(() -> state.active, ctx.isValid(), soundPos, ITSounds.alternator, () -> {
                LocalPlayer p = Minecraft.m_91087_().f_91074_;
                if (p == null) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(11.0f / (float)Math.max(p.m_20238_(soundPos) / 32.0, 1.0));
            }, () -> Float.valueOf(ITLib.remapRange(0.0f, state.effectiveMaxSpeed, 0.5f, 1.25f, state.speed)));
        }
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        boolean update;
        int effectiveMax;
        LazyOptional providerCap;
        State state = (State)ctx.getState();
        Level level = ctx.getLevel().getRawLevel();
        state.energy.updateAverage();
        int prevEnergy = state.energy.getEnergyStored();
        int prevSpeed = state.speed;
        float prevTorque = state.torqueMultiplier;
        boolean wasActive = state.active;
        state.active = false;
        int turbineSpeed = 0;
        float turbineTorque = 1.0f;
        boolean hasProvider = false;
        int providerMaxSpeed = 7200;
        Direction inputFacing = ctx.getLevel().toAbsolute(ROTATIONAL_INPUT_FACING);
        BlockPos inputPortAbs = ctx.getLevel().toAbsolute(ROTATIONAL_INPUT_POI);
        assert (inputFacing != null);
        BlockPos providerAbsolutePos = inputPortAbs.m_121945_(inputFacing);
        BlockEntity entity = level.m_7702_(providerAbsolutePos);
        if (entity != null && (providerCap = entity.getCapability(MechanicalCapabilities.MECHANICAL_PROVIDER_CAPABILITY, inputFacing.m_122424_())).isPresent()) {
            IMechanicalEnergyProvider provider = (IMechanicalEnergyProvider)providerCap.orElseThrow(RuntimeException::new);
            turbineSpeed = provider.getSpeed();
            turbineTorque = provider.getTorque();
            providerMaxSpeed = provider.getMaxSpeed();
            hasProvider = true;
            if (turbineSpeed > 0) {
                state.active = true;
            }
        }
        state.effectiveMaxSpeed = effectiveMax = hasProvider ? Math.min(7200, providerMaxSpeed) : 7200;
        if (hasProvider) {
            state.speed = Math.min(turbineSpeed, effectiveMax);
            state.torqueMultiplier = turbineTorque;
        } else if (state.speed > 0) {
            state.speed = Math.max(state.speed - 6, 0);
            if (state.speed > 0) {
                state.active = true;
            }
        }
        this.generateAndPushEnergy(state, ctx, level);
        boolean activeChanged = wasActive != state.active;
        boolean speedChanged = prevSpeed != state.speed;
        boolean torqueChanged = prevTorque != state.torqueMultiplier;
        int currentEnergy = state.energy.getEnergyStored();
        boolean energyChanged = prevEnergy != currentEnergy;
        boolean bl = update = activeChanged || speedChanged || torqueChanged || energyChanged;
        if (update) {
            ctx.markMasterDirty();
            ctx.requestMasterBESync();
        }
    }

    private void generateAndPushEnergy(State state, IMultiblockContext<State> ctx, Level level) {
        double ratio = (double)state.speed / 7200.0;
        int generatedThisTick = (int)Math.round(ratio * (double)state.torqueMultiplier * 12288.0);
        List<IEnergyStorage> connected = this.getConnectedHandlers(ctx, level);
        if (connected.isEmpty()) {
            state.energy.receiveEnergy(generatedThisTick, false);
            return;
        }
        int pushed = this.distributeFluxProper(connected, generatedThisTick);
        state.energy.receiveEnergy(generatedThisTick - pushed, false);
    }

    private int distributeFluxProper(List<IEnergyStorage> storages, int amount) {
        if (storages.isEmpty()) {
            return amount;
        }
        List<Pair> pairs = storages.stream().filter(Objects::nonNull).map(storage -> Pair.of((Object)storage, (Object)storage.receiveEnergy(amount, true))).sorted(Comparator.comparingInt(Pair::getSecond)).toList();
        int remaining = amount;
        int remainingOutputs = pairs.size();
        for (Pair pair : pairs) {
            IEnergyStorage storage2 = (IEnergyStorage)pair.getFirst();
            if (remaining <= 0) break;
            int possibleOutput = (int)Math.ceil((double)remaining / (double)remainingOutputs);
            int inserted = storage2.receiveEnergy(possibleOutput, false);
            remaining -= inserted;
            --remainingOutputs;
        }
        return amount - remaining;
    }

    private List<IEnergyStorage> getConnectedHandlers(IMultiblockContext<State> ctx, Level level) {
        LazyOptional handlerOpt;
        BlockEntity adjacent;
        Direction side;
        BlockPos absolutePos;
        ArrayList<IEnergyStorage> connected = new ArrayList<IEnergyStorage>();
        for (BlockPos pos : ENERGY_LEFT_POI) {
            absolutePos = ctx.getLevel().toAbsolute(pos);
            side = ctx.getLevel().toAbsolute(ENERGY_LEFT_FACING);
            assert (side != null);
            adjacent = level.m_7702_(absolutePos.m_121945_(side));
            if (adjacent == null || !(handlerOpt = adjacent.getCapability(ForgeCapabilities.ENERGY, side.m_122424_())).isPresent()) continue;
            connected.add((IEnergyStorage)handlerOpt.orElseThrow(RuntimeException::new));
        }
        for (BlockPos pos : ENERGY_RIGHT_POI) {
            absolutePos = ctx.getLevel().toAbsolute(pos);
            side = ctx.getLevel().toAbsolute(ENERGY_RIGHT_FACING);
            assert (side != null);
            adjacent = level.m_7702_(absolutePos.m_121945_(side));
            if (adjacent == null || !(handlerOpt = adjacent.getCapability(ForgeCapabilities.ENERGY, side.m_122424_())).isPresent()) continue;
            connected.add((IEnergyStorage)handlerOpt.orElseThrow(RuntimeException::new));
        }
        return connected;
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY) {
            BlockPos localPos = position.posInMultiblock();
            RelativeBlockFace side = position.side();
            if (ENERGY_LEFT_POI.contains(localPos) && (side == null || side == ENERGY_LEFT_FACING)) {
                return state.energyCap.cast(ctx);
            }
            if (ENERGY_RIGHT_POI.contains(localPos) && (side == null || side == ENERGY_RIGHT_FACING)) {
                return state.energyCap.cast(ctx);
            }
        }
        if (cap == MechanicalCapabilities.MECHANICAL_CONSUMER_CAPABILITY) {
            CapabilityPosition checkPos = position;
            if (position.posInMultiblock().equals((Object)BlockPos.f_121853_)) {
                checkPos = new CapabilityPosition(ROTATIONAL_INPUT_POI, position.side());
            }
            if (checkPos.posInMultiblock().equals((Object)ROTATIONAL_INPUT_POI) && (checkPos.side() == null || checkPos.side() == ROTATIONAL_INPUT_FACING || checkPos.side() == ROTATIONAL_INPUT_FACING.getOpposite())) {
                return LazyOptional.of(MechanicalEnergyConsumer::new).cast();
            }
        }
        return LazyOptional.empty();
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
    }

    public State createInitialState(IInitialMultiblockContext<State> ctx) {
        return new State(ctx);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return AlternatorShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ITDisplayContext {
        public AveragingEnergyStorage energy;
        public boolean active = false;
        public int speed = 0;
        public float torqueMultiplier = 1.0f;
        public int effectiveMaxSpeed = 7200;
        public BooleanSupplier isSoundPlaying = () -> false;
        private final StoredCapability<IEnergyStorage> energyCap;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            Runnable onChanged = () -> {
                markDirty.run();
                sync.run();
            };
            this.energy = new SyncEnergyStorage(1200000, onChanged);
            this.energyCap = new StoredCapability((Object)this.energy);
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128379_("active", this.active);
            nbt.m_128405_("speed", this.speed);
            nbt.m_128350_("torqueMultiplier", this.torqueMultiplier);
            nbt.m_128405_("effectiveMaxSpeed", this.effectiveMaxSpeed);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.active = nbt.m_128471_("active");
            this.speed = nbt.m_128451_("speed");
            this.torqueMultiplier = nbt.m_128457_("torqueMultiplier");
            this.effectiveMaxSpeed = nbt.m_128451_("effectiveMaxSpeed");
        }

        public void writeSyncNBT(CompoundTag nbt) {
            CompoundTag display = new CompoundTag();
            this.writeDisplaySyncNBT(display);
            nbt.m_128365_("display", (Tag)display);
        }

        public void readSyncNBT(CompoundTag nbt) {
            if (nbt.m_128425_("display", 10)) {
                this.readDisplaySyncNBT(nbt.m_128469_("display"));
            }
        }

        @Override
        public void writeDisplaySyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
            nbt.m_128405_("speed", this.speed);
            nbt.m_128350_("torqueMultiplier", this.torqueMultiplier);
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128405_("effectiveMaxSpeed", this.effectiveMaxSpeed);
        }

        @Override
        public void readDisplaySyncNBT(CompoundTag nbt) {
            this.active = nbt.m_128471_("active");
            this.speed = nbt.m_128451_("speed");
            this.torqueMultiplier = nbt.m_128457_("torqueMultiplier");
            if (this.energy == null) {
                this.energy = new SyncEnergyStorage(1200000, () -> {});
            }
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.effectiveMaxSpeed = nbt.m_128451_("effectiveMaxSpeed");
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }
    }

    private static class SyncEnergyStorage
    extends AveragingEnergyStorage {
        private final Runnable onChanged;

        public SyncEnergyStorage(int capacity, Runnable onChanged) {
            super(capacity);
            this.onChanged = onChanged;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (received > 0 && !simulate) {
                this.onChanged.run();
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (extracted > 0 && !simulate) {
                this.onChanged.run();
            }
            return extracted;
        }

        public void setStoredEnergy(int energy) {
            int prev = this.getEnergyStored();
            super.setStoredEnergy(energy);
            if (energy != prev && this.onChanged != null) {
                this.onChanged.run();
            }
        }
    }

    private static class MechanicalEnergyConsumer
    implements IMechanicalEnergyConsumer {
        private MechanicalEnergyConsumer() {
        }

        @Override
        public double getMass() {
            return 2.0;
        }

        @Override
        public double getFriction() {
            return 0.0;
        }

        @Override
        public int getMaxSpeed() {
            return 7200;
        }
    }
}

