/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.gui;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.common.gui.helper.ITContainerMenu;
import mctmods.immersivetechnology.common.gui.helper.ITGenericContainerData;
import mctmods.immersivetechnology.common.multiblocks.gui.helper.ITSlot;
import mctmods.immersivetechnology.common.multiblocks.helper.ITSlotwiseItemHandler;
import mctmods.immersivetechnology.common.multiblocks.metal.interfaces.ITISolarMultiblockState;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SolarTowerLogic;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;

public class SolarMenu
extends ITContainerMenu {
    public final SimpleContainerData state;
    public final FluidTank inputTank;
    public FluidTank outputTank;
    private final Supplier<ITISolarMultiblockState> mbStateSupplier;

    public static SolarMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, ITContainerMenu.MultiblockMenuContext<? extends ITISolarMultiblockState> ctx) {
        ITISolarMultiblockState state = (ITISolarMultiblockState)ctx.mbContext().getState();
        return new SolarMenu(SolarMenu.multiblockCtx(type, id, ctx), invPlayer, (IItemHandler)state.getInventory(), state.getTanks().input(), state.getTanks().output(), () -> state);
    }

    public static SolarMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new SolarMenu(SolarMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ITSlotwiseItemHandler(List.of(ITSlotwiseItemHandler.IOConstraint.FLUID_INPUT, ITSlotwiseItemHandler.IOConstraint.OUTPUT, ITSlotwiseItemHandler.IOConstraint.FLUID_INPUT, ITSlotwiseItemHandler.IOConstraint.OUTPUT), () -> {}), new FluidTank(12000), new FluidTank(12000), () -> null);
    }

    private SolarMenu(ITContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler inv, FluidTank input, FluidTank output, Supplier<ITISolarMultiblockState> mbStateSupplier) {
        super(ctx);
        int i;
        this.inputTank = input;
        this.outputTank = output;
        this.mbStateSupplier = mbStateSupplier;
        this.state = new SimpleContainerData(8);
        this.m_38897_((Slot)new ITSlot.FluidContainer(inv, 0, 80, 17, 1){

            @Override
            public boolean m_5857_(@Nonnull ItemStack itemStack) {
                FluidStack fs = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(null);
                if (fs == null) {
                    return false;
                }
                return SolarMenu.this.inputTank.getFluidAmount() <= 0 || fs.isFluidEqual(SolarMenu.this.inputTank.getFluid());
            }
        });
        this.m_38897_((Slot)new ITSlot.Output(inv, 1, 80, 53));
        this.m_38897_((Slot)new ITSlot.FluidContainer(inv, 2, 148, 17, 0){

            @Override
            public boolean m_5857_(@Nonnull ItemStack itemStack) {
                return itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
            }
        });
        this.m_38897_((Slot)new ITSlot.Output(inv, 3, 148, 53));
        this.ownSlotCount = 4;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 142));
        }
        this.m_38884_((ContainerData)this.state);
        this.addGenericData(ITGenericContainerData.fluid(this.inputTank));
        this.addGenericData(ITGenericContainerData.fluid(this.outputTank));
    }

    @Override
    public void m_38946_() {
        if (this.mbStateSupplier != null) {
            ITISolarMultiblockState s = this.mbStateSupplier.get();
            this.state.m_8050_(0, (int)s.getHeatLevel());
            if (!this.usingPlayers.isEmpty()) {
                this.state.m_8050_(1, SolarTowerLogic.getSolarIncidenceAngleSection(((ServerPlayer)this.usingPlayers.get(0)).m_9236_()));
            }
            this.state.m_8050_(2, (int)s.getDirCounts()[0]);
            this.state.m_8050_(3, (int)s.getDirCounts()[1]);
            this.state.m_8050_(4, (int)s.getDirCounts()[2]);
            this.state.m_8050_(5, (int)s.getDirCounts()[3]);
            this.state.m_8050_(6, s.getProcessProgress());
            this.state.m_8050_(7, s.isSunVisible() ? 1 : 0);
        }
        super.m_38946_();
    }
}

