/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.common.blocks.helper.ITBlockInterfaces;
import mctmods.immersivetechnology.common.util.ITAdvancements;
import mctmods.immersivetechnology.common.util.ITRotationUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FormationTool
extends Item {
    public FormationTool() {
        super(new Item.Properties());
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack pStack) {
        return Component.m_237115_((String)this.m_5671_(pStack));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addInfo(tooltip, "desc.immersiveengineering.info.multiblocksAllowed", stack, "multiblockPermission");
        this.addInfo(tooltip, "desc.immersiveengineering.info.multiblockForbidden", stack, "multiblockInterdiction");
    }

    private void addInfo(List<Component> list, String titleKey, ItemStack stack, String nbtKey) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)nbtKey, (int)9)) {
            return;
        }
        MutableComponent title = Component.m_237115_((String)titleKey);
        ListTag tagList = stack.m_41784_().m_128437_(nbtKey, 8);
        if (!Screen.m_96638_()) {
            list.add((Component)title.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"desc.immersiveengineering.info.holdShift")));
        } else {
            list.add((Component)title);
            for (int i = 0; i < tagList.size(); ++i) {
                MultiblockHandler.IMultiblock multiblock;
                ResourceLocation mbName = ResourceLocation.m_135820_((String)tagList.m_128778_(i));
                if (mbName == null || (multiblock = MultiblockHandler.getByUniqueName((ResourceLocation)mbName)) == null) continue;
                list.add((Component)TextUtils.applyFormat((Component)multiblock.getDisplayName(), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
            }
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        boolean rotate;
        ListTag list;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Direction side = context.m_43719_();
        List<ResourceLocation> permittedMultiblocks = null;
        List<ResourceLocation> interdictedMultiblocks = null;
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblockPermission") && (permittedMultiblocks = FormationTool.parseMultiblockNames(list = stack.m_41784_().m_128437_("multiblockPermission", 8), player, "permission")) == null) {
            return InteractionResult.FAIL;
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblockInterdiction") && (interdictedMultiblocks = FormationTool.parseMultiblockNames(list = stack.m_41784_().m_128437_("multiblockInterdiction", 8), player, "interdiction")) == null) {
            return InteractionResult.FAIL;
        }
        Direction multiblockSide = side.m_122434_() == Direction.Axis.Y && player != null ? Direction.m_122364_((double)player.m_146908_()).m_122424_() : side;
        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
            boolean formed;
            boolean isAllowed;
            if (!mb.isBlockTrigger(world.m_8055_(pos), multiblockSide, world) || !(isAllowed = permittedMultiblocks != null ? permittedMultiblocks.contains(mb.getUniqueName()) : (interdictedMultiblocks != null ? !interdictedMultiblocks.contains(mb.getUniqueName()) : true)) || MultiblockHandler.postMultiblockFormationEvent((Player)player, (MultiblockHandler.IMultiblock)mb, (BlockPos)pos, (ItemStack)stack).isCanceled() || !(formed = mb.createStructure(world, pos, multiblockSide, player))) continue;
            if (player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                ITAdvancements.TRIGGER_MULTIBLOCK.trigger(sPlayer, mb, stack);
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ITBlockInterfaces.IConfigurableSides) {
            Direction activeSide;
            ITBlockInterfaces.IConfigurableSides sideConfig = (ITBlockInterfaces.IConfigurableSides)tile;
            Direction direction = activeSide = player != null && player.m_6144_() ? side.m_122424_() : side;
            assert (player != null);
            if (sideConfig.toggleSide(activeSide, player)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        boolean bl = rotate = !(tile instanceof ITBlockInterfaces.IDirectionalBE) && !(tile instanceof ITBlockInterfaces.IHammerInteraction);
        if (!rotate && tile instanceof ITBlockInterfaces.IDirectionalBE) {
            ITBlockInterfaces.IDirectionalBE dirBE = (ITBlockInterfaces.IDirectionalBE)tile;
            assert (player != null);
            rotate = dirBE.canHammerRotate(side, context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)pos)), (LivingEntity)player);
        }
        if (rotate && ITRotationUtil.rotateBlock(world, pos, player != null && player.m_6144_() != side.equals((Object)Direction.DOWN))) {
            return InteractionResult.SUCCESS;
        }
        if (!rotate && tile instanceof ITBlockInterfaces.IHammerInteraction) {
            ITBlockInterfaces.IHammerInteraction hammerInteraction = (ITBlockInterfaces.IHammerInteraction)tile;
            assert (player != null);
            if (hammerInteraction.hammerUseSide(side, player, context.m_43724_(), context.m_43720_())) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    private static List<ResourceLocation> parseMultiblockNames(ListTag data, @Nullable Player player, String prefix) {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        for (int i = 0; i < data.size(); ++i) {
            String listEntry = data.m_128778_(i);
            ResourceLocation asRL = ResourceLocation.m_135820_((String)listEntry);
            if (asRL == null || MultiblockHandler.getByUniqueName((ResourceLocation)asRL) == null) {
                if (player != null && !player.m_20193_().f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)("Invalid " + prefix + " entry: " + listEntry)), false);
                }
                return null;
            }
            result.add(asRL);
        }
        return result;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        if (!player.m_9236_().f_46443_ && ITRotationUtil.rotateEntity((Entity)entity)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean hasCraftingRemainingItem(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(@NotNull ItemStack stack) {
        ItemStack container = stack.m_41777_();
        if (container.m_220157_(1, ApiUtils.RANDOM_SOURCE, null)) {
            return ItemStack.f_41583_;
        }
        return container;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }
}

