/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.integration.jei.category;

import java.util.List;
import mctmods.immersivetechnology.client.gui.helper.ITFluidInfoArea;
import mctmods.immersivetechnology.common.integration.jei.JEIRecipeTypes;
import mctmods.immersivetechnology.common.integration.jei.category.ITRecipeCategory;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.DistillerRecipe;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.lib.ITLib;
import mctmods.immersivetechnology.core.registration.ITMultiblockProvider;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ITDistillerCategory
extends ITRecipeCategory<DistillerRecipe> {
    private final IDrawableStatic tankOverlay;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic slotDrawable;

    public ITDistillerCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.DISTILLER, "block.immersivetechnology.distiller");
        ResourceLocation background = ITLib.makeTextureLocation("distiller");
        this.setBackground(helper.createDrawable(background, 0, 0, 176, 74));
        this.setIcon(ITMultiblockProvider.DISTILLER.iconStack());
        this.tankOverlay = helper.createDrawable(background, 176, 31, 20, 51);
        this.arrow = helper.drawableBuilder(background, 176, 14, 24, 17).buildAnimated(20, IDrawableAnimated.StartDirection.LEFT, false);
        this.slotDrawable = helper.getSlotDrawable();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DistillerRecipe recipe, @NotNull IFocusGroup focuses) {
        List<FluidStack> inputs = recipe.input.getMatchingFluidStacks().stream().map(fs -> {
            FluidStack copy = fs.copy();
            copy.setAmount(recipe.input.getAmount());
            return copy;
        }).toList();
        IRecipeSlotBuilder inputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 59, 21).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, inputs)).setFluidRenderer((long)recipe.input.getAmount(), false, 16, 47);
        inputSlot.addRichTooltipCallback((slotView, tooltip) -> slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fs -> ITFluidInfoArea.fillTooltip(fs, recipe.input.getAmount(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0))));
        if (recipe.fluidOutput != null) {
            IRecipeSlotBuilder outputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 21).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.fluidOutput)).setFluidRenderer((long)recipe.fluidOutput.getAmount(), false, 16, 47);
            outputSlot.addRichTooltipCallback((slotView, tooltip) -> slotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fs -> ITFluidInfoArea.fillTooltip(fs, fs.getAmount(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0))));
        }
        if (!recipe.itemOutput.m_41619_()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 88, 25).addItemStack(recipe.itemOutput)).setBackground((IDrawable)this.slotDrawable, -1, -1);
        }
    }

    public void draw(@NotNull DistillerRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        this.tankOverlay.draw(graphics, 56, 19);
        if (recipe.fluidOutput != null) {
            this.tankOverlay.draw(graphics, 112, 19);
        }
        this.arrow.draw(graphics, 85, 25);
        if (!recipe.itemOutput.m_41619_()) {
            String chanceStr = String.format("%.2f%%", Float.valueOf(recipe.chance * 100.0f));
            MutableComponent component = Component.m_237110_((String)TranslationKey.CATEGORY_DISTILLER_CHANCE.getLocation(), (Object[])new Object[]{chanceStr}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA)));
            Font font = Minecraft.m_91087_().f_91062_;
            int textWidth = font.m_92852_((FormattedText)component);
            int textX = 85 + (24 - textWidth) / 2;
            graphics.m_280614_(font, (Component)component, textX, 8, 0xAAAAAA, true);
        }
    }
}

