/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.integration.jei.category;

import java.util.Arrays;
import java.util.List;
import mctmods.immersivetechnology.common.integration.jei.JEIRecipeTypes;
import mctmods.immersivetechnology.common.integration.jei.category.ITRecipeCategory;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.BoilerSolidRecipe;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.ITCommonConfig;
import mctmods.immersivetechnology.core.lib.ITLib;
import mctmods.immersivetechnology.core.registration.ITMultiblockProvider;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class ITBoilerSolidCategory
extends ITRecipeCategory<BoilerSolidRecipe> {
    public ITBoilerSolidCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.BOILER_SOLID, "block.immersivetechnology.boiler_solid");
        ResourceLocation background = ITLib.makeTextureLocation("boiler_solid");
        IDrawableStatic back = this.guiHelper.drawableBuilder(background, 0, 0, 176, 74).setTextureSize(256, 256).build();
        this.setBackground(back);
        this.setIcon(ITMultiblockProvider.BOILER_SOLID.iconStack());
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull BoilerSolidRecipe recipe, @NotNull IFocusGroup focuses) {
        List<ItemStack> inputs = Arrays.stream(recipe.input.getMatchingStacks()).map(stack -> {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(recipe.input.getCount());
            return copy;
        }).toList();
        builder.addSlot(RecipeIngredientRole.INPUT, 81, 36).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputs);
    }

    public void draw(@NotNull BoilerSolidRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        int divider = ITCommonConfig.burnTimeDivider;
        ItemStack singleStack = recipe.input.getMatchingStacks()[0].m_41777_();
        singleStack.m_41764_(1);
        int burnTimePerItem = ForgeHooks.getBurnTime((ItemStack)singleStack, null);
        if (burnTimePerItem <= 0) {
            burnTimePerItem = 200;
        }
        int totalBurnTime = burnTimePerItem * recipe.input.getCount();
        int effectiveTime = totalBurnTime / divider;
        double effectiveHeat = recipe.getHeatPerTick() * (double)divider;
        MutableComponent timeComponent = Component.m_237110_((String)TranslationKey.CATEGORY_BOILER_SOLID_TIME.getLocation(), (Object[])new Object[]{effectiveTime, recipe.input.getCount()}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA)));
        int timeWidth = font.m_92852_((FormattedText)timeComponent);
        int timeX = 90 - timeWidth / 2;
        guiGraphics.m_280614_(font, (Component)timeComponent, timeX, 0, 0xAAAAAA, true);
        MutableComponent heatComponent = Component.m_237110_((String)TranslationKey.CATEGORY_BOILER_SOLID_HEAT.getLocation(), (Object[])new Object[]{String.format("%.2f", effectiveHeat)}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA)));
        int heatWidth = font.m_92852_((FormattedText)heatComponent);
        int heatX = 90 - heatWidth / 2;
        guiGraphics.m_280614_(font, (Component)heatComponent, heatX, 9, 0xAAAAAA, true);
    }
}

