/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.gui.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeFriendlyByteBuf;
import net.minecraftforge.fluids.FluidStack;

public class ITGenericDataSerializers {
    private static final List<DataSerializer<?>> SERIALIZERS = new ArrayList();
    public static final DataSerializer<Integer> INT32 = ITGenericDataSerializers.register(FriendlyByteBuf::m_130242_, FriendlyByteBuf::m_130130_);
    public static final DataSerializer<FluidStack> FLUID_STACK = ITGenericDataSerializers.register(IForgeFriendlyByteBuf::readFluidStack, IForgeFriendlyByteBuf::writeFluidStack, FluidStack::copy, FluidStack::isFluidStackIdentical);
    public static final DataSerializer<Float> FLOAT = ITGenericDataSerializers.register(FriendlyByteBuf::readFloat, FriendlyByteBuf::writeFloat);
    public static final DataSerializer<Double> DOUBLE = ITGenericDataSerializers.register(FriendlyByteBuf::readDouble, FriendlyByteBuf::writeDouble);
    public static final DataSerializer<ItemStack> ITEM_STACK = ITGenericDataSerializers.register(FriendlyByteBuf::m_130267_, FriendlyByteBuf::m_130055_, ItemStack::m_41777_, Object::equals);

    private static <T> DataSerializer<T> register(Function<FriendlyByteBuf, T> read, BiConsumer<FriendlyByteBuf, T> write) {
        return ITGenericDataSerializers.register(read, write, t -> t, Objects::equals);
    }

    private static <T> DataSerializer<T> register(Function<FriendlyByteBuf, T> read, BiConsumer<FriendlyByteBuf, T> write, UnaryOperator<T> copy, BiPredicate<T, T> equals) {
        DataSerializer<T> serializer = new DataSerializer<T>(read, write, copy, equals, SERIALIZERS.size());
        SERIALIZERS.add(serializer);
        return serializer;
    }

    public static DataPair<?> read(FriendlyByteBuf buffer) {
        DataSerializer<?> serializer = SERIALIZERS.get(buffer.m_130242_());
        return serializer.read(buffer);
    }

    public record DataSerializer<T>(Function<FriendlyByteBuf, T> read, BiConsumer<FriendlyByteBuf, T> write, UnaryOperator<T> copy, BiPredicate<T, T> equals, int id) {
        public DataPair<T> read(FriendlyByteBuf from) {
            return new DataPair<T>(this, this.read().apply(from));
        }
    }

    public record DataPair<T>(DataSerializer<T> serializer, T data) {
        public void write(FriendlyByteBuf to) {
            to.m_130130_(this.serializer.id());
            this.serializer.write().accept(to, (FriendlyByteBuf)this.data);
        }
    }
}

