/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.gui.helper;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.common.blocks.helper.ITBaseBlockEntity;
import mctmods.immersivetechnology.common.gui.helper.ITGenericContainerData;
import mctmods.immersivetechnology.common.gui.helper.ITGenericDataSerializers;
import mctmods.immersivetechnology.common.multiblocks.gui.helper.ITSlot;
import mctmods.immersivetechnology.common.network.ITMessageContainerData;
import mctmods.immersivetechnology.common.network.ITPacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="immersivetechnology", bus=Mod.EventBusSubscriber.Bus.FORGE)
public abstract class ITContainerMenu
extends AbstractContainerMenu {
    protected final List<ITGenericContainerData<?>> genericData = new ArrayList();
    protected final List<ServerPlayer> usingPlayers = new ArrayList<ServerPlayer>();
    private final Runnable setChanged;
    private final Predicate<Player> isValid;
    public int ownSlotCount;

    protected ITContainerMenu(MenuContext ctx) {
        super(ctx.type, ctx.id);
        this.setChanged = ctx.setChanged;
        this.isValid = ctx.isValid;
    }

    public void addGenericData(ITGenericContainerData<?> newData) {
        this.genericData.add(newData);
    }

    public void m_38946_() {
        super.m_38946_();
        ArrayList toSync = new ArrayList();
        for (int i = 0; i < this.genericData.size(); ++i) {
            ITGenericContainerData<?> data = this.genericData.get(i);
            if (!data.needsUpdate()) continue;
            toSync.add(Pair.of((Object)i, data.dataPair()));
        }
        if (!toSync.isEmpty()) {
            for (ServerPlayer player : this.usingPlayers) {
                ITPacketHandler.sendToPlayer((Player)player, new ITMessageContainerData(toSync));
            }
        }
    }

    public void receiveSync(List<Pair<Integer, ITGenericDataSerializers.DataPair<?>>> synced) {
        for (Pair<Integer, ITGenericDataSerializers.DataPair<?>> syncElement : synced) {
            this.genericData.get((Integer)syncElement.getFirst()).processSync(((ITGenericDataSerializers.DataPair)syncElement.getSecond()).data());
        }
    }

    public void m_150399_(int id, int dragType, @NotNull ClickType clickType, @NotNull Player player) {
        Slot slot;
        Slot slot2 = slot = id < 0 ? null : (Slot)this.f_38839_.get(id);
        if (!(slot instanceof ITSlot.ItemHandlerGhost)) {
            super.m_150399_(id, dragType, clickType, player);
            return;
        }
        ItemStack stackSlot = slot.m_7993_();
        if (dragType == 2) {
            slot.m_5852_(ItemStack.f_41583_);
        } else if (dragType == 0 || dragType == 1) {
            ItemStack stackHeld = this.m_142621_();
            int amount = Math.min(slot.m_6641_(), stackHeld.m_41613_());
            if (dragType == 1) {
                amount = 1;
            }
            if (stackSlot.m_41619_()) {
                if (!stackHeld.m_41619_() && slot.m_5857_(stackHeld)) {
                    slot.m_5852_(ItemHandlerHelper.copyStackWithSize((ItemStack)stackHeld, (int)amount));
                }
            } else if (stackHeld.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else if (slot.m_5857_(stackHeld)) {
                if (ItemStack.m_41656_((ItemStack)stackSlot, (ItemStack)stackHeld)) {
                    stackSlot.m_41769_(amount);
                    slot.m_5852_(stackSlot);
                } else {
                    slot.m_5852_(ItemHandlerHelper.copyStackWithSize((ItemStack)stackHeld, (int)amount));
                }
            }
            if (stackSlot.m_41613_() > slot.m_6641_()) {
                stackSlot.m_41764_(slot.m_6641_());
            }
        } else if (dragType == 5) {
            ItemStack stackHeld = this.m_142621_();
            int amount = Math.min(slot.m_6641_(), stackHeld.m_41613_());
            if (!slot.m_6657_()) {
                slot.m_5852_(ItemHandlerHelper.copyStackWithSize((ItemStack)stackHeld, (int)amount));
            }
        }
    }

    @Nonnull
    public ItemStack m_7648_(@NotNull Player player, int slot) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slotObject = (Slot)this.f_38839_.get(slot);
        if (slotObject.m_6657_()) {
            ItemStack itemStack1 = slotObject.m_7993_();
            itemStack = itemStack1.m_41777_();
            if (slot < this.ownSlotCount ? !this.m_38903_(itemStack1, this.ownSlotCount, this.f_38839_.size(), true) : !this.moveItemStackToWithMayPlace(itemStack1, this.ownSlotCount)) {
                return ItemStack.f_41583_;
            }
            if (itemStack1.m_41619_()) {
                slotObject.m_5852_(ItemStack.f_41583_);
            } else {
                slotObject.m_6654_();
            }
        }
        return itemStack;
    }

    protected boolean moveItemStackToWithMayPlace(ItemStack pStack, int pEndIndex) {
        return ITContainerMenu.moveItemStackToWithMayPlace((List<Slot>)this.f_38839_, (x$0, x$1, x$2, x$3) -> this.m_38903_(x$0, x$1, x$2, x$3), pStack, 0, pEndIndex);
    }

    public static boolean moveItemStackToWithMayPlace(List<Slot> slots, MoveItemsFunc move, ItemStack pStack, int pStartIndex, int pEndIndex) {
        boolean inAllowedRange = true;
        int allowedStart = pStartIndex;
        for (int i = pStartIndex; i < pEndIndex; ++i) {
            boolean mayPlace = slots.get(i).m_5857_(pStack);
            if (inAllowedRange && !mayPlace) {
                if (move.moveItemStackTo(pStack, allowedStart, i, false)) {
                    return true;
                }
                inAllowedRange = false;
                continue;
            }
            if (inAllowedRange || !mayPlace) continue;
            allowedStart = i;
            inAllowedRange = true;
        }
        return inAllowedRange && move.moveItemStackTo(pStack, allowedStart, pEndIndex, false);
    }

    public void receiveMessageFromScreen(CompoundTag nbt) {
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.setChanged.run();
    }

    public boolean m_6875_(@Nonnull Player pPlayer) {
        return this.isValid.test(pPlayer);
    }

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open ev) {
        AbstractContainerMenu abstractContainerMenu = ev.getContainer();
        if (abstractContainerMenu instanceof ITContainerMenu) {
            ITContainerMenu itContainer = (ITContainerMenu)abstractContainerMenu;
            abstractContainerMenu = ev.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                itContainer.usingPlayers.add(serverPlayer);
                ArrayList list = new ArrayList();
                for (int i = 0; i < itContainer.genericData.size(); ++i) {
                    list.add(Pair.of((Object)i, itContainer.genericData.get(i).dataPair()));
                }
                ITPacketHandler.sendToPlayer((Player)serverPlayer, new ITMessageContainerData(list));
            }
        }
    }

    @SubscribeEvent
    public static void onContainerClosed(PlayerContainerEvent.Close ev) {
        AbstractContainerMenu abstractContainerMenu = ev.getContainer();
        if (abstractContainerMenu instanceof ITContainerMenu) {
            ITContainerMenu itContainer = (ITContainerMenu)abstractContainerMenu;
            abstractContainerMenu = ev.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                itContainer.usingPlayers.remove(serverPlayer);
            }
        }
    }

    public static MenuContext multiblockCtx(MenuType<?> pMenuType, int pContainerId, MultiblockMenuContext<?> ctx) {
        return new MenuContext(pMenuType, pContainerId, () -> ctx.mbContext().markMasterDirty(), p -> {
            if (!ctx.mbContext().isValid().getAsBoolean()) {
                return false;
            }
            return p.m_20238_(Vec3.m_82512_((Vec3i)ctx.clickedPos)) <= 64.0;
        });
    }

    public static MenuContext blockCtx(MenuType<?> pMenuType, int pContainerId, BlockEntity be) {
        return new MenuContext(pMenuType, pContainerId, () -> {
            be.m_6596_();
            if (be instanceof ITBaseBlockEntity) {
                ITBaseBlockEntity itBE = (ITBaseBlockEntity)be;
                itBE.markContainingBlockForUpdate(null);
            }
        }, p -> {
            BlockPos pos = be.m_58899_();
            Level level = be.m_58904_();
            if (level == null || level.m_7702_(pos) != be) {
                return false;
            }
            return !(p.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) > 64.0);
        });
    }

    public static MenuContext clientCtx(MenuType<?> pMenuType, int pContainerId) {
        return new MenuContext(pMenuType, pContainerId, () -> {}, $ -> true);
    }

    public record MenuContext(MenuType<?> type, int id, Runnable setChanged, Predicate<Player> isValid) {
    }

    public static interface MoveItemsFunc {
        public boolean moveItemStackTo(ItemStack var1, int var2, int var3, boolean var4);
    }

    public record MultiblockMenuContext<S extends IMultiblockState>(IMultiblockContext<S> mbContext, BlockPos clickedPos) {
    }
}

