/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.fluids;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.core.registration.ITFluids;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class ITFluidBlock
extends LiquidBlock {
    private static ITFluids.FluidEntry entryStatic;
    private final ITFluids.FluidEntry entry;
    @Nullable
    private MobEffect effect;
    private int duration;
    private int level;

    public ITFluidBlock(ITFluids.FluidEntry entry, BlockBehaviour.Properties props) {
        super(entry.getStillGetter(), (BlockBehaviour.Properties)Util.m_137469_((Object)props, $ -> {
            entryStatic = entry;
        }));
        this.entry = entry;
        entryStatic = null;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        for (Property<?> p : (this.entry == null ? entryStatic : this.entry).properties()) {
            builder.m_61104_(new Property[]{p});
        }
    }

    @Nonnull
    public FluidState m_5888_(@Nonnull BlockState state) {
        FluidState baseState = super.m_5888_(state);
        for (Property prop : baseState.m_61147_()) {
            if (!state.m_61138_(prop)) continue;
            baseState = ITFluidBlock.withCopiedValue(prop, baseState, state);
        }
        return baseState;
    }

    public static <T extends StateHolder<?, T>, S extends Comparable<S>> T withCopiedValue(Property<S> prop, T oldState, StateHolder<?, ?> copyFrom) {
        return (T)((StateHolder)oldState.m_61124_(prop, copyFrom.m_61143_(prop)));
    }

    public void setEffect(@Nonnull MobEffect effect, int duration, int level) {
        this.effect = effect;
        this.duration = duration;
        this.level = level;
    }

    public void m_7892_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        if (this.effect != null && entityIn instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entityIn;
            living.m_7292_(new MobEffectInstance(this.effect, this.duration, this.level));
        }
    }
}

