/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.fluids;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.common.fluids.ITFluidBlock;
import mctmods.immersivetechnology.core.registration.ITFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class ITFluid
extends FlowingFluid {
    private static ITFluids.FluidEntry entryStatic;
    protected final ITFluids.FluidEntry entry;
    private static final int CACHE_SIZE = 200;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>> OCCLUSION_CACHE;
    public static final DispenseItemBehavior BUCKET_DISPENSE_BEHAVIOR;

    public static ITFluid makeFluid(Function<ITFluids.FluidEntry, ? extends ITFluid> make, ITFluids.FluidEntry entry) {
        entryStatic = entry;
        ITFluid result = make.apply(entry);
        entryStatic = null;
        return result;
    }

    public ITFluid(ITFluids.FluidEntry entry) {
        this.entry = entry;
    }

    protected boolean isGaseous() {
        return this.getFluidType().getDensity() < 0;
    }

    @Nonnull
    public Item m_6859_() {
        return this.entry.getBucket();
    }

    protected boolean m_5486_(@NotNull FluidState fluidState, @NotNull BlockGetter blockReader, @NotNull BlockPos pos, @NotNull Fluid fluidIn, @NotNull Direction direction) {
        return (this.isGaseous() ? direction == Direction.UP : direction == Direction.DOWN) && !this.m_6212_(fluidIn);
    }

    public boolean m_6212_(@Nonnull Fluid fluidIn) {
        return fluidIn == this.entry.getStill() || fluidIn == this.entry.getFlowing();
    }

    public int m_6718_(@NotNull LevelReader p_205569_1_) {
        int dW = this.m_5615_().getFluidType().getViscosity() - Fluids.f_76193_.getFluidType().getViscosity();
        double v = Math.round(5.0 + (double)dW * 0.005);
        return Math.max(2, (int)v);
    }

    protected float m_6752_() {
        return 100.0f;
    }

    protected void m_7180_(@NotNull StateDefinition.Builder<Fluid, FluidState> builder) {
        super.m_7180_(builder);
        for (Property<?> p : (this.entry == null ? entryStatic : this.entry).properties()) {
            builder.m_61104_(new Property[]{p});
        }
    }

    @NotNull
    protected BlockState m_5804_(@NotNull FluidState state) {
        BlockState result = (BlockState)this.entry.getBlock().m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(ITFluid.m_76092_((FluidState)state)));
        for (Property<?> prop : this.entry.properties()) {
            result = ITFluidBlock.withCopiedValue(prop, result, state);
        }
        return result;
    }

    public boolean m_7444_(FluidState state) {
        return state.m_76152_() == this.entry.getStill();
    }

    public int m_7430_(@NotNull FluidState state) {
        if (this.m_7444_(state)) {
            return 8;
        }
        return (Integer)state.m_61143_((Property)f_75948_);
    }

    @NotNull
    public FluidType getFluidType() {
        return (FluidType)this.entry.type().get();
    }

    @Nonnull
    public Fluid m_5615_() {
        return this.entry.getFlowing();
    }

    @Nonnull
    public Fluid m_5613_() {
        return this.entry.getStill();
    }

    public boolean m_6760_(@NotNull Level level) {
        return false;
    }

    protected void m_7456_(@NotNull LevelAccessor iWorld, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
    }

    protected int m_6719_(@NotNull LevelReader iWorldReader) {
        return 4;
    }

    protected int m_6713_(@NotNull LevelReader iWorldReader) {
        return 1;
    }

    public void m_6292_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull FluidState pState) {
        super.m_6292_(pLevel, pPos, pState);
        if (!pLevel.f_46443_ && this.isGaseous() && pState.m_76170_()) {
            pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    protected void m_76010_(@NotNull Level pLevel, @NotNull BlockPos pPos, FluidState pState) {
        if (!pState.m_76178_()) {
            BlockState blockstate = pLevel.m_8055_(pPos);
            Direction gravityDir = this.isGaseous() ? Direction.UP : Direction.DOWN;
            BlockPos blockpos = pPos.m_121945_(gravityDir);
            BlockState blockState = pLevel.m_8055_(blockpos);
            FluidState fluidState = this.m_76035_(pLevel, blockpos, blockState);
            if (this.m_75977_((BlockGetter)pLevel, pPos, blockstate, gravityDir, blockpos, blockState, pLevel.m_6425_(blockpos), fluidState.m_76152_())) {
                this.m_6364_((LevelAccessor)pLevel, blockpos, blockState, gravityDir, fluidState);
                if (this.mySourceNeighborCount((LevelReader)pLevel, pPos) >= 3) {
                    this.mySpreadToSides(pLevel, pPos, pState, blockstate);
                }
            } else if (pState.m_76170_() || !this.myIsHole((BlockGetter)pLevel, fluidState.m_76152_(), pPos, blockstate, blockpos, blockState)) {
                this.mySpreadToSides(pLevel, pPos, pState, blockstate);
            }
        }
    }

    private void mySpreadToSides(Level pLevel, BlockPos pPos, FluidState pFluidState, BlockState pBlockState) {
        int i = pFluidState.m_76186_() - this.m_6713_((LevelReader)pLevel);
        if (((Boolean)pFluidState.m_61143_((Property)f_75947_)).booleanValue()) {
            i = 7;
        }
        if (i > 0) {
            Map<Direction, FluidState> map = this.m_76079_(pLevel, pPos, pBlockState);
            for (Map.Entry<Direction, FluidState> entry : map.entrySet()) {
                Direction direction = entry.getKey();
                FluidState fluidstate = entry.getValue();
                BlockPos blockpos = pPos.m_121945_(direction);
                BlockState blockstate = pLevel.m_8055_(blockpos);
                if (!this.myCanPassThrough((BlockGetter)pLevel, fluidstate.m_76152_(), pPos, pBlockState, direction, blockpos, blockstate, pLevel.m_6425_(blockpos))) continue;
                this.m_6364_((LevelAccessor)pLevel, blockpos, blockstate, direction, fluidstate);
            }
        }
    }

    @NotNull
    protected FluidState m_76035_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        BlockPos blockPos;
        BlockState blockState2;
        FluidState fluidState2;
        boolean isGaseous = this.isGaseous();
        Direction gravityDir = isGaseous ? Direction.UP : Direction.DOWN;
        Direction antiGravityDir = isGaseous ? Direction.DOWN : Direction.UP;
        int i = 0;
        int j = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pPos.m_121945_(direction);
            BlockState blockstate = pLevel.m_8055_(blockpos);
            FluidState fluidstate = blockstate.m_60819_();
            if (!fluidstate.m_76152_().m_6212_((Fluid)this) || !this.myCanPassThroughWall(direction, (BlockGetter)pLevel, pPos, pBlockState, blockpos, blockstate)) continue;
            if (fluidstate.m_76170_() && ForgeEventFactory.canCreateFluidSource((Level)pLevel, (BlockPos)blockpos, (BlockState)blockstate, (boolean)fluidstate.canConvertToSource(pLevel, blockpos))) {
                ++j;
            }
            i = Math.max(i, fluidstate.m_76186_());
        }
        if (j >= 2) {
            boolean isSolid;
            BlockPos floorPos = pPos.m_121945_(gravityDir);
            BlockState blockState1 = pLevel.m_8055_(floorPos);
            FluidState fluidState1 = blockState1.m_60819_();
            VoxelShape shape = blockState1.m_60742_((BlockGetter)pLevel, floorPos, CollisionContext.m_82749_());
            boolean bl = isSolid = !shape.m_83281_() && (shape.m_83215_().m_82309_() >= 0.7291666666666666 || shape.m_83215_().m_82376_() >= 1.0);
            if (isSolid || this.myIsSourceBlockOfThisType(fluidState1)) {
                return this.m_76068_(false);
            }
        }
        if (!(fluidState2 = (blockState2 = pLevel.m_8055_(blockPos = pPos.m_121945_(antiGravityDir))).m_60819_()).m_76178_() && fluidState2.m_76152_().m_6212_((Fluid)this) && this.myCanPassThroughWall(antiGravityDir, (BlockGetter)pLevel, pPos, pBlockState, blockPos, blockState2)) {
            return this.m_75953_(8, true);
        }
        int k = i - this.m_6713_((LevelReader)pLevel);
        return k <= 0 ? Fluids.f_76191_.m_76145_() : this.m_75953_(k, false);
    }

    @NotNull
    public Vec3 m_7000_(@NotNull BlockGetter pBlockReader, @NotNull BlockPos pPos, @NotNull FluidState pFluidState) {
        double d0 = 0.0;
        double d1 = 0.0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.m_122159_((Vec3i)pPos, direction);
            FluidState fluidstate = pBlockReader.m_6425_((BlockPos)mutable);
            if (!this.myAffectsFlow(fluidstate)) continue;
            float f = fluidstate.m_76182_();
            float f1 = 0.0f;
            if (f == 0.0f) {
                BlockPos blockpos;
                FluidState fluidState1;
                boolean passable;
                BlockState state = pBlockReader.m_8055_((BlockPos)mutable);
                VoxelShape shape = state.m_60742_(pBlockReader, (BlockPos)mutable, CollisionContext.m_82749_());
                boolean bl = passable = shape.m_83281_() || (shape.m_83215_().m_82362_() + shape.m_83215_().m_82376_() + shape.m_83215_().m_82385_()) / 3.0 < 0.7291666666666666 && shape.m_83215_().m_82376_() < 1.0;
                if ((state.m_60734_() == Blocks.f_50033_ || state.m_60734_() == Blocks.f_50570_ || passable) && this.myAffectsFlow(fluidState1 = pBlockReader.m_6425_(blockpos = mutable.m_7495_())) && (f = fluidState1.m_76182_()) > 0.0f) {
                    f1 = pFluidState.m_76182_() - (f - 0.8888889f);
                }
            } else if (f > 0.0f) {
                f1 = pFluidState.m_76182_() - f;
            }
            if (f1 == 0.0f) continue;
            d0 += (double)((float)direction.m_122429_() * f1);
            d1 += (double)((float)direction.m_122431_() * f1);
        }
        Vec3 vec3 = new Vec3(d0, 0.0, d1);
        if (((Boolean)pFluidState.m_61143_((Property)f_75947_)).booleanValue()) {
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                Direction checkOffset;
                mutable.m_122159_((Vec3i)pPos, direction1);
                Direction direction = checkOffset = this.isGaseous() ? Direction.DOWN : Direction.UP;
                if (!this.m_75990_(pBlockReader, (BlockPos)mutable, direction1) && !this.m_75990_(pBlockReader, mutable.m_121945_(checkOffset), direction1)) continue;
                double yAdd = this.isGaseous() ? 6.0 : -6.0;
                vec3 = vec3.m_82541_().m_82520_(0.0, yAdd, 0.0);
                break;
            }
        }
        return vec3.m_82541_();
    }

    private boolean myAffectsFlow(FluidState pState) {
        return pState.m_76178_() || pState.m_76152_().m_6212_((Fluid)this);
    }

    private int mySourceNeighborCount(LevelReader pLevel, BlockPos pPos) {
        int i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pPos.m_121945_(direction);
            FluidState fluidstate = pLevel.m_6425_(blockpos);
            if (!this.myIsSourceBlockOfThisType(fluidstate)) continue;
            ++i;
        }
        return i;
    }

    private boolean myIsHole(BlockGetter pLevel, Fluid pFluid, BlockPos pPos, BlockState pState, BlockPos pTargetPos, BlockState pTargetState) {
        Direction dir;
        Direction direction = dir = this.isGaseous() ? Direction.UP : Direction.DOWN;
        if (!this.myCanPassThroughWall(dir, pLevel, pPos, pState, pTargetPos, pTargetState)) {
            return false;
        }
        return pTargetState.m_60819_().m_76152_().m_6212_((Fluid)this) || this.myCanHoldFluid(pLevel, pTargetPos, pTargetState, pFluid);
    }

    private boolean myCanHoldFluid(BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        Block block = pState.m_60734_();
        if (block instanceof LiquidBlockContainer) {
            return ((LiquidBlockContainer)block).m_6044_(pLevel, pPos, pState, pFluid);
        }
        if (!(block instanceof DoorBlock || pState.m_204336_(BlockTags.f_13068_) || pState.m_60713_(Blocks.f_50155_) || pState.m_60713_(Blocks.f_50130_) || pState.m_60713_(Blocks.f_50628_))) {
            if (!(pState.m_60713_(Blocks.f_50142_) || pState.m_60713_(Blocks.f_50257_) || pState.m_60713_(Blocks.f_50446_) || pState.m_60713_(Blocks.f_50454_))) {
                AABB aabb;
                VoxelShape shape = pState.m_60742_(pLevel, pPos, CollisionContext.m_82749_());
                boolean isSolid = shape.m_83281_() ? false : (aabb = shape.m_83215_()).m_82309_() >= 0.7291666666666666 || aabb.m_82376_() >= 1.0;
                return pState.m_60713_(Blocks.f_50033_) || pState.m_60713_(Blocks.f_50570_) || !isSolid;
            }
            return false;
        }
        return false;
    }

    private boolean myIsSourceBlockOfThisType(FluidState pState) {
        return pState.m_76152_().m_6212_((Fluid)this) && pState.m_76170_();
    }

    private boolean myCanPassThrough(BlockGetter pLevel, Fluid pFluid, BlockPos pPos, BlockState pState, Direction pDirection, BlockPos pTargetPos, BlockState pTargetState, FluidState pTargetFluid) {
        return !this.myIsSourceBlockOfThisType(pTargetFluid) && this.myCanPassThroughWall(pDirection, pLevel, pPos, pState, pTargetPos, pTargetState) && this.myCanHoldFluid(pLevel, pTargetPos, pTargetState, pFluid);
    }

    private int myGetSlopeDistance(LevelReader pLevel, BlockPos pPos, int pDist, Direction pOppositeDir, BlockState pState, BlockPos pOrigin, Short2ObjectMap<Pair<BlockState, FluidState>> pStateCache, Short2BooleanMap pHoleCache) {
        int i = 1000;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int j;
            if (direction == pOppositeDir) continue;
            BlockPos blockpos = pPos.m_121945_(direction);
            short short1 = ITFluid.myGetCacheKey(pOrigin, blockpos);
            Pair pair = (Pair)pStateCache.computeIfAbsent(short1, k -> {
                BlockState blockState1 = pLevel.m_8055_(blockpos);
                return Pair.of((Object)blockState1, (Object)blockState1.m_60819_());
            });
            BlockState blockstate = (BlockState)pair.getFirst();
            FluidState fluidstate = (FluidState)pair.getSecond();
            if (!this.myCanPassThrough((BlockGetter)pLevel, this.m_5615_(), pPos, pState, direction, blockpos, blockstate, fluidstate)) continue;
            boolean flag = pHoleCache.computeIfAbsent(short1, k -> {
                BlockPos blockPos1 = blockpos.m_121945_(this.isGaseous() ? Direction.UP : Direction.DOWN);
                BlockState blockState1 = pLevel.m_8055_(blockPos1);
                return this.myIsHole((BlockGetter)pLevel, this.m_5615_(), blockpos, blockstate, blockPos1, blockState1);
            });
            if (flag) {
                return pDist;
            }
            if (pDist >= this.m_6719_(pLevel) || (j = this.myGetSlopeDistance(pLevel, blockpos, pDist + 1, direction.m_122424_(), blockstate, pOrigin, pStateCache, pHoleCache)) >= i) continue;
            i = j;
        }
        return i;
    }

    @NotNull
    protected Map<Direction, FluidState> m_76079_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        int i = 1000;
        EnumMap map = Maps.newEnumMap(Direction.class);
        Short2ObjectOpenHashMap short2objectmap = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap short2booleanmap = new Short2BooleanOpenHashMap();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pPos.m_121945_(direction);
            short short1 = ITFluid.myGetCacheKey(pPos, blockpos);
            Pair pair = (Pair)short2objectmap.computeIfAbsent(short1, k -> {
                BlockState blockState1 = pLevel.m_8055_(blockpos);
                return Pair.of((Object)blockState1, (Object)blockState1.m_60819_());
            });
            BlockState blockState = (BlockState)pair.getFirst();
            FluidState fluidstate = (FluidState)pair.getSecond();
            FluidState fluidState1 = this.m_76035_(pLevel, blockpos, blockState);
            if (!this.myCanPassThrough((BlockGetter)pLevel, fluidState1.m_76152_(), pPos, pState, direction, blockpos, blockState, fluidstate)) continue;
            boolean flag = short2booleanmap.computeIfAbsent(short1, k -> {
                BlockPos blockPos1 = blockpos.m_121945_(this.isGaseous() ? Direction.UP : Direction.DOWN);
                BlockState blockState1 = pLevel.m_8055_(blockPos1);
                return this.myIsHole((BlockGetter)pLevel, this.m_5615_(), blockpos, blockState, blockPos1, blockState1);
            });
            int j = flag ? 0 : this.myGetSlopeDistance((LevelReader)pLevel, blockpos, 1, direction.m_122424_(), blockState, pPos, (Short2ObjectMap<Pair<BlockState, FluidState>>)short2objectmap, (Short2BooleanMap)short2booleanmap);
            if (j < i) {
                map.clear();
            }
            if (j > i) continue;
            map.put(direction, fluidState1);
            i = j;
        }
        return map;
    }

    private boolean myCanPassThroughWall(Direction pDirection, BlockGetter pLevel, BlockPos pPos, BlockState pState, BlockPos pTargetPos, BlockState pTargetState) {
        VoxelShape voxelShape2;
        VoxelShape voxelShape1;
        boolean flag;
        Block.BlockStatePairKey key;
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> cache = !pState.m_60734_().m_49967_() && !pTargetState.m_60734_().m_49967_() ? OCCLUSION_CACHE.get() : null;
        if (cache != null) {
            key = new Block.BlockStatePairKey(pState, pTargetState, pDirection);
            byte b0 = cache.getAndMoveToFirst((Object)key);
            if (b0 != 127) {
                return b0 != 0;
            }
        } else {
            key = null;
        }
        boolean bl = flag = !Shapes.m_83152_((VoxelShape)(voxelShape1 = pState.m_60812_(pLevel, pPos)), (VoxelShape)(voxelShape2 = pTargetState.m_60812_(pLevel, pTargetPos)), (Direction)pDirection);
        if (cache != null) {
            if (cache.size() == 200) {
                cache.removeLastByte();
            }
            cache.putAndMoveToFirst((Object)key, (byte)(flag ? 1 : 0));
        }
        return flag;
    }

    private static short myGetCacheKey(BlockPos pPos, BlockPos pTargetPos) {
        int i = pTargetPos.m_123341_() - pPos.m_123341_();
        int j = pTargetPos.m_123343_() - pPos.m_123343_();
        return (short)((i + 128 & 0xFF) << 8 | j + 128 & 0xFF);
    }

    static {
        OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
            Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> map = new Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>(200){

                protected void rehash(int p_76102_) {
                }
            };
            map.defaultReturnValue((byte)127);
            return map;
        });
        BUCKET_DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

            @NotNull
            public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                BucketItem bucketitem = (BucketItem)stack.m_41720_();
                BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel world = source.m_7727_();
                if (bucketitem.emptyContents(null, (Level)world, blockpos, null, stack)) {
                    bucketitem.m_142131_(null, (Level)world, stack, blockpos);
                    FluidState placedState = world.m_6425_(blockpos);
                    if (placedState.m_76152_().getFluidType().getDensity() < 0) {
                        world.m_186469_(blockpos, placedState.m_76152_(), 100);
                    }
                    return new ItemStack((ItemLike)Items.f_42446_);
                }
                return this.defaultBehavior.m_6115_(source, stack);
            }
        };
    }

    public static class Flowing
    extends ITFluid {
        public Flowing(ITFluids.FluidEntry entry) {
            super(entry);
        }

        @Override
        protected void m_7180_(@NotNull StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }
    }
}

