/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.wooden.gui;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import mctmods.immersivetechnology.common.blocks.wooden.logic.CrateCreativeBlockEntity;
import mctmods.immersivetechnology.common.gui.helper.ITContainerMenu;
import mctmods.immersivetechnology.common.gui.helper.ITGenericContainerData;
import mctmods.immersivetechnology.common.gui.helper.ITGenericDataSerializers;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class CrateCreativeMenu
extends ITContainerMenu {
    private final IItemHandlerModifiable handler;
    private final CrateCreativeBlockEntity tile;

    public CrateCreativeMenu(MenuType<CrateCreativeMenu> type, int id, Inventory inv, CrateCreativeBlockEntity tile) {
        super(ITContainerMenu.blockCtx(type, id, tile));
        this.handler = tile;
        this.tile = tile;
        this.addGenericData(ITGenericContainerData.itemStack(() -> this.handler.getStackInSlot(0), stack -> this.handler.setStackInSlot(0, stack)));
        this.addOwnSlots();
        this.addPlayerSlots(inv);
    }

    public CrateCreativeMenu(MenuType<CrateCreativeMenu> type, int id, Inventory inv) {
        super(ITContainerMenu.clientCtx(type, id));
        this.handler = new DummyHandler();
        this.tile = null;
        this.addGenericData(ITGenericContainerData.itemStack(() -> this.handler.getStackInSlot(0), stack -> this.handler.setStackInSlot(0, stack)));
        this.addOwnSlots();
        this.addPlayerSlots(inv);
    }

    public static CrateCreativeMenu makeServer(MenuType<CrateCreativeMenu> type, int id, Inventory inv, CrateCreativeBlockEntity tile) {
        return new CrateCreativeMenu(type, id, inv, tile);
    }

    public static CrateCreativeMenu makeClient(MenuType<CrateCreativeMenu> type, int id, Inventory inv) {
        return new CrateCreativeMenu(type, id, inv);
    }

    private void addOwnSlots() {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.handler, 0, 79, 36));
        this.ownSlotCount = 1;
    }

    private void addPlayerSlots(Inventory inv) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inv, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inv, x, 8 + x * 18, 142));
        }
    }

    @Override
    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack1 = slot.m_7993_();
        if (pIndex != 0) {
            this.handler.setStackInSlot(0, itemStack1.m_41777_());
            slot.m_5852_(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_6875_(@NotNull Player player) {
        return this.tile == null || this.tile.stillValid(player);
    }

    @Override
    public void receiveSync(List<Pair<Integer, ITGenericDataSerializers.DataPair<?>>> synced) {
        super.receiveSync(synced);
    }

    @Override
    public void m_150399_(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        if (slotId == 0) {
            ItemStack temp;
            ItemStack carried = this.m_142621_();
            if (clickType == ClickType.PICKUP) {
                if (!carried.m_41619_()) {
                    this.handler.setStackInSlot(0, carried.m_41777_());
                    this.m_142503_(ItemStack.f_41583_);
                } else if (!this.handler.getStackInSlot(0).m_41619_()) {
                    int amount = button == 0 ? this.handler.getStackInSlot(0).m_41741_() : 1;
                    ItemStack extracted = this.handler.extractItem(0, amount, false);
                    this.m_142503_(extracted);
                }
            } else if (clickType == ClickType.QUICK_MOVE) {
                ItemStack temp2;
                if (carried.m_41619_() && !(temp2 = this.handler.getStackInSlot(0)).m_41619_()) {
                    int amount = temp2.m_41741_();
                    ItemStack extracted = this.handler.extractItem(0, amount, false);
                    this.m_38903_(extracted, 1, this.f_38839_.size(), true);
                    if (!extracted.m_41619_()) {
                        player.m_36176_(extracted, false);
                    }
                }
            } else if (clickType == ClickType.CLONE && player.m_150110_().f_35937_ && carried.m_41619_() && !(temp = this.handler.getStackInSlot(0)).m_41619_()) {
                ItemStack cloned = temp.m_41777_();
                cloned.m_41764_(cloned.m_41741_());
                this.m_142503_(cloned);
            }
        } else {
            super.m_150399_(slotId, button, clickType, player);
        }
    }

    private static class DummyHandler
    implements IItemHandlerModifiable {
        private ItemStack template = ItemStack.f_41583_;

        private DummyHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? this.template.m_41777_() : ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot != 0 || stack.m_41619_()) {
                return stack;
            }
            if (simulate) {
                return ItemStack.f_41583_;
            }
            this.template = stack.m_41777_();
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0 || this.template.m_41619_() || amount <= 0) {
                return ItemStack.f_41583_;
            }
            ItemStack out = this.template.m_41777_();
            out.m_41764_(Math.min(amount, this.template.m_41613_()));
            return out;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? (this.template.m_41619_() ? 64 : this.template.m_41741_()) : 0;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return slot == 0 && !stack.m_41619_();
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                this.template = stack.m_41777_();
            }
        }
    }
}

