/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.logic;

import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import mctmods.immersivetechnology.common.blocks.helper.ITServerTickableBE;
import mctmods.immersivetechnology.common.blocks.metal.ValveLimiterBlock;
import mctmods.immersivetechnology.common.blocks.metal.gui.ValveLimiterMenu;
import mctmods.immersivetechnology.common.blocks.metal.logic.ValveCommonBlockEntity;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.registration.ITBlockEntities;
import mctmods.immersivetechnology.core.registration.ITMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ValveLimiterBlockEntity
extends ValveCommonBlockEntity
implements ITServerTickableBE,
IItemHandler {
    public int rotation = 0;
    private LazyOptional<IItemHandler> myCapability = null;
    private LazyOptional<IItemHandler> dummyCapability = null;
    boolean busy = false;

    public ValveLimiterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ITBlockEntities.VALVE_LIMITER.get(), pos, state, TranslationKey.OVERLAY_OSD_VALVE_LIMITER_NORMAL_FIRST_LINE, TranslationKey.OVERLAY_OSD_VALVE_LIMITER_SNEAKING_FIRST_LINE, TranslationKey.OVERLAY_OSD_VALVE_LIMITER_SNEAKING_SECOND_LINE, 2);
    }

    @Override
    public void tickServer() {
        this.updateBase();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            this.efficientSetChanged();
            for (Direction d : Direction.values()) {
                this.f_58857_.m_46586_(this.f_58858_.m_121945_(d), this.m_58900_().m_60734_(), this.f_58858_);
            }
            this.markContainingBlockForUpdate(null);
            this.updateRedstoneState();
        }
        this.rotation = (Integer)this.m_58900_().m_61143_((Property)ValveLimiterBlock.ROTATION);
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        super.onNeighborBlockChange(otherPos);
        this.updateRedstoneState();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        if (facing == null) {
            return super.getCapability(capability, null);
        }
        BlockState state = this.m_58900_();
        Direction blockFacing = (Direction)state.m_61143_((Property)ITProperties.FACING_ALL);
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing.m_122434_() == blockFacing.m_122434_()) {
            if (facing == blockFacing) {
                if (this.myCapability == null || !this.myCapability.isPresent()) {
                    this.myCapability = LazyOptional.of(() -> this);
                }
                return this.myCapability.cast();
            }
            if (facing == blockFacing.m_122424_()) {
                if (this.dummyCapability == null || !this.dummyCapability.isPresent()) {
                    this.dummyCapability = LazyOptional.of(() -> new OutputItemHandler(this));
                }
                return this.dummyCapability.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.myCapability != null) {
            this.myCapability.invalidate();
            this.myCapability = null;
        }
        if (this.dummyCapability != null) {
            this.dummyCapability.invalidate();
            this.dummyCapability = null;
        }
    }

    @Override
    public void setFacing(@NotNull Direction facing) {
        super.setFacing(facing);
    }

    public int getSlots() {
        IItemHandler dest = this.getDestination();
        return dest != null ? dest.getSlots() : 0;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        IItemHandler dest = this.getDestination();
        return dest != null ? dest.getStackInSlot(slot) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return stack;
        }
        if (this.busy) {
            return stack;
        }
        BlockState state = this.m_58900_();
        if (!((Boolean)state.m_61143_((Property)ValveLimiterBlock.OPEN)).booleanValue()) {
            return stack;
        }
        IItemHandler dest = this.getDestination();
        if (dest == null) {
            return stack;
        }
        int canAccept = stack.m_41613_();
        canAccept = this.timeLimit > 0 ? Math.min(Math.max(this.timeLimit - ValveCommonBlockEntity.longToInt(this.acceptedAmount), 0), canAccept) : canAccept;
        canAccept = this.keepSize > 0 ? Math.min(Math.max(this.keepSize - ValveLimiterBlockEntity.getInventoryFill(dest, stack), 0), canAccept) : canAccept;
        int n = canAccept = this.packetLimit > 0 ? Math.min(canAccept, this.packetLimit) : canAccept;
        if (this.redstoneMode > 0) {
            canAccept = (int)((double)canAccept * ((double)(this.redstoneMode == 1 ? 15 - this.getRSPower() : this.getRSPower()) / 15.0));
        }
        if (canAccept == 0) {
            return stack;
        }
        ItemStack insertStack = stack.m_41777_();
        insertStack.m_41764_(canAccept);
        this.busy = true;
        ItemStack remaining = dest.insertItem(slot, insertStack, simulate);
        this.busy = false;
        int inserted = canAccept - remaining.m_41613_();
        if (!simulate) {
            this.acceptedAmount += (long)inserted;
            ++this.packets;
        }
        ItemStack toReturn = stack.m_41777_();
        toReturn.m_41764_(stack.m_41613_() - inserted);
        return toReturn;
    }

    public static int getInventoryFill(IItemHandler handler, ItemStack toInsert) {
        int toReturn = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stored = handler.getStackInSlot(i);
            if (stored.m_41619_() || !stored.m_150930_(toInsert.m_41720_())) continue;
            toReturn += stored.m_41613_();
        }
        return toReturn;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        IItemHandler dest = this.getDestination();
        return dest != null ? dest.getSlotLimit(slot) : 0;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        IItemHandler dest = this.getDestination();
        return dest != null && dest.isItemValid(slot, stack);
    }

    public IItemHandler getDestination() {
        assert (this.f_58857_ != null);
        BlockState state = this.m_58900_();
        Direction blockFacing = (Direction)state.m_61143_((Property)ITProperties.FACING_ALL);
        BlockPos dstPos = this.f_58858_.m_121945_(blockFacing.m_122424_());
        BlockEntity dst = this.f_58857_.m_7702_(dstPos);
        if (dst != null) {
            LazyOptional cap = dst.getCapability(ForgeCapabilities.ITEM_HANDLER, blockFacing);
            return cap.resolve().orElse(null);
        }
        return null;
    }

    public IItemHandler getSource() {
        assert (this.f_58857_ != null);
        BlockState state = this.m_58900_();
        Direction blockFacing = (Direction)state.m_61143_((Property)ITProperties.FACING_ALL);
        BlockPos srcPos = this.f_58858_.m_121945_(blockFacing);
        BlockEntity src = this.f_58857_.m_7702_(srcPos);
        if (src != null) {
            LazyOptional cap = src.getCapability(ForgeCapabilities.ITEM_HANDLER, blockFacing.m_122424_());
            return cap.resolve().orElse(null);
        }
        return null;
    }

    @Override
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return ValveLimiterMenu.makeServer(ITMenuTypes.VALVE_LIMITER.getType(), id, inv, this);
    }

    @Override
    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)TranslationKey.GUI_VALVE_LIMITER.location);
    }

    @Override
    public void receiveMessageFromServer(CompoundTag nbt) {
        this.packetLimit = nbt.m_128451_("packetLimit");
        this.timeLimit = nbt.m_128451_("timeLimit");
        this.keepSize = nbt.m_128451_("keepSize");
    }

    @Override
    public void receiveMessageFromClient(CompoundTag nbt) {
        this.packetLimit = nbt.m_128451_("packetLimit");
        this.timeLimit = nbt.m_128451_("timeLimit");
        this.keepSize = nbt.m_128451_("keepSize");
        this.efficientSetChanged();
    }

    @Override
    public boolean stillValid(Player player) {
        return !this.m_58901_() && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public boolean hammerUseSide(@NotNull Direction side, @NotNull Player player, @NotNull InteractionHand hand, @NotNull Vec3 hit) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return false;
        }
        boolean counter = player.m_6144_() != (side == Direction.DOWN);
        Direction oldFacing = this.facing;
        Direction newFacing = counter ? oldFacing.m_175364_(side.m_122434_()) : oldFacing.m_175362_(side.m_122434_());
        this.setFacing(newFacing);
        return true;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.rotation = nbt.m_128451_("rotation");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128405_("rotation", this.rotation);
    }

    public record OutputItemHandler(ValveLimiterBlockEntity be) implements IItemHandler
    {
        public int getSlots() {
            return this.be.getSource() != null ? this.be.getSource().getSlots() : 0;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.be.getSource() != null ? this.be.getSource().getStackInSlot(slot) : ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            assert (this.be.f_58857_ != null);
            if (((ValveLimiterBlockEntity)this.be).f_58857_.f_46443_) {
                return ItemStack.f_41583_;
            }
            if (this.be.busy) {
                return ItemStack.f_41583_;
            }
            BlockState state = this.be.m_58900_();
            if (!((Boolean)state.m_61143_((Property)ValveLimiterBlock.OPEN)).booleanValue()) {
                return ItemStack.f_41583_;
            }
            IItemHandler src = this.be.getSource();
            if (src == null) {
                return ItemStack.f_41583_;
            }
            int canAccept = amount;
            canAccept = this.be.timeLimit > 0 ? Math.min(Math.max(this.be.timeLimit - ValveCommonBlockEntity.longToInt(this.be.acceptedAmount), 0), canAccept) : canAccept;
            int n = canAccept = this.be.packetLimit > 0 ? Math.min(canAccept, this.be.packetLimit) : canAccept;
            if (this.be.redstoneMode > 0) {
                canAccept = (int)((double)canAccept * ((double)(this.be.redstoneMode == 1 ? 15 - this.be.getRSPower() : this.be.getRSPower()) / 15.0));
            }
            if (canAccept == 0) {
                return ItemStack.f_41583_;
            }
            this.be.busy = true;
            ItemStack extracted = src.extractItem(slot, canAccept, simulate);
            this.be.busy = false;
            if (!simulate && !extracted.m_41619_()) {
                this.be.acceptedAmount += (long)extracted.m_41613_();
                ++this.be.packets;
            }
            return extracted;
        }

        public int getSlotLimit(int slot) {
            return this.be.getSource() != null ? this.be.getSource().getSlotLimit(slot) : 0;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

