/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.logic;

import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlockEntity;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import mctmods.immersivetechnology.common.blocks.helper.ITServerTickableBE;
import mctmods.immersivetechnology.common.blocks.metal.ValveFluidBlock;
import mctmods.immersivetechnology.common.blocks.metal.gui.ValveFluidMenu;
import mctmods.immersivetechnology.common.blocks.metal.logic.ValveCommonBlockEntity;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.registration.ITBlockEntities;
import mctmods.immersivetechnology.core.registration.ITMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class ValveFluidBlockEntity
extends ValveCommonBlockEntity
implements ITServerTickableBE,
IFluidHandler,
IFluidPipe {
    public int rotation = 0;
    private LazyOptional<IFluidHandler> myCapability = null;
    private LazyOptional<IFluidHandler> dummyCapability = null;
    boolean busy = false;

    public ValveFluidBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ITBlockEntities.VALVE_FLUID.get(), pos, state, TranslationKey.OVERLAY_OSD_VALVE_FLUID_NORMAL_FIRST_LINE, TranslationKey.OVERLAY_OSD_VALVE_FLUID_SNEAKING_FIRST_LINE, TranslationKey.OVERLAY_OSD_VALVE_FLUID_SNEAKING_SECOND_LINE, 0);
    }

    @Override
    public void tickServer() {
        this.updateBase();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            this.efficientSetChanged();
            for (Direction d : Direction.values()) {
                this.f_58857_.m_46586_(this.f_58858_.m_121945_(d), this.m_58900_().m_60734_(), this.f_58858_);
            }
            this.markContainingBlockForUpdate(null);
            this.updateRedstoneState();
        }
        this.rotation = (Integer)this.m_58900_().m_61143_((Property)ValveFluidBlock.ROTATION);
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        super.onNeighborBlockChange(otherPos);
        this.updateRedstoneState();
    }

    public boolean canOutputPressurized(boolean consumePower) {
        return true;
    }

    public boolean hasOutputConnection(Direction side) {
        return side == ((Direction)this.m_58900_().m_61143_((Property)ITProperties.FACING_ALL)).m_122424_();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        if (facing == null) {
            return super.getCapability(capability, null);
        }
        BlockState state = this.m_58900_();
        Direction blockFacing = (Direction)state.m_61143_((Property)ITProperties.FACING_ALL);
        if (capability == ForgeCapabilities.FLUID_HANDLER && facing.m_122434_() == blockFacing.m_122434_()) {
            if (facing == blockFacing) {
                if (this.myCapability == null || !this.myCapability.isPresent()) {
                    this.myCapability = LazyOptional.of(() -> this);
                }
                return this.myCapability.cast();
            }
            if (facing == blockFacing.m_122424_()) {
                if (this.dummyCapability == null || !this.dummyCapability.isPresent()) {
                    this.dummyCapability = LazyOptional.of(DummyTank::new);
                }
                return this.dummyCapability.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.myCapability != null) {
            this.myCapability.invalidate();
            this.myCapability = null;
        }
        if (this.dummyCapability != null) {
            this.dummyCapability.invalidate();
            this.dummyCapability = null;
        }
    }

    @Override
    public void setFacing(@NotNull Direction facing) {
        this.facing = facing;
        this.invalidateCaps();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.m_58900_();
            if (state.m_61138_((Property)ITProperties.FACING_ALL)) {
                int newRot = this.rotation;
                Direction currentFacing = (Direction)state.m_61143_((Property)ITProperties.FACING_ALL);
                if (facing.m_122434_() == Direction.Axis.Y) {
                    if (currentFacing.m_122434_() != Direction.Axis.Y) {
                        newRot = currentFacing.m_122416_();
                    }
                } else {
                    newRot = facing.m_122416_();
                }
                state = (BlockState)((BlockState)state.m_61124_((Property)ITProperties.FACING_ALL, (Comparable)facing)).m_61124_((Property)ValveFluidBlock.ROTATION, (Comparable)Integer.valueOf(newRot));
                this.f_58857_.m_7731_(this.f_58858_, state, 3);
                this.rotation = newRot;
            }
            this.markContainingBlockForUpdate(null);
            this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
            for (Direction d : Direction.values()) {
                BlockPos adjPos = this.f_58858_.m_121945_(d);
                BlockEntity adj = this.f_58857_.m_7702_(adjPos);
                if (adj instanceof FluidPipeBlockEntity) {
                    FluidPipeBlockEntity pipe = (FluidPipeBlockEntity)adj;
                    Direction pipeSide = d.m_122424_();
                    pipe.updateConnectionByte(pipeSide);
                    pipe.markContainingBlockForUpdate(null);
                    pipe.m_6596_();
                } else if (adj != null) {
                    adj.invalidateCaps();
                    adj.m_6596_();
                }
                this.f_58857_.m_46586_(adjPos, this.f_58857_.m_8055_(adjPos).m_60734_(), this.f_58858_);
            }
        }
        this.efficientSetChanged();
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction doFill) {
        boolean hadTag;
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return 0;
        }
        if (this.busy) {
            return 0;
        }
        BlockState state = this.m_58900_();
        if (!((Boolean)state.m_61143_((Property)ValveFluidBlock.OPEN)).booleanValue()) {
            return 0;
        }
        Direction blockFacing = (Direction)state.m_61143_((Property)ITProperties.FACING_ALL);
        IFluidHandler destination = this.getDestination();
        if (destination == null) {
            return 0;
        }
        int canAccept = fluidStack.getAmount();
        canAccept = this.timeLimit > 0 ? Math.min(Math.max(this.timeLimit - ValveCommonBlockEntity.longToInt(this.acceptedAmount), 0), canAccept) : canAccept;
        canAccept = this.keepSize > 0 ? Math.min(Math.max(this.keepSize - ValveFluidBlockEntity.getTankFill(destination, fluidStack), 0), canAccept) : canAccept;
        int n = canAccept = this.packetLimit > 0 ? Math.min(canAccept, this.packetLimit) : canAccept;
        if (this.redstoneMode > 0) {
            canAccept = (int)((double)canAccept * ((double)(this.redstoneMode == 1 ? 15 - this.getRSPower() : this.getRSPower()) / 15.0));
        }
        if (canAccept == 0) {
            return 0;
        }
        BlockEntity dst = this.f_58857_.m_7702_(this.f_58858_.m_121945_(blockFacing.m_122424_()));
        boolean isPipe = dst instanceof FluidPipeBlockEntity;
        FluidStack fillStack = new FluidStack(fluidStack.getFluid(), canAccept, fluidStack.getTag());
        boolean bl = hadTag = fillStack.hasTag() && fillStack.getTag().m_128441_("pressurized");
        if (isPipe && !hadTag) {
            fillStack.getOrCreateTag().m_128379_("pressurized", true);
        }
        this.busy = true;
        int toReturn = destination.fill(fillStack, doFill);
        this.busy = false;
        if (!hadTag && fillStack.hasTag()) {
            fillStack.getTag().m_128473_("pressurized");
        }
        if (doFill == IFluidHandler.FluidAction.EXECUTE) {
            this.acceptedAmount += (long)toReturn;
            ++this.packets;
        }
        return toReturn;
    }

    public static int getTankFill(IFluidHandler handler, FluidStack toFill) {
        int toReturn = 0;
        for (int i = 0; i < handler.getTanks(); ++i) {
            FluidStack stored = handler.getFluidInTank(i);
            if (stored.isEmpty() || !stored.isFluidEqual(toFill)) continue;
            toReturn += stored.getAmount();
        }
        return toReturn;
    }

    @NotNull
    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction b) {
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int i, IFluidHandler.FluidAction b) {
        return FluidStack.EMPTY;
    }

    public IFluidHandler getDestination() {
        assert (this.f_58857_ != null);
        BlockState state = this.m_58900_();
        Direction blockFacing = (Direction)state.m_61143_((Property)ITProperties.FACING_ALL);
        BlockPos dstPos = this.f_58858_.m_121945_(blockFacing.m_122424_());
        BlockEntity dst = this.f_58857_.m_7702_(dstPos);
        if (dst != null) {
            LazyOptional cap = dst.getCapability(ForgeCapabilities.FLUID_HANDLER, blockFacing);
            return cap.resolve().orElse(null);
        }
        return null;
    }

    @Override
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return ValveFluidMenu.makeServer(ITMenuTypes.VALVE_FLUID.getType(), id, inv, this);
    }

    @Override
    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)TranslationKey.GUI_VALVE_FLUID.location);
    }

    @Override
    public void receiveMessageFromServer(CompoundTag nbt) {
        this.packetLimit = nbt.m_128451_("packetLimit");
        this.timeLimit = nbt.m_128451_("timeLimit");
        this.keepSize = nbt.m_128451_("keepSize");
    }

    @Override
    public void receiveMessageFromClient(CompoundTag nbt) {
        this.packetLimit = nbt.m_128451_("packetLimit");
        this.timeLimit = nbt.m_128451_("timeLimit");
        this.keepSize = nbt.m_128451_("keepSize");
        this.efficientSetChanged();
    }

    @Override
    public boolean stillValid(Player player) {
        return !this.m_58901_() && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public boolean hammerUseSide(@NotNull Direction side, @NotNull Player player, @NotNull InteractionHand hand, @NotNull Vec3 hit) {
        Direction newFacing;
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return false;
        }
        boolean counter = player.m_6144_() != (side == Direction.DOWN);
        Direction direction = newFacing = counter ? this.facing.m_175364_(side.m_122434_()) : this.facing.m_175362_(side.m_122434_());
        if (newFacing.m_122434_() == Direction.Axis.Y) {
            return false;
        }
        this.setFacing(newFacing);
        return true;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.rotation = nbt.m_128451_("rotation");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128405_("rotation", this.rotation);
    }

    public static class DummyTank
    implements IFluidHandler {
        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 0;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction b) {
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction b) {
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int i, IFluidHandler.FluidAction b) {
            return FluidStack.EMPTY;
        }
    }
}

