/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.logic;

import mctmods.immersivetechnology.api.MechanicalCapabilities;
import mctmods.immersivetechnology.api.capability.IMechanicalEnergyProvider;
import mctmods.immersivetechnology.common.blocks.helper.ITBaseBlockEntity;
import mctmods.immersivetechnology.common.blocks.helper.ITClientTickableBE;
import mctmods.immersivetechnology.common.blocks.metal.RotorCreativeBlock;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.registration.ITBlockEntities;
import mctmods.immersivetechnology.core.registration.ITMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RotorCreativeBlockEntity
extends ITBaseBlockEntity
implements MenuProvider,
ITClientTickableBE {
    public int rpm = 7200;
    private final LazyOptional<IMechanicalEnergyProvider> providerCap = LazyOptional.of(() -> new Provider());
    public float animation_rotation = 0.0f;
    public float animation_step = 0.0f;

    public RotorCreativeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ITBlockEntities.ROTOR_CREATIVE.get(), pos, state);
    }

    @Override
    public void tickClient() {
        this.animation_step = (float)Math.abs(this.rpm) / 7200.0f * 72.0f;
        float dir = Math.signum(this.rpm);
        this.animation_rotation += this.animation_step * dir;
        this.animation_rotation %= 360.0f;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_(RotorCreativeBlock.FACING);
        if ((side == facing || side == facing.m_122424_()) && cap == MechanicalCapabilities.MECHANICAL_PROVIDER_CAPABILITY) {
            return this.providerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.rpm = nbt.m_128451_("rpm");
        if (descPacket) {
            this.animation_rotation = nbt.m_128457_("animation_rotation");
            this.animation_step = nbt.m_128457_("animation_step");
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128405_("rpm", this.rpm);
        if (descPacket) {
            nbt.m_128350_("animation_rotation", this.animation_rotation);
            nbt.m_128350_("animation_step", this.animation_step);
        }
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.m_128441_("rpm")) {
            int newRpm = message.m_128451_("rpm");
            this.rpm = Math.max(Math.min(newRpm, 7200), -7200);
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
    }

    public boolean stillValid(Player player) {
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) < 64.0;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return ITMenuTypes.ROTOR_CREATIVE.create(id, inv, this);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)TranslationKey.GUI_ROTOR_CREATIVE.getLocation());
    }

    private class Provider
    implements IMechanicalEnergyProvider {
        private Provider() {
        }

        @Override
        public int getSpeed() {
            return RotorCreativeBlockEntity.this.rpm;
        }

        @Override
        public float getTorque() {
            return 1.0f;
        }

        @Override
        public int getMaxSpeed() {
            return 7200;
        }

        @Override
        public double getBaseMass() {
            return 0.0;
        }

        @Override
        public double getDriveTorque() {
            return 0.0;
        }

        @Override
        public double getFriction() {
            return 0.0;
        }
    }
}

