/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.gui;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import mctmods.immersivetechnology.common.blocks.metal.logic.TrashItemBlockEntity;
import mctmods.immersivetechnology.common.gui.helper.ITContainerMenu;
import mctmods.immersivetechnology.common.gui.helper.ITGenericDataSerializers;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class TrashItemMenu
extends ITContainerMenu {
    private final IItemHandlerModifiable handler;
    private final TrashItemBlockEntity tile;

    public TrashItemMenu(MenuType<TrashItemMenu> type, int id, Inventory inv, TrashItemBlockEntity tile) {
        super(ITContainerMenu.blockCtx(type, id, tile));
        this.handler = tile;
        this.tile = tile;
        this.addOwnSlots();
        this.addPlayerSlots(inv);
    }

    public TrashItemMenu(MenuType<TrashItemMenu> type, int id, Inventory inv) {
        super(ITContainerMenu.clientCtx(type, id));
        this.handler = new DummyHandler();
        this.tile = null;
        this.addOwnSlots();
        this.addPlayerSlots(inv);
    }

    public static TrashItemMenu makeServer(MenuType<TrashItemMenu> type, int id, Inventory inv, TrashItemBlockEntity tile) {
        return new TrashItemMenu(type, id, inv, tile);
    }

    public static TrashItemMenu makeClient(MenuType<TrashItemMenu> type, int id, Inventory inv) {
        return new TrashItemMenu(type, id, inv);
    }

    private void addOwnSlots() {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.handler, 0, 79, 36));
        this.ownSlotCount = 1;
    }

    private void addPlayerSlots(Inventory inv) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inv, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inv, x, 8 + x * 18, 142));
        }
    }

    @Override
    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_6657_()) {
            ItemStack itemStack1 = slot.m_7993_();
            itemstack = itemStack1.m_41777_();
            if (pIndex < 1 ? !this.m_38903_(itemStack1, 1, 37, true) : !this.m_38903_(itemStack1, 0, 1, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    @Override
    public boolean m_6875_(@NotNull Player player) {
        return this.tile == null || this.tile.m_6542_(player);
    }

    @Override
    public void receiveSync(List<Pair<Integer, ITGenericDataSerializers.DataPair<?>>> synced) {
    }

    private static class DummyHandler
    implements IItemHandlerModifiable {
        private DummyHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        }
    }
}

