/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.helper;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.common.blocks.helper.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.helper.ITModelOffsetProvider;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public abstract class ITBaseBlockEntity
extends BlockEntity
implements ITBlockInterfaces.BlockStateProvider {
    @Nullable
    private BlockState overrideBlockState = null;
    private final EnumMap<Direction, Integer> redstoneBySide = new EnumMap(Direction.class);
    private boolean isUnloaded = false;

    public ITBaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(@NotNull CompoundTag nbtIn) {
        super.m_142466_(nbtIn);
        this.readCustomNBT(nbtIn, false);
    }

    public abstract void readCustomNBT(CompoundTag var1, boolean var2);

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        this.writeCustomNBT(nbt, false);
    }

    public abstract void writeCustomNBT(CompoundTag var1, boolean var2);

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, be -> {
            CompoundTag nbtTagCompound = new CompoundTag();
            this.writeCustomNBT(nbtTagCompound, true);
            return nbtTagCompound;
        });
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nonNullTag = pkt.m_131708_() != null ? pkt.m_131708_() : new CompoundTag();
        this.readCustomNBT(nonNullTag, true);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readCustomNBT(tag, true);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.writeCustomNBT(nbt, true);
        return nbt;
    }

    public void receiveMessageFromClient(CompoundTag message) {
    }

    public void receiveMessageFromServer(CompoundTag message) {
    }

    public boolean m_7531_(int id, int type) {
        if (id == 0 || id == 255) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        if (id == 254) {
            assert (this.f_58857_ != null);
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void markContainingBlockForUpdate(@Nullable BlockState newState) {
        if (this.f_58857_ != null) {
            this.markBlockForUpdate(this.m_58899_(), newState);
        }
    }

    public void markBlockForUpdate(BlockPos pos, @Nullable BlockState newState) {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(pos);
        if (newState == null) {
            newState = state;
        }
        this.f_58857_.m_7260_(pos, state, newState, 3);
        this.f_58857_.m_46672_(pos, newState.m_60734_());
    }

    public void m_7651_() {
        if (!this.isUnloaded) {
            this.setRemovedIE();
        }
        super.m_7651_();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
    }

    public void onLoad() {
        super.onLoad();
        this.isUnloaded = false;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.isUnloaded = true;
    }

    public void setRemovedIE() {
    }

    @Nonnull
    public Level getLevelNonnull() {
        return Objects.requireNonNull(super.m_58904_());
    }

    public void onEntityCollision(Level world, Entity entity) {
    }

    public void setOverrideState(@Nullable BlockState state) {
        this.overrideBlockState = state;
    }

    @NotNull
    public BlockState m_58900_() {
        if (this.overrideBlockState != null) {
            return this.overrideBlockState;
        }
        return super.m_58900_();
    }

    public void m_155250_(@NotNull BlockState newState) {
        BlockState old = this.m_58900_();
        super.m_155250_(newState);
        if (this.m_58903_().m_155262_(old) && !this.m_58903_().m_155262_(newState)) {
            this.setOverrideState(old);
        } else if (this.m_58903_().m_155262_(newState)) {
            this.setOverrideState(null);
        }
    }

    @Override
    public void setState(BlockState state) {
        if (this.getLevelNonnull().m_8055_(this.f_58858_) == this.getState()) {
            this.getLevelNonnull().m_46597_(this.f_58858_, state);
        }
    }

    @Override
    public BlockState getState() {
        return this.m_58900_();
    }

    protected void markChunkDirty() {
        if (this.f_58857_ != null && this.f_58857_.m_7232_(this.f_58858_.m_123341_() >> 4, this.f_58858_.m_123343_() >> 4)) {
            this.f_58857_.m_46745_(this.f_58858_).m_8092_(true);
        }
    }

    public void m_142339_(@NotNull Level world) {
        super.m_142339_(world);
        this.redstoneBySide.clear();
    }

    @NotNull
    public ModelData getModelData() {
        BlockPos offset = null;
        BlockState state = this.getState();
        ITBaseBlockEntity iTBaseBlockEntity = this;
        if (iTBaseBlockEntity instanceof ITModelOffsetProvider) {
            ITModelOffsetProvider offsetProvider = (ITModelOffsetProvider)((Object)iTBaseBlockEntity);
            offset = offsetProvider.getModelOffset(state, Vec3i.f_123288_);
        } else {
            iTBaseBlockEntity = state.m_60734_();
            if (iTBaseBlockEntity instanceof ITModelOffsetProvider) {
                ITModelOffsetProvider offsetProvider = (ITModelOffsetProvider)((Object)iTBaseBlockEntity);
                offset = offsetProvider.getModelOffset(state, Vec3i.f_123288_);
            }
        }
        if (offset != null) {
            return ModelData.builder().with(ITProperties.Model.SUBMODEL_OFFSET, (Object)offset).build();
        }
        return ModelData.EMPTY;
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.markChunkDirty();
            BlockState state = this.m_58900_();
            if (state.m_60807_()) {
                this.f_58857_.m_46717_(this.f_58858_, state.m_60734_());
            }
        }
    }

    protected void onNeighborBlockChange(BlockPos otherPos) {
        BlockPos delta = otherPos.m_121996_((Vec3i)this.f_58858_);
        Direction side = Direction.m_122372_((float)delta.m_123341_(), (float)delta.m_123342_(), (float)delta.m_123343_());
        Preconditions.checkNotNull((Object)side);
        this.updateRSForSide(side);
    }

    private void updateRSForSide(Direction side) {
        int rsStrength = this.getLevelNonnull().m_277185_(this.f_58858_.m_121945_(side), side);
        if (rsStrength == 0 && this instanceof ITBlockInterfaces.IRedstoneOutput && ((ITBlockInterfaces.IRedstoneOutput)((Object)this)).canConnectRedstone(side)) {
            assert (this.f_58857_ != null);
            BlockState state = this.f_58857_.m_8055_(this.f_58858_.m_121945_(side));
            if (state.m_60734_() == Blocks.f_50088_ && (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_) > rsStrength) {
                rsStrength = (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_);
            }
        }
        this.redstoneBySide.put(side, rsStrength);
    }

    protected int getRSInput(Direction from) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_ || !this.redstoneBySide.containsKey(from)) {
            this.updateRSForSide(from);
        }
        return this.redstoneBySide.get(from);
    }

    protected boolean isRSPowered() {
        for (Direction d : Direction.values()) {
            if (this.getRSInput(d) <= 0) continue;
            return true;
        }
        return false;
    }
}

