/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.helper;

import java.util.Objects;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.common.blocks.helper.ITBlock;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import mctmods.immersivetechnology.core.registration.ITTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ITBaseBlock
extends Block
implements ITBlock,
SimpleWaterloggedBlock {
    protected final boolean notNormalBlock;
    private final boolean fitsIntoContainer;
    boolean hasFlavour;

    public ITBaseBlock(BlockBehaviour.Properties blockProps, boolean fitsIntoContainer) {
        super(blockProps);
        this.fitsIntoContainer = fitsIntoContainer;
        this.notNormalBlock = !this.m_49966_().m_60815_();
        this.m_49959_(this.getInitDefaultState());
    }

    @Override
    public String getNameForFlavour() {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)this)).m_135815_();
    }

    @Override
    public boolean hasFlavour() {
        return this.hasFlavour;
    }

    public int m_7753_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return this.notNormalBlock ? 0 : super.m_7753_(state, worldIn, pos);
    }

    public float m_7749_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return this.notNormalBlock ? 1.0f : super.m_7749_(state, world, pos);
    }

    public boolean m_7420_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return this.notNormalBlock || super.m_7420_(state, reader, pos);
    }

    protected BlockState getInitDefaultState() {
        BlockState state = (BlockState)this.f_49792_.m_61090_();
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.FALSE);
        }
        return state;
    }

    public void onIEBlockPlacedBy(BlockPlaceContext context, BlockState state) {
    }

    public boolean canIEBlockBePlaced(BlockState newState, BlockPlaceContext context) {
        return true;
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    public boolean m_8133_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, int eventID, int eventParam) {
        if (worldIn.f_46443_ && eventID == 255) {
            worldIn.m_7260_(pos, state, state, 3);
            return true;
        }
        return super.m_8133_(state, worldIn, pos, eventID, eventParam);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ItemStack activeStack = player.m_21120_(hand);
        if (activeStack.m_204117_(ITTags.formationTools)) {
            return this.hammerUseSide(hit.m_82434_(), player, hand, world, pos, hit);
        }
        if (activeStack.m_204117_(ITTags.screwdrivers)) {
            return this.screwdriverUseSide(hit.m_82434_(), player, hand, world, pos, hit);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public InteractionResult hammerUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    public static BlockState applyLocationalWaterlogging(BlockState state, Level world, BlockPos pos) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        state = ITBaseBlock.applyLocationalWaterlogging(state, context.m_43725_(), context.m_8083_());
        return state;
    }

    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (stateIn.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)stateIn.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            worldIn.m_183324_().m_183393_(new ScheduledTick((Object)Fluids.f_76193_, currentPos, (long)Fluids.f_76193_.m_6718_((LevelReader)worldIn), 0L));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_6044_(@NotNull BlockGetter worldIn, @NotNull BlockPos pos, BlockState state, @NotNull Fluid fluidIn) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) && super.m_6044_(worldIn, pos, state, fluidIn);
    }

    public boolean m_7361_(@NotNull LevelAccessor worldIn, @NotNull BlockPos pos, BlockState state, @NotNull FluidState fluidStateIn) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) && super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    @NotNull
    public ItemStack m_142598_(@NotNull LevelAccessor level, @NotNull BlockPos pos, BlockState state) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) ? super.m_142598_(level, pos, state) : ItemStack.f_41583_;
    }

    public boolean fitsIntoContainer() {
        return this.fitsIntoContainer;
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, @NotNull Rotation rot) {
        Property<Direction> facingProp = this.findFacingProperty(state);
        if (facingProp != null && this.canRotate()) {
            Direction currentDirection = (Direction)state.m_61143_(facingProp);
            Direction newDirection = rot.m_55954_(currentDirection);
            return (BlockState)state.m_61124_(facingProp, (Comparable)newDirection);
        }
        return super.m_6843_(state, rot);
    }

    @NotNull
    public BlockState m_6943_(BlockState state, @NotNull Mirror mirrorIn) {
        if (state.m_61138_((Property)ITProperties.MIRRORED) && this.canRotate() && mirrorIn == Mirror.LEFT_RIGHT) {
            return (BlockState)state.m_61124_((Property)ITProperties.MIRRORED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)ITProperties.MIRRORED) == false));
        }
        Property<Direction> facingProp = this.findFacingProperty(state);
        if (facingProp != null && this.canRotate()) {
            Direction currentDirection = (Direction)state.m_61143_(facingProp);
            Direction newDirection = mirrorIn.m_54848_(currentDirection);
            return (BlockState)state.m_61124_(facingProp, (Comparable)newDirection);
        }
        return super.m_6943_(state, mirrorIn);
    }

    @Nullable
    private Property<Direction> findFacingProperty(BlockState state) {
        if (state.m_61138_((Property)ITProperties.FACING_ALL)) {
            return ITProperties.FACING_ALL;
        }
        return state.m_61138_((Property)ITProperties.FACING_HORIZONTAL) ? ITProperties.FACING_HORIZONTAL : null;
    }

    protected boolean canRotate() {
        return !this.m_49965_().m_61092_().contains(ITProperties.MULTIBLOCKSLAVE);
    }
}

